<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopTimetableRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Stop Timetables.
 * @subpackage Structs
 */
class StopTimetableRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The DepartureWindow
     * @var \StructType\ClosedTimestampRangeStructure
     */
    public $DepartureWindow;
    /**
     * The MonitoringRef
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopTimetableRequestStructure
     * @uses StopTimetableRequestStructure::setDepartureWindow()
     * @uses StopTimetableRequestStructure::setMonitoringRef()
     * @uses StopTimetableRequestStructure::setLineRef()
     * @uses StopTimetableRequestStructure::setDirectionRef()
     * @uses StopTimetableRequestStructure::setLanguage()
     * @uses StopTimetableRequestStructure::setIncludeTranslations()
     * @uses StopTimetableRequestStructure::setExtensions()
     * @uses StopTimetableRequestStructure::setVersion()
     * @param \StructType\ClosedTimestampRangeStructure $departureWindow
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param string $language
     * @param bool $includeTranslations
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ClosedTimestampRangeStructure $departureWindow = null, \StructType\MonitoringRefStructure $monitoringRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, $language = null, $includeTranslations = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setDepartureWindow($departureWindow)
            ->setMonitoringRef($monitoringRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get DepartureWindow value
     * @return \StructType\ClosedTimestampRangeStructure|null
     */
    public function getDepartureWindow()
    {
        return $this->DepartureWindow;
    }
    /**
     * Set DepartureWindow value
     * @param \StructType\ClosedTimestampRangeStructure $departureWindow
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setDepartureWindow(\StructType\ClosedTimestampRangeStructure $departureWindow = null)
    {
        $this->DepartureWindow = $departureWindow;
        return $this;
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopTimetableRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopTimetableRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
