<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopPointsDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response with STOP POINTs available to make requests.
 * @subpackage Structs
 */
class StopPointsDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The AnnotatedStopPointRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: AnnotatedStopPointRef
     * @var \StructType\AnnotatedStopPointStructure[]
     */
    public $AnnotatedStopPointRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopPointsDeliveryStructure
     * @uses StopPointsDeliveryStructure::setAnnotatedStopPointRef()
     * @uses StopPointsDeliveryStructure::setExtensions()
     * @uses StopPointsDeliveryStructure::setVersion()
     * @param \StructType\AnnotatedStopPointStructure[] $annotatedStopPointRef
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $annotatedStopPointRef = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setAnnotatedStopPointRef($annotatedStopPointRef)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get AnnotatedStopPointRef value
     * @return \StructType\AnnotatedStopPointStructure[]|null
     */
    public function getAnnotatedStopPointRef()
    {
        return $this->AnnotatedStopPointRef;
    }
    /**
     * Set AnnotatedStopPointRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedStopPointStructure[] $annotatedStopPointRef
     * @return \StructType\StopPointsDeliveryStructure
     */
    public function setAnnotatedStopPointRef(array $annotatedStopPointRef = array())
    {
        foreach ($annotatedStopPointRef as $stopPointsDeliveryStructureAnnotatedStopPointRefItem) {
            // validation for constraint: itemType
            if (!$stopPointsDeliveryStructureAnnotatedStopPointRefItem instanceof \StructType\AnnotatedStopPointStructure) {
                throw new \InvalidArgumentException(sprintf('The AnnotatedStopPointRef property can only contain items of \StructType\AnnotatedStopPointStructure, "%s" given', is_object($stopPointsDeliveryStructureAnnotatedStopPointRefItem) ? get_class($stopPointsDeliveryStructureAnnotatedStopPointRefItem) : gettype($stopPointsDeliveryStructureAnnotatedStopPointRefItem)), __LINE__);
            }
        }
        $this->AnnotatedStopPointRef = $annotatedStopPointRef;
        return $this;
    }
    /**
     * Add item to AnnotatedStopPointRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedStopPointStructure $item
     * @return \StructType\StopPointsDeliveryStructure
     */
    public function addToAnnotatedStopPointRef(\StructType\AnnotatedStopPointStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnnotatedStopPointStructure) {
            throw new \InvalidArgumentException(sprintf('The AnnotatedStopPointRef property can only contain items of \StructType\AnnotatedStopPointStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnnotatedStopPointRef[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopPointsDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopPointsDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopPointsDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
