<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopNoticeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notice for stop
 * @subpackage Structs
 */
class StopNoticeStructure extends AbstractRequiredIdentifiedItemStructure
{
    /**
     * The MonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a stop monitoring point to which SITUATION applies.
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The SituationRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: SituationRef
     * @var \StructType\SituationRefStructure[]
     */
    public $SituationRef;
    /**
     * The StopNote
     * Meta informations extracted from the WSDL
     * - documentation: Text associated with Stop Notice ed since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $StopNote;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StopNoticeStructure
     * @uses StopNoticeStructure::setMonitoringRef()
     * @uses StopNoticeStructure::setStopPointRef()
     * @uses StopNoticeStructure::setSituationRef()
     * @uses StopNoticeStructure::setStopNote()
     * @uses StopNoticeStructure::setExtensions()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param \StructType\SituationRefStructure[] $situationRef
     * @param \StructType\NaturalLanguageStringStructure[] $stopNote
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\StopPointRefStructure $stopPointRef = null, array $situationRef = array(), array $stopNote = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setStopPointRef($stopPointRef)
            ->setSituationRef($situationRef)
            ->setStopNote($stopNote)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopNoticeStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\StopNoticeStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure[]|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRefStructure[] $situationRef
     * @return \StructType\StopNoticeStructure
     */
    public function setSituationRef(array $situationRef = array())
    {
        foreach ($situationRef as $stopNoticeStructureSituationRefItem) {
            // validation for constraint: itemType
            if (!$stopNoticeStructureSituationRefItem instanceof \StructType\SituationRefStructure) {
                throw new \InvalidArgumentException(sprintf('The SituationRef property can only contain items of \StructType\SituationRefStructure, "%s" given', is_object($stopNoticeStructureSituationRefItem) ? get_class($stopNoticeStructureSituationRefItem) : gettype($stopNoticeStructureSituationRefItem)), __LINE__);
            }
        }
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Add item to SituationRef value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRefStructure $item
     * @return \StructType\StopNoticeStructure
     */
    public function addToSituationRef(\StructType\SituationRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SituationRefStructure) {
            throw new \InvalidArgumentException(sprintf('The SituationRef property can only contain items of \StructType\SituationRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SituationRef[] = $item;
        return $this;
    }
    /**
     * Get StopNote value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getStopNote()
    {
        return $this->StopNote;
    }
    /**
     * Set StopNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $stopNote
     * @return \StructType\StopNoticeStructure
     */
    public function setStopNote(array $stopNote = array())
    {
        foreach ($stopNote as $stopNoticeStructureStopNoteItem) {
            // validation for constraint: itemType
            if (!$stopNoticeStructureStopNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The StopNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($stopNoticeStructureStopNoteItem) ? get_class($stopNoticeStructureStopNoteItem) : gettype($stopNoticeStructureStopNoteItem)), __LINE__);
            }
        }
        $this->StopNote = $stopNote;
        return $this;
    }
    /**
     * Add item to StopNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\StopNoticeStructure
     */
    public function addToStopNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The StopNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopNote[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopNoticeStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopNoticeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
