<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopMonitoringMultipleRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Stop Monitoring Service on multiple stops.
 * @subpackage Structs
 */
class StopMonitoringMultipleRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The StopMonitoringFIlter
     * Meta informations extracted from the WSDL
     * - documentation: Request particulars for an individual stop as part of a list of multiple= requests.
     * - maxOccurs: unbounded
     * @var \StructType\StopMonitoringFilterStructure[]
     */
    public $StopMonitoringFIlter;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - use: optional
     * - documentation: A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopMonitoringMultipleRequestStructure
     * @uses StopMonitoringMultipleRequestStructure::setStopMonitoringFIlter()
     * @uses StopMonitoringMultipleRequestStructure::setVersion()
     * @param \StructType\StopMonitoringFilterStructure[] $stopMonitoringFIlter
     * @param string $version
     */
    public function __construct(array $stopMonitoringFIlter = array(), $version = '2.0')
    {
        $this
            ->setStopMonitoringFIlter($stopMonitoringFIlter)
            ->setVersion($version);
    }
    /**
     * Get StopMonitoringFIlter value
     * @return \StructType\StopMonitoringFilterStructure[]|null
     */
    public function getStopMonitoringFIlter()
    {
        return $this->StopMonitoringFIlter;
    }
    /**
     * Set StopMonitoringFIlter value
     * @throws \InvalidArgumentException
     * @param \StructType\StopMonitoringFilterStructure[] $stopMonitoringFIlter
     * @return \StructType\StopMonitoringMultipleRequestStructure
     */
    public function setStopMonitoringFIlter(array $stopMonitoringFIlter = array())
    {
        foreach ($stopMonitoringFIlter as $stopMonitoringMultipleRequestStructureStopMonitoringFIlterItem) {
            // validation for constraint: itemType
            if (!$stopMonitoringMultipleRequestStructureStopMonitoringFIlterItem instanceof \StructType\StopMonitoringFilterStructure) {
                throw new \InvalidArgumentException(sprintf('The StopMonitoringFIlter property can only contain items of \StructType\StopMonitoringFilterStructure, "%s" given', is_object($stopMonitoringMultipleRequestStructureStopMonitoringFIlterItem) ? get_class($stopMonitoringMultipleRequestStructureStopMonitoringFIlterItem) : gettype($stopMonitoringMultipleRequestStructureStopMonitoringFIlterItem)), __LINE__);
            }
        }
        $this->StopMonitoringFIlter = $stopMonitoringFIlter;
        return $this;
    }
    /**
     * Add item to StopMonitoringFIlter value
     * @throws \InvalidArgumentException
     * @param \StructType\StopMonitoringFilterStructure $item
     * @return \StructType\StopMonitoringMultipleRequestStructure
     */
    public function addToStopMonitoringFIlter(\StructType\StopMonitoringFilterStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopMonitoringFilterStructure) {
            throw new \InvalidArgumentException(sprintf('The StopMonitoringFIlter property can only contain items of \StructType\StopMonitoringFilterStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopMonitoringFIlter[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopMonitoringMultipleRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopMonitoringMultipleRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
