<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopMonitoringDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Stop Monitoring Service.
 * @subpackage Structs
 */
class StopMonitoringDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The MonitoringRef
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The MonitoringName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $MonitoringName;
    /**
     * The MonitoredStopVisit
     * @var \StructType\MonitoredStopVisitStructure
     */
    public $MonitoredStopVisit;
    /**
     * The MonitoredStopVisitCancellation
     * @var \StructType\MonitoredStopVisitCancellationStructure
     */
    public $MonitoredStopVisitCancellation;
    /**
     * The StopLineNotice
     * @var \StructType\StopLineNoticeStructure
     */
    public $StopLineNotice;
    /**
     * The StopLineNoticeCancellation
     * @var \StructType\StopLineNoticeCancellationStructure
     */
    public $StopLineNoticeCancellation;
    /**
     * The StopNotice
     * @var \StructType\StopNoticeStructure
     */
    public $StopNotice;
    /**
     * The StopNoticeCancellation
     * @var \StructType\StopNoticeCancellationStructure
     */
    public $StopNoticeCancellation;
    /**
     * The ServiceException
     * @var \StructType\ServiceExceptionStructure
     */
    public $ServiceException;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - documentation: Text associated with whole delivery. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Note;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for StopMonitoringDeliveryStructure
     * @uses StopMonitoringDeliveryStructure::setMonitoringRef()
     * @uses StopMonitoringDeliveryStructure::setMonitoringName()
     * @uses StopMonitoringDeliveryStructure::setMonitoredStopVisit()
     * @uses StopMonitoringDeliveryStructure::setMonitoredStopVisitCancellation()
     * @uses StopMonitoringDeliveryStructure::setStopLineNotice()
     * @uses StopMonitoringDeliveryStructure::setStopLineNoticeCancellation()
     * @uses StopMonitoringDeliveryStructure::setStopNotice()
     * @uses StopMonitoringDeliveryStructure::setStopNoticeCancellation()
     * @uses StopMonitoringDeliveryStructure::setServiceException()
     * @uses StopMonitoringDeliveryStructure::setNote()
     * @uses StopMonitoringDeliveryStructure::setExtensions()
     * @uses StopMonitoringDeliveryStructure::setVersion()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\NaturalLanguageStringStructure $monitoringName
     * @param \StructType\MonitoredStopVisitStructure $monitoredStopVisit
     * @param \StructType\MonitoredStopVisitCancellationStructure $monitoredStopVisitCancellation
     * @param \StructType\StopLineNoticeStructure $stopLineNotice
     * @param \StructType\StopLineNoticeCancellationStructure $stopLineNoticeCancellation
     * @param \StructType\StopNoticeStructure $stopNotice
     * @param \StructType\StopNoticeCancellationStructure $stopNoticeCancellation
     * @param \StructType\ServiceExceptionStructure $serviceException
     * @param \StructType\NaturalLanguageStringStructure[] $note
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\NaturalLanguageStringStructure $monitoringName = null, \StructType\MonitoredStopVisitStructure $monitoredStopVisit = null, \StructType\MonitoredStopVisitCancellationStructure $monitoredStopVisitCancellation = null, \StructType\StopLineNoticeStructure $stopLineNotice = null, \StructType\StopLineNoticeCancellationStructure $stopLineNoticeCancellation = null, \StructType\StopNoticeStructure $stopNotice = null, \StructType\StopNoticeCancellationStructure $stopNoticeCancellation = null, \StructType\ServiceExceptionStructure $serviceException = null, array $note = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setMonitoringName($monitoringName)
            ->setMonitoredStopVisit($monitoredStopVisit)
            ->setMonitoredStopVisitCancellation($monitoredStopVisitCancellation)
            ->setStopLineNotice($stopLineNotice)
            ->setStopLineNoticeCancellation($stopLineNoticeCancellation)
            ->setStopNotice($stopNotice)
            ->setStopNoticeCancellation($stopNoticeCancellation)
            ->setServiceException($serviceException)
            ->setNote($note)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get MonitoringName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getMonitoringName()
    {
        return $this->MonitoringName;
    }
    /**
     * Set MonitoringName value
     * @param \StructType\NaturalLanguageStringStructure $monitoringName
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setMonitoringName(\StructType\NaturalLanguageStringStructure $monitoringName = null)
    {
        $this->MonitoringName = $monitoringName;
        return $this;
    }
    /**
     * Get MonitoredStopVisit value
     * @return \StructType\MonitoredStopVisitStructure|null
     */
    public function getMonitoredStopVisit()
    {
        return $this->MonitoredStopVisit;
    }
    /**
     * Set MonitoredStopVisit value
     * @param \StructType\MonitoredStopVisitStructure $monitoredStopVisit
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setMonitoredStopVisit(\StructType\MonitoredStopVisitStructure $monitoredStopVisit = null)
    {
        $this->MonitoredStopVisit = $monitoredStopVisit;
        return $this;
    }
    /**
     * Get MonitoredStopVisitCancellation value
     * @return \StructType\MonitoredStopVisitCancellationStructure|null
     */
    public function getMonitoredStopVisitCancellation()
    {
        return $this->MonitoredStopVisitCancellation;
    }
    /**
     * Set MonitoredStopVisitCancellation value
     * @param \StructType\MonitoredStopVisitCancellationStructure $monitoredStopVisitCancellation
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setMonitoredStopVisitCancellation(\StructType\MonitoredStopVisitCancellationStructure $monitoredStopVisitCancellation = null)
    {
        $this->MonitoredStopVisitCancellation = $monitoredStopVisitCancellation;
        return $this;
    }
    /**
     * Get StopLineNotice value
     * @return \StructType\StopLineNoticeStructure|null
     */
    public function getStopLineNotice()
    {
        return $this->StopLineNotice;
    }
    /**
     * Set StopLineNotice value
     * @param \StructType\StopLineNoticeStructure $stopLineNotice
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setStopLineNotice(\StructType\StopLineNoticeStructure $stopLineNotice = null)
    {
        $this->StopLineNotice = $stopLineNotice;
        return $this;
    }
    /**
     * Get StopLineNoticeCancellation value
     * @return \StructType\StopLineNoticeCancellationStructure|null
     */
    public function getStopLineNoticeCancellation()
    {
        return $this->StopLineNoticeCancellation;
    }
    /**
     * Set StopLineNoticeCancellation value
     * @param \StructType\StopLineNoticeCancellationStructure $stopLineNoticeCancellation
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setStopLineNoticeCancellation(\StructType\StopLineNoticeCancellationStructure $stopLineNoticeCancellation = null)
    {
        $this->StopLineNoticeCancellation = $stopLineNoticeCancellation;
        return $this;
    }
    /**
     * Get StopNotice value
     * @return \StructType\StopNoticeStructure|null
     */
    public function getStopNotice()
    {
        return $this->StopNotice;
    }
    /**
     * Set StopNotice value
     * @param \StructType\StopNoticeStructure $stopNotice
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setStopNotice(\StructType\StopNoticeStructure $stopNotice = null)
    {
        $this->StopNotice = $stopNotice;
        return $this;
    }
    /**
     * Get StopNoticeCancellation value
     * @return \StructType\StopNoticeCancellationStructure|null
     */
    public function getStopNoticeCancellation()
    {
        return $this->StopNoticeCancellation;
    }
    /**
     * Set StopNoticeCancellation value
     * @param \StructType\StopNoticeCancellationStructure $stopNoticeCancellation
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setStopNoticeCancellation(\StructType\StopNoticeCancellationStructure $stopNoticeCancellation = null)
    {
        $this->StopNoticeCancellation = $stopNoticeCancellation;
        return $this;
    }
    /**
     * Get ServiceException value
     * @return \StructType\ServiceExceptionStructure|null
     */
    public function getServiceException()
    {
        return $this->ServiceException;
    }
    /**
     * Set ServiceException value
     * @param \StructType\ServiceExceptionStructure $serviceException
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setServiceException(\StructType\ServiceExceptionStructure $serviceException = null)
    {
        $this->ServiceException = $serviceException;
        return $this;
    }
    /**
     * Get Note value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $note
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $stopMonitoringDeliveryStructureNoteItem) {
            // validation for constraint: itemType
            if (!$stopMonitoringDeliveryStructureNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($stopMonitoringDeliveryStructureNoteItem) ? get_class($stopMonitoringDeliveryStructureNoteItem) : gettype($stopMonitoringDeliveryStructureNoteItem)), __LINE__);
            }
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function addToNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopMonitoringDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
