<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopLineNoticeCancellationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Cancellation of an earlier Stop Line Notice.
 * @subpackage Structs
 */
class StopLineNoticeCancellationStructure extends AbstractReferencingItemStructure
{
    /**
     * The MonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a stop monitoring point to which LINE notice applies.
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StopLineNoticeCancellationStructure
     * @uses StopLineNoticeCancellationStructure::setMonitoringRef()
     * @uses StopLineNoticeCancellationStructure::setLineRef()
     * @uses StopLineNoticeCancellationStructure::setDirectionRef()
     * @uses StopLineNoticeCancellationStructure::setExtensions()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopLineNoticeCancellationStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\StopLineNoticeCancellationStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\StopLineNoticeCancellationStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopLineNoticeCancellationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopLineNoticeCancellationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
