<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about source of information, that is, where the agent using the capture client obtained an item of information, or in the case of an automated feed, an identifier of the specific feed. Can be used to obtain updates,
 * verify details or otherwise assess relevance.
 * - minOccurs: 0
 * - type: D2LogicalModel:Source
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The sourceCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceCountry;
    /**
     * The sourceIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $sourceIdentification;
    /**
     * The sourceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $sourceName;
    /**
     * The sourceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceType;
    /**
     * The reliable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $reliable;
    /**
     * The sourceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $sourceExtension;
    /**
     * Constructor method for Source
     * @uses Source::setSourceCountry()
     * @uses Source::setSourceIdentification()
     * @uses Source::setSourceName()
     * @uses Source::setSourceType()
     * @uses Source::setReliable()
     * @uses Source::setSourceExtension()
     * @param string $sourceCountry
     * @param string $sourceIdentification
     * @param \StructType\MultilingualString $sourceName
     * @param string $sourceType
     * @param bool $reliable
     * @param \StructType\ExtensionType $sourceExtension
     */
    public function __construct($sourceCountry = null, $sourceIdentification = null, \StructType\MultilingualString $sourceName = null, $sourceType = null, $reliable = null, \StructType\ExtensionType $sourceExtension = null)
    {
        $this
            ->setSourceCountry($sourceCountry)
            ->setSourceIdentification($sourceIdentification)
            ->setSourceName($sourceName)
            ->setSourceType($sourceType)
            ->setReliable($reliable)
            ->setSourceExtension($sourceExtension);
    }
    /**
     * Get sourceCountry value
     * @return string|null
     */
    public function getSourceCountry()
    {
        return $this->sourceCountry;
    }
    /**
     * Set sourceCountry value
     * @uses \EnumType\CountryEnum::valueIsValid()
     * @uses \EnumType\CountryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceCountry
     * @return \StructType\Source
     */
    public function setSourceCountry($sourceCountry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryEnum::valueIsValid($sourceCountry)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceCountry, implode(', ', \EnumType\CountryEnum::getValidValues())), __LINE__);
        }
        $this->sourceCountry = $sourceCountry;
        return $this;
    }
    /**
     * Get sourceIdentification value
     * @return string|null
     */
    public function getSourceIdentification()
    {
        return $this->sourceIdentification;
    }
    /**
     * Set sourceIdentification value
     * @param string $sourceIdentification
     * @return \StructType\Source
     */
    public function setSourceIdentification($sourceIdentification = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sourceIdentification) && strlen($sourceIdentification) > 1024) || (is_array($sourceIdentification) && count($sourceIdentification) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($sourceIdentification) ? strlen($sourceIdentification) : count($sourceIdentification)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sourceIdentification) && !is_string($sourceIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceIdentification)), __LINE__);
        }
        $this->sourceIdentification = $sourceIdentification;
        return $this;
    }
    /**
     * Get sourceName value
     * @return \StructType\MultilingualString|null
     */
    public function getSourceName()
    {
        return $this->sourceName;
    }
    /**
     * Set sourceName value
     * @param \StructType\MultilingualString $sourceName
     * @return \StructType\Source
     */
    public function setSourceName(\StructType\MultilingualString $sourceName = null)
    {
        $this->sourceName = $sourceName;
        return $this;
    }
    /**
     * Get sourceType value
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->sourceType;
    }
    /**
     * Set sourceType value
     * @uses \EnumType\SourceTypeEnum::valueIsValid()
     * @uses \EnumType\SourceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \StructType\Source
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SourceTypeEnum::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceType, implode(', ', \EnumType\SourceTypeEnum::getValidValues())), __LINE__);
        }
        $this->sourceType = $sourceType;
        return $this;
    }
    /**
     * Get reliable value
     * @return bool|null
     */
    public function getReliable()
    {
        return $this->reliable;
    }
    /**
     * Set reliable value
     * @param bool $reliable
     * @return \StructType\Source
     */
    public function setReliable($reliable = null)
    {
        // validation for constraint: boolean
        if (!is_null($reliable) && !is_bool($reliable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reliable)), __LINE__);
        }
        $this->reliable = $reliable;
        return $this;
    }
    /**
     * Get sourceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSourceExtension()
    {
        return $this->sourceExtension;
    }
    /**
     * Set sourceExtension value
     * @param \StructType\ExtensionType $sourceExtension
     * @return \StructType\Source
     */
    public function setSourceExtension(\StructType\ExtensionType $sourceExtension = null)
    {
        $this->sourceExtension = $sourceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Source
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
