<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Situations StructType
 * Meta informations extracted from the WSDL
 * - documentation: SITUATIONs in Delivery.
 * - minOccurs: 0
 * @subpackage Structs
 */
class Situations extends AbstractStructBase
{
    /**
     * The PtSituationElement
     * Meta informations extracted from the WSDL
     * - documentation: Description of a SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PtSituationElementStructure[]
     */
    public $PtSituationElement;
    /**
     * The RoadSituationElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: RoadSituationElement
     * @var \StructType\RoadSituationElementStructure[]
     */
    public $RoadSituationElement;
    /**
     * Constructor method for Situations
     * @uses Situations::setPtSituationElement()
     * @uses Situations::setRoadSituationElement()
     * @param \StructType\PtSituationElementStructure[] $ptSituationElement
     * @param \StructType\RoadSituationElementStructure[] $roadSituationElement
     */
    public function __construct(array $ptSituationElement = array(), array $roadSituationElement = array())
    {
        $this
            ->setPtSituationElement($ptSituationElement)
            ->setRoadSituationElement($roadSituationElement);
    }
    /**
     * Get PtSituationElement value
     * @return \StructType\PtSituationElementStructure[]|null
     */
    public function getPtSituationElement()
    {
        return $this->PtSituationElement;
    }
    /**
     * Set PtSituationElement value
     * @throws \InvalidArgumentException
     * @param \StructType\PtSituationElementStructure[] $ptSituationElement
     * @return \StructType\Situations
     */
    public function setPtSituationElement(array $ptSituationElement = array())
    {
        foreach ($ptSituationElement as $situationsPtSituationElementItem) {
            // validation for constraint: itemType
            if (!$situationsPtSituationElementItem instanceof \StructType\PtSituationElementStructure) {
                throw new \InvalidArgumentException(sprintf('The PtSituationElement property can only contain items of \StructType\PtSituationElementStructure, "%s" given', is_object($situationsPtSituationElementItem) ? get_class($situationsPtSituationElementItem) : gettype($situationsPtSituationElementItem)), __LINE__);
            }
        }
        $this->PtSituationElement = $ptSituationElement;
        return $this;
    }
    /**
     * Add item to PtSituationElement value
     * @throws \InvalidArgumentException
     * @param \StructType\PtSituationElementStructure $item
     * @return \StructType\Situations
     */
    public function addToPtSituationElement(\StructType\PtSituationElementStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PtSituationElementStructure) {
            throw new \InvalidArgumentException(sprintf('The PtSituationElement property can only contain items of \StructType\PtSituationElementStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PtSituationElement[] = $item;
        return $this;
    }
    /**
     * Get RoadSituationElement value
     * @return \StructType\RoadSituationElementStructure[]|null
     */
    public function getRoadSituationElement()
    {
        return $this->RoadSituationElement;
    }
    /**
     * Set RoadSituationElement value
     * @throws \InvalidArgumentException
     * @param \StructType\RoadSituationElementStructure[] $roadSituationElement
     * @return \StructType\Situations
     */
    public function setRoadSituationElement(array $roadSituationElement = array())
    {
        foreach ($roadSituationElement as $situationsRoadSituationElementItem) {
            // validation for constraint: itemType
            if (!$situationsRoadSituationElementItem instanceof \StructType\RoadSituationElementStructure) {
                throw new \InvalidArgumentException(sprintf('The RoadSituationElement property can only contain items of \StructType\RoadSituationElementStructure, "%s" given', is_object($situationsRoadSituationElementItem) ? get_class($situationsRoadSituationElementItem) : gettype($situationsRoadSituationElementItem)), __LINE__);
            }
        }
        $this->RoadSituationElement = $roadSituationElement;
        return $this;
    }
    /**
     * Add item to RoadSituationElement value
     * @throws \InvalidArgumentException
     * @param \StructType\RoadSituationElementStructure $item
     * @return \StructType\Situations
     */
    public function addToRoadSituationElement(\StructType\RoadSituationElementStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoadSituationElementStructure) {
            throw new \InvalidArgumentException(sprintf('The RoadSituationElement property can only contain items of \StructType\RoadSituationElementStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoadSituationElement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Situations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
