<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationSharedRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for reference to a SITUATION or an update to a SITUATION. Participant ref is optional and may be supplied from context. | Identifiers of a SITUATION or an update to a SITUATION. Participant ref is optional and may be supplied
 * from context.
 * @subpackage Structs
 */
class SituationSharedRefStructure extends AbstractStructBase
{
    /**
     * The CountryRef
     * @var \StructType\CountryRefStructure
     */
    public $CountryRef;
    /**
     * The ParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * The SituationNumber
     * @var \StructType\EntryQualifierStructure
     */
    public $SituationNumber;
    /**
     * The UpdateCountryRef
     * @var \StructType\CountryRefStructure
     */
    public $UpdateCountryRef;
    /**
     * The UpdateParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $UpdateParticipantRef;
    /**
     * The Version
     * @var \StructType\SituationVersion
     */
    public $Version;
    /**
     * Constructor method for SituationSharedRefStructure
     * @uses SituationSharedRefStructure::setCountryRef()
     * @uses SituationSharedRefStructure::setParticipantRef()
     * @uses SituationSharedRefStructure::setSituationNumber()
     * @uses SituationSharedRefStructure::setUpdateCountryRef()
     * @uses SituationSharedRefStructure::setUpdateParticipantRef()
     * @uses SituationSharedRefStructure::setVersion()
     * @param \StructType\CountryRefStructure $countryRef
     * @param \StructType\ParticipantRefStructure $participantRef
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @param \StructType\SituationVersion $version
     */
    public function __construct(\StructType\CountryRefStructure $countryRef = null, \StructType\ParticipantRefStructure $participantRef = null, \StructType\EntryQualifierStructure $situationNumber = null, \StructType\CountryRefStructure $updateCountryRef = null, \StructType\ParticipantRefStructure $updateParticipantRef = null, \StructType\SituationVersion $version = null)
    {
        $this
            ->setCountryRef($countryRef)
            ->setParticipantRef($participantRef)
            ->setSituationNumber($situationNumber)
            ->setUpdateCountryRef($updateCountryRef)
            ->setUpdateParticipantRef($updateParticipantRef)
            ->setVersion($version);
    }
    /**
     * Get CountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getCountryRef()
    {
        return $this->CountryRef;
    }
    /**
     * Set CountryRef value
     * @param \StructType\CountryRefStructure $countryRef
     * @return \StructType\SituationSharedRefStructure
     */
    public function setCountryRef(\StructType\CountryRefStructure $countryRef = null)
    {
        $this->CountryRef = $countryRef;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\SituationSharedRefStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Get SituationNumber value
     * @return \StructType\EntryQualifierStructure|null
     */
    public function getSituationNumber()
    {
        return $this->SituationNumber;
    }
    /**
     * Set SituationNumber value
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @return \StructType\SituationSharedRefStructure
     */
    public function setSituationNumber(\StructType\EntryQualifierStructure $situationNumber = null)
    {
        $this->SituationNumber = $situationNumber;
        return $this;
    }
    /**
     * Get UpdateCountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getUpdateCountryRef()
    {
        return $this->UpdateCountryRef;
    }
    /**
     * Set UpdateCountryRef value
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @return \StructType\SituationSharedRefStructure
     */
    public function setUpdateCountryRef(\StructType\CountryRefStructure $updateCountryRef = null)
    {
        $this->UpdateCountryRef = $updateCountryRef;
        return $this;
    }
    /**
     * Get UpdateParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getUpdateParticipantRef()
    {
        return $this->UpdateParticipantRef;
    }
    /**
     * Set UpdateParticipantRef value
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @return \StructType\SituationSharedRefStructure
     */
    public function setUpdateParticipantRef(\StructType\ParticipantRefStructure $updateParticipantRef = null)
    {
        $this->UpdateParticipantRef = $updateParticipantRef;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\SituationVersion|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\SituationVersion $version
     * @return \StructType\SituationSharedRefStructure
     */
    public function setVersion(\StructType\SituationVersion $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationSharedRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
