<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationRecord StructType
 * Meta informations extracted from the WSDL
 * - documentation: Datex2 SITUATION Record.
 * - minOccurs: 0
 * - type: D2LogicalModel:SituationRecord
 * @subpackage Structs
 */
abstract class SituationRecord extends AbstractStructBase
{
    /**
     * The situationRecordCreationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $situationRecordCreationTime;
    /**
     * The situationRecordVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $situationRecordVersion;
    /**
     * The situationRecordVersionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $situationRecordVersionTime;
    /**
     * The probabilityOfOccurrence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $probabilityOfOccurrence;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The situationRecordCreationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $situationRecordCreationReference;
    /**
     * The situationRecordObservationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $situationRecordObservationTime;
    /**
     * The situationRecordFirstSupplierVersionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $situationRecordFirstSupplierVersionTime;
    /**
     * The confidentialityOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confidentialityOverride;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Source
     */
    public $source;
    /**
     * The validity
     * @var \StructType\Validity
     */
    public $validity;
    /**
     * The impact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Impact
     */
    public $impact;
    /**
     * The cause
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Cause
     */
    public $cause;
    /**
     * The generalPublicComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Comment[]
     */
    public $generalPublicComment;
    /**
     * The nonGeneralPublicComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Comment[]
     */
    public $nonGeneralPublicComment;
    /**
     * The urlLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UrlLink[]
     */
    public $urlLink;
    /**
     * The groupOfLocations
     * @var \StructType\GroupOfLocations
     */
    public $groupOfLocations;
    /**
     * The management
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Management
     */
    public $management;
    /**
     * The situationRecordExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $situationRecordExtension;
    /**
     * Constructor method for SituationRecord
     * @uses SituationRecord::setSituationRecordCreationTime()
     * @uses SituationRecord::setSituationRecordVersion()
     * @uses SituationRecord::setSituationRecordVersionTime()
     * @uses SituationRecord::setProbabilityOfOccurrence()
     * @uses SituationRecord::setId()
     * @uses SituationRecord::setSituationRecordCreationReference()
     * @uses SituationRecord::setSituationRecordObservationTime()
     * @uses SituationRecord::setSituationRecordFirstSupplierVersionTime()
     * @uses SituationRecord::setConfidentialityOverride()
     * @uses SituationRecord::setSource()
     * @uses SituationRecord::setValidity()
     * @uses SituationRecord::setImpact()
     * @uses SituationRecord::setCause()
     * @uses SituationRecord::setGeneralPublicComment()
     * @uses SituationRecord::setNonGeneralPublicComment()
     * @uses SituationRecord::setUrlLink()
     * @uses SituationRecord::setGroupOfLocations()
     * @uses SituationRecord::setManagement()
     * @uses SituationRecord::setSituationRecordExtension()
     * @param string $situationRecordCreationTime
     * @param int $situationRecordVersion
     * @param string $situationRecordVersionTime
     * @param string $probabilityOfOccurrence
     * @param string $id
     * @param string $situationRecordCreationReference
     * @param string $situationRecordObservationTime
     * @param string $situationRecordFirstSupplierVersionTime
     * @param string $confidentialityOverride
     * @param \StructType\Source $source
     * @param \StructType\Validity $validity
     * @param \StructType\Impact $impact
     * @param \StructType\Cause $cause
     * @param \StructType\Comment[] $generalPublicComment
     * @param \StructType\Comment[] $nonGeneralPublicComment
     * @param \StructType\UrlLink[] $urlLink
     * @param \StructType\GroupOfLocations $groupOfLocations
     * @param \StructType\Management $management
     * @param \StructType\ExtensionType $situationRecordExtension
     */
    public function __construct($situationRecordCreationTime = null, $situationRecordVersion = null, $situationRecordVersionTime = null, $probabilityOfOccurrence = null, $id = null, $situationRecordCreationReference = null, $situationRecordObservationTime = null, $situationRecordFirstSupplierVersionTime = null, $confidentialityOverride = null, \StructType\Source $source = null, \StructType\Validity $validity = null, \StructType\Impact $impact = null, \StructType\Cause $cause = null, array $generalPublicComment = array(), array $nonGeneralPublicComment = array(), array $urlLink = array(), \StructType\GroupOfLocations $groupOfLocations = null, \StructType\Management $management = null, \StructType\ExtensionType $situationRecordExtension = null)
    {
        $this
            ->setSituationRecordCreationTime($situationRecordCreationTime)
            ->setSituationRecordVersion($situationRecordVersion)
            ->setSituationRecordVersionTime($situationRecordVersionTime)
            ->setProbabilityOfOccurrence($probabilityOfOccurrence)
            ->setId($id)
            ->setSituationRecordCreationReference($situationRecordCreationReference)
            ->setSituationRecordObservationTime($situationRecordObservationTime)
            ->setSituationRecordFirstSupplierVersionTime($situationRecordFirstSupplierVersionTime)
            ->setConfidentialityOverride($confidentialityOverride)
            ->setSource($source)
            ->setValidity($validity)
            ->setImpact($impact)
            ->setCause($cause)
            ->setGeneralPublicComment($generalPublicComment)
            ->setNonGeneralPublicComment($nonGeneralPublicComment)
            ->setUrlLink($urlLink)
            ->setGroupOfLocations($groupOfLocations)
            ->setManagement($management)
            ->setSituationRecordExtension($situationRecordExtension);
    }
    /**
     * Get situationRecordCreationTime value
     * @return string
     */
    public function getSituationRecordCreationTime()
    {
        return $this->situationRecordCreationTime;
    }
    /**
     * Set situationRecordCreationTime value
     * @param string $situationRecordCreationTime
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordCreationTime($situationRecordCreationTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordCreationTime) && !is_string($situationRecordCreationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordCreationTime)), __LINE__);
        }
        $this->situationRecordCreationTime = $situationRecordCreationTime;
        return $this;
    }
    /**
     * Get situationRecordVersion value
     * @return int
     */
    public function getSituationRecordVersion()
    {
        return $this->situationRecordVersion;
    }
    /**
     * Set situationRecordVersion value
     * @param int $situationRecordVersion
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordVersion($situationRecordVersion = null)
    {
        // validation for constraint: int
        if (!is_null($situationRecordVersion) && !is_numeric($situationRecordVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($situationRecordVersion)), __LINE__);
        }
        $this->situationRecordVersion = $situationRecordVersion;
        return $this;
    }
    /**
     * Get situationRecordVersionTime value
     * @return string
     */
    public function getSituationRecordVersionTime()
    {
        return $this->situationRecordVersionTime;
    }
    /**
     * Set situationRecordVersionTime value
     * @param string $situationRecordVersionTime
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordVersionTime($situationRecordVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordVersionTime) && !is_string($situationRecordVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordVersionTime)), __LINE__);
        }
        $this->situationRecordVersionTime = $situationRecordVersionTime;
        return $this;
    }
    /**
     * Get probabilityOfOccurrence value
     * @return string
     */
    public function getProbabilityOfOccurrence()
    {
        return $this->probabilityOfOccurrence;
    }
    /**
     * Set probabilityOfOccurrence value
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::valueIsValid()
     * @uses \EnumType\ProbabilityOfOccurrenceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $probabilityOfOccurrence
     * @return \StructType\SituationRecord
     */
    public function setProbabilityOfOccurrence($probabilityOfOccurrence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProbabilityOfOccurrenceEnum::valueIsValid($probabilityOfOccurrence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $probabilityOfOccurrence, implode(', ', \EnumType\ProbabilityOfOccurrenceEnum::getValidValues())), __LINE__);
        }
        $this->probabilityOfOccurrence = $probabilityOfOccurrence;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SituationRecord
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get situationRecordCreationReference value
     * @return string|null
     */
    public function getSituationRecordCreationReference()
    {
        return $this->situationRecordCreationReference;
    }
    /**
     * Set situationRecordCreationReference value
     * @param string $situationRecordCreationReference
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordCreationReference($situationRecordCreationReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($situationRecordCreationReference) && strlen($situationRecordCreationReference) > 1024) || (is_array($situationRecordCreationReference) && count($situationRecordCreationReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($situationRecordCreationReference) ? strlen($situationRecordCreationReference) : count($situationRecordCreationReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($situationRecordCreationReference) && !is_string($situationRecordCreationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordCreationReference)), __LINE__);
        }
        $this->situationRecordCreationReference = $situationRecordCreationReference;
        return $this;
    }
    /**
     * Get situationRecordObservationTime value
     * @return string|null
     */
    public function getSituationRecordObservationTime()
    {
        return $this->situationRecordObservationTime;
    }
    /**
     * Set situationRecordObservationTime value
     * @param string $situationRecordObservationTime
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordObservationTime($situationRecordObservationTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordObservationTime) && !is_string($situationRecordObservationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordObservationTime)), __LINE__);
        }
        $this->situationRecordObservationTime = $situationRecordObservationTime;
        return $this;
    }
    /**
     * Get situationRecordFirstSupplierVersionTime value
     * @return string|null
     */
    public function getSituationRecordFirstSupplierVersionTime()
    {
        return $this->situationRecordFirstSupplierVersionTime;
    }
    /**
     * Set situationRecordFirstSupplierVersionTime value
     * @param string $situationRecordFirstSupplierVersionTime
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordFirstSupplierVersionTime($situationRecordFirstSupplierVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationRecordFirstSupplierVersionTime) && !is_string($situationRecordFirstSupplierVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationRecordFirstSupplierVersionTime)), __LINE__);
        }
        $this->situationRecordFirstSupplierVersionTime = $situationRecordFirstSupplierVersionTime;
        return $this;
    }
    /**
     * Get confidentialityOverride value
     * @return string|null
     */
    public function getConfidentialityOverride()
    {
        return $this->confidentialityOverride;
    }
    /**
     * Set confidentialityOverride value
     * @uses \EnumType\ConfidentialityValueEnum::valueIsValid()
     * @uses \EnumType\ConfidentialityValueEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialityOverride
     * @return \StructType\SituationRecord
     */
    public function setConfidentialityOverride($confidentialityOverride = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConfidentialityValueEnum::valueIsValid($confidentialityOverride)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidentialityOverride, implode(', ', \EnumType\ConfidentialityValueEnum::getValidValues())), __LINE__);
        }
        $this->confidentialityOverride = $confidentialityOverride;
        return $this;
    }
    /**
     * Get source value
     * @return \StructType\Source|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param \StructType\Source $source
     * @return \StructType\SituationRecord
     */
    public function setSource(\StructType\Source $source = null)
    {
        $this->source = $source;
        return $this;
    }
    /**
     * Get validity value
     * @return \StructType\Validity|null
     */
    public function getValidity()
    {
        return $this->validity;
    }
    /**
     * Set validity value
     * @param \StructType\Validity $validity
     * @return \StructType\SituationRecord
     */
    public function setValidity(\StructType\Validity $validity = null)
    {
        $this->validity = $validity;
        return $this;
    }
    /**
     * Get impact value
     * @return \StructType\Impact|null
     */
    public function getImpact()
    {
        return $this->impact;
    }
    /**
     * Set impact value
     * @param \StructType\Impact $impact
     * @return \StructType\SituationRecord
     */
    public function setImpact(\StructType\Impact $impact = null)
    {
        $this->impact = $impact;
        return $this;
    }
    /**
     * Get cause value
     * @return \StructType\Cause|null
     */
    public function getCause()
    {
        return $this->cause;
    }
    /**
     * Set cause value
     * @param \StructType\Cause $cause
     * @return \StructType\SituationRecord
     */
    public function setCause(\StructType\Cause $cause = null)
    {
        $this->cause = $cause;
        return $this;
    }
    /**
     * Get generalPublicComment value
     * @return \StructType\Comment[]|null
     */
    public function getGeneralPublicComment()
    {
        return $this->generalPublicComment;
    }
    /**
     * Set generalPublicComment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment[] $generalPublicComment
     * @return \StructType\SituationRecord
     */
    public function setGeneralPublicComment(array $generalPublicComment = array())
    {
        foreach ($generalPublicComment as $situationRecordGeneralPublicCommentItem) {
            // validation for constraint: itemType
            if (!$situationRecordGeneralPublicCommentItem instanceof \StructType\Comment) {
                throw new \InvalidArgumentException(sprintf('The generalPublicComment property can only contain items of \StructType\Comment, "%s" given', is_object($situationRecordGeneralPublicCommentItem) ? get_class($situationRecordGeneralPublicCommentItem) : gettype($situationRecordGeneralPublicCommentItem)), __LINE__);
            }
        }
        $this->generalPublicComment = $generalPublicComment;
        return $this;
    }
    /**
     * Add item to generalPublicComment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment $item
     * @return \StructType\SituationRecord
     */
    public function addToGeneralPublicComment(\StructType\Comment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comment) {
            throw new \InvalidArgumentException(sprintf('The generalPublicComment property can only contain items of \StructType\Comment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->generalPublicComment[] = $item;
        return $this;
    }
    /**
     * Get nonGeneralPublicComment value
     * @return \StructType\Comment[]|null
     */
    public function getNonGeneralPublicComment()
    {
        return $this->nonGeneralPublicComment;
    }
    /**
     * Set nonGeneralPublicComment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment[] $nonGeneralPublicComment
     * @return \StructType\SituationRecord
     */
    public function setNonGeneralPublicComment(array $nonGeneralPublicComment = array())
    {
        foreach ($nonGeneralPublicComment as $situationRecordNonGeneralPublicCommentItem) {
            // validation for constraint: itemType
            if (!$situationRecordNonGeneralPublicCommentItem instanceof \StructType\Comment) {
                throw new \InvalidArgumentException(sprintf('The nonGeneralPublicComment property can only contain items of \StructType\Comment, "%s" given', is_object($situationRecordNonGeneralPublicCommentItem) ? get_class($situationRecordNonGeneralPublicCommentItem) : gettype($situationRecordNonGeneralPublicCommentItem)), __LINE__);
            }
        }
        $this->nonGeneralPublicComment = $nonGeneralPublicComment;
        return $this;
    }
    /**
     * Add item to nonGeneralPublicComment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment $item
     * @return \StructType\SituationRecord
     */
    public function addToNonGeneralPublicComment(\StructType\Comment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comment) {
            throw new \InvalidArgumentException(sprintf('The nonGeneralPublicComment property can only contain items of \StructType\Comment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nonGeneralPublicComment[] = $item;
        return $this;
    }
    /**
     * Get urlLink value
     * @return \StructType\UrlLink[]|null
     */
    public function getUrlLink()
    {
        return $this->urlLink;
    }
    /**
     * Set urlLink value
     * @throws \InvalidArgumentException
     * @param \StructType\UrlLink[] $urlLink
     * @return \StructType\SituationRecord
     */
    public function setUrlLink(array $urlLink = array())
    {
        foreach ($urlLink as $situationRecordUrlLinkItem) {
            // validation for constraint: itemType
            if (!$situationRecordUrlLinkItem instanceof \StructType\UrlLink) {
                throw new \InvalidArgumentException(sprintf('The urlLink property can only contain items of \StructType\UrlLink, "%s" given', is_object($situationRecordUrlLinkItem) ? get_class($situationRecordUrlLinkItem) : gettype($situationRecordUrlLinkItem)), __LINE__);
            }
        }
        $this->urlLink = $urlLink;
        return $this;
    }
    /**
     * Add item to urlLink value
     * @throws \InvalidArgumentException
     * @param \StructType\UrlLink $item
     * @return \StructType\SituationRecord
     */
    public function addToUrlLink(\StructType\UrlLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UrlLink) {
            throw new \InvalidArgumentException(sprintf('The urlLink property can only contain items of \StructType\UrlLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->urlLink[] = $item;
        return $this;
    }
    /**
     * Get groupOfLocations value
     * @return \StructType\GroupOfLocations|null
     */
    public function getGroupOfLocations()
    {
        return $this->groupOfLocations;
    }
    /**
     * Set groupOfLocations value
     * @param \StructType\GroupOfLocations $groupOfLocations
     * @return \StructType\SituationRecord
     */
    public function setGroupOfLocations(\StructType\GroupOfLocations $groupOfLocations = null)
    {
        $this->groupOfLocations = $groupOfLocations;
        return $this;
    }
    /**
     * Get management value
     * @return \StructType\Management|null
     */
    public function getManagement()
    {
        return $this->management;
    }
    /**
     * Set management value
     * @param \StructType\Management $management
     * @return \StructType\SituationRecord
     */
    public function setManagement(\StructType\Management $management = null)
    {
        $this->management = $management;
        return $this;
    }
    /**
     * Get situationRecordExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSituationRecordExtension()
    {
        return $this->situationRecordExtension;
    }
    /**
     * Set situationRecordExtension value
     * @param \StructType\ExtensionType $situationRecordExtension
     * @return \StructType\SituationRecord
     */
    public function setSituationRecordExtension(\StructType\ExtensionType $situationRecordExtension = null)
    {
        $this->situationRecordExtension = $situationRecordExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
