<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationPublication StructType
 * @subpackage Structs
 */
class SituationPublication extends PayloadPublication
{
    /**
     * The situation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Situation[]
     */
    public $situation;
    /**
     * The situationPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $situationPublicationExtension;
    /**
     * Constructor method for SituationPublication
     * @uses SituationPublication::setSituation()
     * @uses SituationPublication::setSituationPublicationExtension()
     * @param \StructType\Situation[] $situation
     * @param \StructType\ExtensionType $situationPublicationExtension
     */
    public function __construct(array $situation = array(), \StructType\ExtensionType $situationPublicationExtension = null)
    {
        $this
            ->setSituation($situation)
            ->setSituationPublicationExtension($situationPublicationExtension);
    }
    /**
     * Get situation value
     * @return \StructType\Situation[]|null
     */
    public function getSituation()
    {
        return $this->situation;
    }
    /**
     * Set situation value
     * @throws \InvalidArgumentException
     * @param \StructType\Situation[] $situation
     * @return \StructType\SituationPublication
     */
    public function setSituation(array $situation = array())
    {
        foreach ($situation as $situationPublicationSituationItem) {
            // validation for constraint: itemType
            if (!$situationPublicationSituationItem instanceof \StructType\Situation) {
                throw new \InvalidArgumentException(sprintf('The situation property can only contain items of \StructType\Situation, "%s" given', is_object($situationPublicationSituationItem) ? get_class($situationPublicationSituationItem) : gettype($situationPublicationSituationItem)), __LINE__);
            }
        }
        $this->situation = $situation;
        return $this;
    }
    /**
     * Add item to situation value
     * @throws \InvalidArgumentException
     * @param \StructType\Situation $item
     * @return \StructType\SituationPublication
     */
    public function addToSituation(\StructType\Situation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Situation) {
            throw new \InvalidArgumentException(sprintf('The situation property can only contain items of \StructType\Situation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->situation[] = $item;
        return $this;
    }
    /**
     * Get situationPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSituationPublicationExtension()
    {
        return $this->situationPublicationExtension;
    }
    /**
     * Set situationPublicationExtension value
     * @param \StructType\ExtensionType $situationPublicationExtension
     * @return \StructType\SituationPublication
     */
    public function setSituationPublicationExtension(\StructType\ExtensionType $situationPublicationExtension = null)
    {
        $this->situationPublicationExtension = $situationPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
