<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationExchangeDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Situation Exchange Service. Provides information about one or more vehicles; each has its own VEHICLE activity element. | Payload part of Situation Exchange Service delivery.
 * @subpackage Structs
 */
class SituationExchangeDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The PtSituationContext
     * @var \StructType\ContextStructure
     */
    public $PtSituationContext;
    /**
     * The Situations
     * @var \StructType\Situations
     */
    public $Situations;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for SituationExchangeDeliveryStructure
     * @uses SituationExchangeDeliveryStructure::setPtSituationContext()
     * @uses SituationExchangeDeliveryStructure::setSituations()
     * @uses SituationExchangeDeliveryStructure::setExtensions()
     * @uses SituationExchangeDeliveryStructure::setVersion()
     * @param \StructType\ContextStructure $ptSituationContext
     * @param \StructType\Situations $situations
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ContextStructure $ptSituationContext = null, \StructType\Situations $situations = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPtSituationContext($ptSituationContext)
            ->setSituations($situations)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PtSituationContext value
     * @return \StructType\ContextStructure|null
     */
    public function getPtSituationContext()
    {
        return $this->PtSituationContext;
    }
    /**
     * Set PtSituationContext value
     * @param \StructType\ContextStructure $ptSituationContext
     * @return \StructType\SituationExchangeDeliveryStructure
     */
    public function setPtSituationContext(\StructType\ContextStructure $ptSituationContext = null)
    {
        $this->PtSituationContext = $ptSituationContext;
        return $this;
    }
    /**
     * Get Situations value
     * @return \StructType\Situations|null
     */
    public function getSituations()
    {
        return $this->Situations;
    }
    /**
     * Set Situations value
     * @param \StructType\Situations $situations
     * @return \StructType\SituationExchangeDeliveryStructure
     */
    public function setSituations(\StructType\Situations $situations = null)
    {
        $this->Situations = $situations;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SituationExchangeDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\SituationExchangeDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationExchangeDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
