<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationExchangeCapabilitiesResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Situation Exchange Service.
 * @subpackage Structs
 */
class SituationExchangeCapabilitiesResponseStructure extends AbstractServiceCapabilitiesResponseStructure
{
    /**
     * The SituationExchangeServiceCapabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: SituationExchangeServiceCapabilities
     * @var \StructType\SituationExchangeServiceCapabilitiesStructure
     */
    public $SituationExchangeServiceCapabilities;
    /**
     * The SituationExchangePermissions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: SituationExchangePermissions
     * @var \StructType\SituationExchangePermissions
     */
    public $SituationExchangePermissions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for SituationExchangeCapabilitiesResponseStructure
     * @uses SituationExchangeCapabilitiesResponseStructure::setSituationExchangeServiceCapabilities()
     * @uses SituationExchangeCapabilitiesResponseStructure::setSituationExchangePermissions()
     * @uses SituationExchangeCapabilitiesResponseStructure::setExtensions()
     * @uses SituationExchangeCapabilitiesResponseStructure::setVersion()
     * @param \StructType\SituationExchangeServiceCapabilitiesStructure $situationExchangeServiceCapabilities
     * @param \StructType\SituationExchangePermissions $situationExchangePermissions
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\SituationExchangeServiceCapabilitiesStructure $situationExchangeServiceCapabilities = null, \StructType\SituationExchangePermissions $situationExchangePermissions = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setSituationExchangeServiceCapabilities($situationExchangeServiceCapabilities)
            ->setSituationExchangePermissions($situationExchangePermissions)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get SituationExchangeServiceCapabilities value
     * @return \StructType\SituationExchangeServiceCapabilitiesStructure|null
     */
    public function getSituationExchangeServiceCapabilities()
    {
        return $this->SituationExchangeServiceCapabilities;
    }
    /**
     * Set SituationExchangeServiceCapabilities value
     * @param \StructType\SituationExchangeServiceCapabilitiesStructure $situationExchangeServiceCapabilities
     * @return \StructType\SituationExchangeCapabilitiesResponseStructure
     */
    public function setSituationExchangeServiceCapabilities(\StructType\SituationExchangeServiceCapabilitiesStructure $situationExchangeServiceCapabilities = null)
    {
        $this->SituationExchangeServiceCapabilities = $situationExchangeServiceCapabilities;
        return $this;
    }
    /**
     * Get SituationExchangePermissions value
     * @return \StructType\SituationExchangePermissions|null
     */
    public function getSituationExchangePermissions()
    {
        return $this->SituationExchangePermissions;
    }
    /**
     * Set SituationExchangePermissions value
     * @param \StructType\SituationExchangePermissions $situationExchangePermissions
     * @return \StructType\SituationExchangeCapabilitiesResponseStructure
     */
    public function setSituationExchangePermissions(\StructType\SituationExchangePermissions $situationExchangePermissions = null)
    {
        $this->SituationExchangePermissions = $situationExchangePermissions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SituationExchangeCapabilitiesResponseStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\SituationExchangeCapabilitiesResponseStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationExchangeCapabilitiesResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
