<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiriServiceDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a SIRI SIRI Functional Service Delivery types.Used for WSDL.
 * @subpackage Structs
 */
class SiriServiceDeliveryStructure extends AbstractStructBase
{
    /**
     * The IncludedSituationExchangeDelivery
     * @var \StructType\SituationExchangeDeliveryStructure
     */
    public $IncludedSituationExchangeDelivery;
    /**
     * The ProductionTimetableDelivery
     * @var \StructType\ProductionTimetableDeliveryStructure
     */
    public $ProductionTimetableDelivery;
    /**
     * The EstimatedTimetableDelivery
     * @var \StructType\EstimatedTimetableDeliveryStructure
     */
    public $EstimatedTimetableDelivery;
    /**
     * The StopTimetableDelivery
     * @var \StructType\StopTimetableDeliveryStructure
     */
    public $StopTimetableDelivery;
    /**
     * The StopMonitoringDelivery
     * @var \StructType\StopMonitoringDeliveryStructure
     */
    public $StopMonitoringDelivery;
    /**
     * The VehicleMonitoringDelivery
     * @var \StructType\VehicleMonitoringDeliveryStructure
     */
    public $VehicleMonitoringDelivery;
    /**
     * The ConnectionTimetableDelivery
     * @var \StructType\ConnectionTimetableDeliveryStructure
     */
    public $ConnectionTimetableDelivery;
    /**
     * The ConnectionMonitoringFeederDelivery
     * @var \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public $ConnectionMonitoringFeederDelivery;
    /**
     * The ConnectionMonitoringDistributorDelivery
     * @var \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public $ConnectionMonitoringDistributorDelivery;
    /**
     * The GeneralMessageDelivery
     * @var \StructType\GeneralMessageDeliveryStructure
     */
    public $GeneralMessageDelivery;
    /**
     * The FacilityMonitoringDelivery
     * @var \StructType\FacilityMonitoringDeliveryStructure
     */
    public $FacilityMonitoringDelivery;
    /**
     * The SituationExchangeDelivery
     * @var \StructType\SituationExchangeDeliveryStructure
     */
    public $SituationExchangeDelivery;
    /**
     * Constructor method for SiriServiceDeliveryStructure
     * @uses SiriServiceDeliveryStructure::setIncludedSituationExchangeDelivery()
     * @uses SiriServiceDeliveryStructure::setProductionTimetableDelivery()
     * @uses SiriServiceDeliveryStructure::setEstimatedTimetableDelivery()
     * @uses SiriServiceDeliveryStructure::setStopTimetableDelivery()
     * @uses SiriServiceDeliveryStructure::setStopMonitoringDelivery()
     * @uses SiriServiceDeliveryStructure::setVehicleMonitoringDelivery()
     * @uses SiriServiceDeliveryStructure::setConnectionTimetableDelivery()
     * @uses SiriServiceDeliveryStructure::setConnectionMonitoringFeederDelivery()
     * @uses SiriServiceDeliveryStructure::setConnectionMonitoringDistributorDelivery()
     * @uses SiriServiceDeliveryStructure::setGeneralMessageDelivery()
     * @uses SiriServiceDeliveryStructure::setFacilityMonitoringDelivery()
     * @uses SiriServiceDeliveryStructure::setSituationExchangeDelivery()
     * @param \StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery
     * @param \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery
     * @param \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery
     * @param \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery
     * @param \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery
     * @param \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery
     * @param \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery
     * @param \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery
     * @param \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery
     * @param \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery
     */
    public function __construct(\StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery = null, \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery = null, \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery = null, \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery = null, \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery = null, \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery = null, \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery = null, \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery = null, \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery = null, \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery = null, \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery = null, \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery = null)
    {
        $this
            ->setIncludedSituationExchangeDelivery($includedSituationExchangeDelivery)
            ->setProductionTimetableDelivery($productionTimetableDelivery)
            ->setEstimatedTimetableDelivery($estimatedTimetableDelivery)
            ->setStopTimetableDelivery($stopTimetableDelivery)
            ->setStopMonitoringDelivery($stopMonitoringDelivery)
            ->setVehicleMonitoringDelivery($vehicleMonitoringDelivery)
            ->setConnectionTimetableDelivery($connectionTimetableDelivery)
            ->setConnectionMonitoringFeederDelivery($connectionMonitoringFeederDelivery)
            ->setConnectionMonitoringDistributorDelivery($connectionMonitoringDistributorDelivery)
            ->setGeneralMessageDelivery($generalMessageDelivery)
            ->setFacilityMonitoringDelivery($facilityMonitoringDelivery)
            ->setSituationExchangeDelivery($situationExchangeDelivery);
    }
    /**
     * Get IncludedSituationExchangeDelivery value
     * @return \StructType\SituationExchangeDeliveryStructure|null
     */
    public function getIncludedSituationExchangeDelivery()
    {
        return $this->IncludedSituationExchangeDelivery;
    }
    /**
     * Set IncludedSituationExchangeDelivery value
     * @param \StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setIncludedSituationExchangeDelivery(\StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery = null)
    {
        $this->IncludedSituationExchangeDelivery = $includedSituationExchangeDelivery;
        return $this;
    }
    /**
     * Get ProductionTimetableDelivery value
     * @return \StructType\ProductionTimetableDeliveryStructure|null
     */
    public function getProductionTimetableDelivery()
    {
        return $this->ProductionTimetableDelivery;
    }
    /**
     * Set ProductionTimetableDelivery value
     * @param \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setProductionTimetableDelivery(\StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery = null)
    {
        $this->ProductionTimetableDelivery = $productionTimetableDelivery;
        return $this;
    }
    /**
     * Get EstimatedTimetableDelivery value
     * @return \StructType\EstimatedTimetableDeliveryStructure|null
     */
    public function getEstimatedTimetableDelivery()
    {
        return $this->EstimatedTimetableDelivery;
    }
    /**
     * Set EstimatedTimetableDelivery value
     * @param \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setEstimatedTimetableDelivery(\StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery = null)
    {
        $this->EstimatedTimetableDelivery = $estimatedTimetableDelivery;
        return $this;
    }
    /**
     * Get StopTimetableDelivery value
     * @return \StructType\StopTimetableDeliveryStructure|null
     */
    public function getStopTimetableDelivery()
    {
        return $this->StopTimetableDelivery;
    }
    /**
     * Set StopTimetableDelivery value
     * @param \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setStopTimetableDelivery(\StructType\StopTimetableDeliveryStructure $stopTimetableDelivery = null)
    {
        $this->StopTimetableDelivery = $stopTimetableDelivery;
        return $this;
    }
    /**
     * Get StopMonitoringDelivery value
     * @return \StructType\StopMonitoringDeliveryStructure|null
     */
    public function getStopMonitoringDelivery()
    {
        return $this->StopMonitoringDelivery;
    }
    /**
     * Set StopMonitoringDelivery value
     * @param \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setStopMonitoringDelivery(\StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery = null)
    {
        $this->StopMonitoringDelivery = $stopMonitoringDelivery;
        return $this;
    }
    /**
     * Get VehicleMonitoringDelivery value
     * @return \StructType\VehicleMonitoringDeliveryStructure|null
     */
    public function getVehicleMonitoringDelivery()
    {
        return $this->VehicleMonitoringDelivery;
    }
    /**
     * Set VehicleMonitoringDelivery value
     * @param \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setVehicleMonitoringDelivery(\StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery = null)
    {
        $this->VehicleMonitoringDelivery = $vehicleMonitoringDelivery;
        return $this;
    }
    /**
     * Get ConnectionTimetableDelivery value
     * @return \StructType\ConnectionTimetableDeliveryStructure|null
     */
    public function getConnectionTimetableDelivery()
    {
        return $this->ConnectionTimetableDelivery;
    }
    /**
     * Set ConnectionTimetableDelivery value
     * @param \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setConnectionTimetableDelivery(\StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery = null)
    {
        $this->ConnectionTimetableDelivery = $connectionTimetableDelivery;
        return $this;
    }
    /**
     * Get ConnectionMonitoringFeederDelivery value
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure|null
     */
    public function getConnectionMonitoringFeederDelivery()
    {
        return $this->ConnectionMonitoringFeederDelivery;
    }
    /**
     * Set ConnectionMonitoringFeederDelivery value
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setConnectionMonitoringFeederDelivery(\StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery = null)
    {
        $this->ConnectionMonitoringFeederDelivery = $connectionMonitoringFeederDelivery;
        return $this;
    }
    /**
     * Get ConnectionMonitoringDistributorDelivery value
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure|null
     */
    public function getConnectionMonitoringDistributorDelivery()
    {
        return $this->ConnectionMonitoringDistributorDelivery;
    }
    /**
     * Set ConnectionMonitoringDistributorDelivery value
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setConnectionMonitoringDistributorDelivery(\StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery = null)
    {
        $this->ConnectionMonitoringDistributorDelivery = $connectionMonitoringDistributorDelivery;
        return $this;
    }
    /**
     * Get GeneralMessageDelivery value
     * @return \StructType\GeneralMessageDeliveryStructure|null
     */
    public function getGeneralMessageDelivery()
    {
        return $this->GeneralMessageDelivery;
    }
    /**
     * Set GeneralMessageDelivery value
     * @param \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setGeneralMessageDelivery(\StructType\GeneralMessageDeliveryStructure $generalMessageDelivery = null)
    {
        $this->GeneralMessageDelivery = $generalMessageDelivery;
        return $this;
    }
    /**
     * Get FacilityMonitoringDelivery value
     * @return \StructType\FacilityMonitoringDeliveryStructure|null
     */
    public function getFacilityMonitoringDelivery()
    {
        return $this->FacilityMonitoringDelivery;
    }
    /**
     * Set FacilityMonitoringDelivery value
     * @param \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setFacilityMonitoringDelivery(\StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery = null)
    {
        $this->FacilityMonitoringDelivery = $facilityMonitoringDelivery;
        return $this;
    }
    /**
     * Get SituationExchangeDelivery value
     * @return \StructType\SituationExchangeDeliveryStructure|null
     */
    public function getSituationExchangeDelivery()
    {
        return $this->SituationExchangeDelivery;
    }
    /**
     * Set SituationExchangeDelivery value
     * @param \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public function setSituationExchangeDelivery(\StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery = null)
    {
        $this->SituationExchangeDelivery = $situationExchangeDelivery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SiriServiceDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
