<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Siri StructType
 * Meta informations extracted from the WSDL
 * - documentation: SIRI Service Interface for Real-time Operation.
 * @subpackage Structs
 */
class Siri extends AbstractStructBase
{
    /**
     * The ServiceRequest
     * @var \StructType\ServiceRequest
     */
    public $ServiceRequest;
    /**
     * The SubscriptionRequest
     * @var \StructType\SubscriptionRequest
     */
    public $SubscriptionRequest;
    /**
     * The TerminateSubscriptionRequest
     * @var \StructType\TerminateSubscriptionRequestStructure
     */
    public $TerminateSubscriptionRequest;
    /**
     * The DataReadyNotification
     * @var \StructType\DataReadyRequestStructure
     */
    public $DataReadyNotification;
    /**
     * The DataSupplyRequest
     * @var \StructType\DataSupplyRequestStructure
     */
    public $DataSupplyRequest;
    /**
     * The CheckStatusRequest
     * @var \StructType\CheckStatusRequestStructure
     */
    public $CheckStatusRequest;
    /**
     * The HeartbeatNotification
     * @var \StructType\HeartbeatNotificationStructure
     */
    public $HeartbeatNotification;
    /**
     * The CapabilitiesRequest
     * @var \StructType\CapabilitiesRequestStructure
     */
    public $CapabilitiesRequest;
    /**
     * The StopPointsRequest
     * @var \StructType\StopPointsRequest
     */
    public $StopPointsRequest;
    /**
     * The LinesRequest
     * @var \StructType\LinesDiscoveryRequestStructure
     */
    public $LinesRequest;
    /**
     * The ServiceFeaturesRequest
     * @var \StructType\ServiceFeaturesRequest
     */
    public $ServiceFeaturesRequest;
    /**
     * The ProductCategoriesRequest
     * @var \StructType\ProductCategoriesDiscoveryRequestStructure
     */
    public $ProductCategoriesRequest;
    /**
     * The VehicleFeaturesRequest
     * @var \StructType\VehicleFeaturesRequestStructure
     */
    public $VehicleFeaturesRequest;
    /**
     * The InfoChannelRequest
     * @var \StructType\InfoChannelDiscoveryRequestStructure
     */
    public $InfoChannelRequest;
    /**
     * The FacilityRequest
     * @var \StructType\FacilityRequestStructure
     */
    public $FacilityRequest;
    /**
     * The ConnectionLinksRequest
     * @var \StructType\ConnectionLinksDiscoveryRequestStructure
     */
    public $ConnectionLinksRequest;
    /**
     * The SubscriptionResponse
     * @var \StructType\SubscriptionResponseStructure
     */
    public $SubscriptionResponse;
    /**
     * The TerminateSubscriptionResponse
     * @var \StructType\TerminateSubscriptionResponseStructure
     */
    public $TerminateSubscriptionResponse;
    /**
     * The SubscriptionTerminatedNotification
     * @var \StructType\SubscriptionTerminatedNotificationStructure
     */
    public $SubscriptionTerminatedNotification;
    /**
     * The DataReadyAcknowledgement
     * @var \StructType\DataReadyResponseStructure
     */
    public $DataReadyAcknowledgement;
    /**
     * The ServiceDelivery
     * @var \StructType\ServiceDelivery
     */
    public $ServiceDelivery;
    /**
     * The DataReceivedAcknowledgement
     * @var \StructType\DataReceivedResponseStructure
     */
    public $DataReceivedAcknowledgement;
    /**
     * The CheckStatusResponse
     * @var \StructType\CheckStatusResponseStructure
     */
    public $CheckStatusResponse;
    /**
     * The CapabilitiesResponse
     * @var \StructType\CapabilitiesResponseStructure
     */
    public $CapabilitiesResponse;
    /**
     * The StopPointsDelivery
     * @var \StructType\StopPointsDeliveryStructure
     */
    public $StopPointsDelivery;
    /**
     * The LinesDelivery
     * @var \StructType\LinesDeliveryStructure
     */
    public $LinesDelivery;
    /**
     * The ProductCategoriesDelivery
     * @var \StructType\ProductCategoriesDeliveryStructure
     */
    public $ProductCategoriesDelivery;
    /**
     * The ServiceFeaturesDelivery
     * @var \StructType\ServiceFeaturesDeliveryStructure
     */
    public $ServiceFeaturesDelivery;
    /**
     * The VehicleFeaturesDelivery
     * @var \StructType\VehicleFeaturesDeliveryStructure
     */
    public $VehicleFeaturesDelivery;
    /**
     * The InfoChannelDelivery
     * @var \StructType\InfoChannelDeliveryStructure
     */
    public $InfoChannelDelivery;
    /**
     * The FacilityDelivery
     * @var \StructType\FacilityDeliveryStructure
     */
    public $FacilityDelivery;
    /**
     * The ConnectionLinksDelivery
     * @var \StructType\ConnectionLinksDeliveryStructure
     */
    public $ConnectionLinksDelivery;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for Siri
     * @uses Siri::setServiceRequest()
     * @uses Siri::setSubscriptionRequest()
     * @uses Siri::setTerminateSubscriptionRequest()
     * @uses Siri::setDataReadyNotification()
     * @uses Siri::setDataSupplyRequest()
     * @uses Siri::setCheckStatusRequest()
     * @uses Siri::setHeartbeatNotification()
     * @uses Siri::setCapabilitiesRequest()
     * @uses Siri::setStopPointsRequest()
     * @uses Siri::setLinesRequest()
     * @uses Siri::setServiceFeaturesRequest()
     * @uses Siri::setProductCategoriesRequest()
     * @uses Siri::setVehicleFeaturesRequest()
     * @uses Siri::setInfoChannelRequest()
     * @uses Siri::setFacilityRequest()
     * @uses Siri::setConnectionLinksRequest()
     * @uses Siri::setSubscriptionResponse()
     * @uses Siri::setTerminateSubscriptionResponse()
     * @uses Siri::setSubscriptionTerminatedNotification()
     * @uses Siri::setDataReadyAcknowledgement()
     * @uses Siri::setServiceDelivery()
     * @uses Siri::setDataReceivedAcknowledgement()
     * @uses Siri::setCheckStatusResponse()
     * @uses Siri::setCapabilitiesResponse()
     * @uses Siri::setStopPointsDelivery()
     * @uses Siri::setLinesDelivery()
     * @uses Siri::setProductCategoriesDelivery()
     * @uses Siri::setServiceFeaturesDelivery()
     * @uses Siri::setVehicleFeaturesDelivery()
     * @uses Siri::setInfoChannelDelivery()
     * @uses Siri::setFacilityDelivery()
     * @uses Siri::setConnectionLinksDelivery()
     * @uses Siri::setExtensions()
     * @uses Siri::setVersion()
     * @param \StructType\ServiceRequest $serviceRequest
     * @param \StructType\SubscriptionRequest $subscriptionRequest
     * @param \StructType\TerminateSubscriptionRequestStructure $terminateSubscriptionRequest
     * @param \StructType\DataReadyRequestStructure $dataReadyNotification
     * @param \StructType\DataSupplyRequestStructure $dataSupplyRequest
     * @param \StructType\CheckStatusRequestStructure $checkStatusRequest
     * @param \StructType\HeartbeatNotificationStructure $heartbeatNotification
     * @param \StructType\CapabilitiesRequestStructure $capabilitiesRequest
     * @param \StructType\StopPointsRequest $stopPointsRequest
     * @param \StructType\LinesDiscoveryRequestStructure $linesRequest
     * @param \StructType\ServiceFeaturesRequest $serviceFeaturesRequest
     * @param \StructType\ProductCategoriesDiscoveryRequestStructure $productCategoriesRequest
     * @param \StructType\VehicleFeaturesRequestStructure $vehicleFeaturesRequest
     * @param \StructType\InfoChannelDiscoveryRequestStructure $infoChannelRequest
     * @param \StructType\FacilityRequestStructure $facilityRequest
     * @param \StructType\ConnectionLinksDiscoveryRequestStructure $connectionLinksRequest
     * @param \StructType\SubscriptionResponseStructure $subscriptionResponse
     * @param \StructType\TerminateSubscriptionResponseStructure $terminateSubscriptionResponse
     * @param \StructType\SubscriptionTerminatedNotificationStructure $subscriptionTerminatedNotification
     * @param \StructType\DataReadyResponseStructure $dataReadyAcknowledgement
     * @param \StructType\ServiceDelivery $serviceDelivery
     * @param \StructType\DataReceivedResponseStructure $dataReceivedAcknowledgement
     * @param \StructType\CheckStatusResponseStructure $checkStatusResponse
     * @param \StructType\CapabilitiesResponseStructure $capabilitiesResponse
     * @param \StructType\StopPointsDeliveryStructure $stopPointsDelivery
     * @param \StructType\LinesDeliveryStructure $linesDelivery
     * @param \StructType\ProductCategoriesDeliveryStructure $productCategoriesDelivery
     * @param \StructType\ServiceFeaturesDeliveryStructure $serviceFeaturesDelivery
     * @param \StructType\VehicleFeaturesDeliveryStructure $vehicleFeaturesDelivery
     * @param \StructType\InfoChannelDeliveryStructure $infoChannelDelivery
     * @param \StructType\FacilityDeliveryStructure $facilityDelivery
     * @param \StructType\ConnectionLinksDeliveryStructure $connectionLinksDelivery
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ServiceRequest $serviceRequest = null, \StructType\SubscriptionRequest $subscriptionRequest = null, \StructType\TerminateSubscriptionRequestStructure $terminateSubscriptionRequest = null, \StructType\DataReadyRequestStructure $dataReadyNotification = null, \StructType\DataSupplyRequestStructure $dataSupplyRequest = null, \StructType\CheckStatusRequestStructure $checkStatusRequest = null, \StructType\HeartbeatNotificationStructure $heartbeatNotification = null, \StructType\CapabilitiesRequestStructure $capabilitiesRequest = null, \StructType\StopPointsRequest $stopPointsRequest = null, \StructType\LinesDiscoveryRequestStructure $linesRequest = null, \StructType\ServiceFeaturesRequest $serviceFeaturesRequest = null, \StructType\ProductCategoriesDiscoveryRequestStructure $productCategoriesRequest = null, \StructType\VehicleFeaturesRequestStructure $vehicleFeaturesRequest = null, \StructType\InfoChannelDiscoveryRequestStructure $infoChannelRequest = null, \StructType\FacilityRequestStructure $facilityRequest = null, \StructType\ConnectionLinksDiscoveryRequestStructure $connectionLinksRequest = null, \StructType\SubscriptionResponseStructure $subscriptionResponse = null, \StructType\TerminateSubscriptionResponseStructure $terminateSubscriptionResponse = null, \StructType\SubscriptionTerminatedNotificationStructure $subscriptionTerminatedNotification = null, \StructType\DataReadyResponseStructure $dataReadyAcknowledgement = null, \StructType\ServiceDelivery $serviceDelivery = null, \StructType\DataReceivedResponseStructure $dataReceivedAcknowledgement = null, \StructType\CheckStatusResponseStructure $checkStatusResponse = null, \StructType\CapabilitiesResponseStructure $capabilitiesResponse = null, \StructType\StopPointsDeliveryStructure $stopPointsDelivery = null, \StructType\LinesDeliveryStructure $linesDelivery = null, \StructType\ProductCategoriesDeliveryStructure $productCategoriesDelivery = null, \StructType\ServiceFeaturesDeliveryStructure $serviceFeaturesDelivery = null, \StructType\VehicleFeaturesDeliveryStructure $vehicleFeaturesDelivery = null, \StructType\InfoChannelDeliveryStructure $infoChannelDelivery = null, \StructType\FacilityDeliveryStructure $facilityDelivery = null, \StructType\ConnectionLinksDeliveryStructure $connectionLinksDelivery = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setServiceRequest($serviceRequest)
            ->setSubscriptionRequest($subscriptionRequest)
            ->setTerminateSubscriptionRequest($terminateSubscriptionRequest)
            ->setDataReadyNotification($dataReadyNotification)
            ->setDataSupplyRequest($dataSupplyRequest)
            ->setCheckStatusRequest($checkStatusRequest)
            ->setHeartbeatNotification($heartbeatNotification)
            ->setCapabilitiesRequest($capabilitiesRequest)
            ->setStopPointsRequest($stopPointsRequest)
            ->setLinesRequest($linesRequest)
            ->setServiceFeaturesRequest($serviceFeaturesRequest)
            ->setProductCategoriesRequest($productCategoriesRequest)
            ->setVehicleFeaturesRequest($vehicleFeaturesRequest)
            ->setInfoChannelRequest($infoChannelRequest)
            ->setFacilityRequest($facilityRequest)
            ->setConnectionLinksRequest($connectionLinksRequest)
            ->setSubscriptionResponse($subscriptionResponse)
            ->setTerminateSubscriptionResponse($terminateSubscriptionResponse)
            ->setSubscriptionTerminatedNotification($subscriptionTerminatedNotification)
            ->setDataReadyAcknowledgement($dataReadyAcknowledgement)
            ->setServiceDelivery($serviceDelivery)
            ->setDataReceivedAcknowledgement($dataReceivedAcknowledgement)
            ->setCheckStatusResponse($checkStatusResponse)
            ->setCapabilitiesResponse($capabilitiesResponse)
            ->setStopPointsDelivery($stopPointsDelivery)
            ->setLinesDelivery($linesDelivery)
            ->setProductCategoriesDelivery($productCategoriesDelivery)
            ->setServiceFeaturesDelivery($serviceFeaturesDelivery)
            ->setVehicleFeaturesDelivery($vehicleFeaturesDelivery)
            ->setInfoChannelDelivery($infoChannelDelivery)
            ->setFacilityDelivery($facilityDelivery)
            ->setConnectionLinksDelivery($connectionLinksDelivery)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get ServiceRequest value
     * @return \StructType\ServiceRequest|null
     */
    public function getServiceRequest()
    {
        return $this->ServiceRequest;
    }
    /**
     * Set ServiceRequest value
     * @param \StructType\ServiceRequest $serviceRequest
     * @return \StructType\Siri
     */
    public function setServiceRequest(\StructType\ServiceRequest $serviceRequest = null)
    {
        $this->ServiceRequest = $serviceRequest;
        return $this;
    }
    /**
     * Get SubscriptionRequest value
     * @return \StructType\SubscriptionRequest|null
     */
    public function getSubscriptionRequest()
    {
        return $this->SubscriptionRequest;
    }
    /**
     * Set SubscriptionRequest value
     * @param \StructType\SubscriptionRequest $subscriptionRequest
     * @return \StructType\Siri
     */
    public function setSubscriptionRequest(\StructType\SubscriptionRequest $subscriptionRequest = null)
    {
        $this->SubscriptionRequest = $subscriptionRequest;
        return $this;
    }
    /**
     * Get TerminateSubscriptionRequest value
     * @return \StructType\TerminateSubscriptionRequestStructure|null
     */
    public function getTerminateSubscriptionRequest()
    {
        return $this->TerminateSubscriptionRequest;
    }
    /**
     * Set TerminateSubscriptionRequest value
     * @param \StructType\TerminateSubscriptionRequestStructure $terminateSubscriptionRequest
     * @return \StructType\Siri
     */
    public function setTerminateSubscriptionRequest(\StructType\TerminateSubscriptionRequestStructure $terminateSubscriptionRequest = null)
    {
        $this->TerminateSubscriptionRequest = $terminateSubscriptionRequest;
        return $this;
    }
    /**
     * Get DataReadyNotification value
     * @return \StructType\DataReadyRequestStructure|null
     */
    public function getDataReadyNotification()
    {
        return $this->DataReadyNotification;
    }
    /**
     * Set DataReadyNotification value
     * @param \StructType\DataReadyRequestStructure $dataReadyNotification
     * @return \StructType\Siri
     */
    public function setDataReadyNotification(\StructType\DataReadyRequestStructure $dataReadyNotification = null)
    {
        $this->DataReadyNotification = $dataReadyNotification;
        return $this;
    }
    /**
     * Get DataSupplyRequest value
     * @return \StructType\DataSupplyRequestStructure|null
     */
    public function getDataSupplyRequest()
    {
        return $this->DataSupplyRequest;
    }
    /**
     * Set DataSupplyRequest value
     * @param \StructType\DataSupplyRequestStructure $dataSupplyRequest
     * @return \StructType\Siri
     */
    public function setDataSupplyRequest(\StructType\DataSupplyRequestStructure $dataSupplyRequest = null)
    {
        $this->DataSupplyRequest = $dataSupplyRequest;
        return $this;
    }
    /**
     * Get CheckStatusRequest value
     * @return \StructType\CheckStatusRequestStructure|null
     */
    public function getCheckStatusRequest()
    {
        return $this->CheckStatusRequest;
    }
    /**
     * Set CheckStatusRequest value
     * @param \StructType\CheckStatusRequestStructure $checkStatusRequest
     * @return \StructType\Siri
     */
    public function setCheckStatusRequest(\StructType\CheckStatusRequestStructure $checkStatusRequest = null)
    {
        $this->CheckStatusRequest = $checkStatusRequest;
        return $this;
    }
    /**
     * Get HeartbeatNotification value
     * @return \StructType\HeartbeatNotificationStructure|null
     */
    public function getHeartbeatNotification()
    {
        return $this->HeartbeatNotification;
    }
    /**
     * Set HeartbeatNotification value
     * @param \StructType\HeartbeatNotificationStructure $heartbeatNotification
     * @return \StructType\Siri
     */
    public function setHeartbeatNotification(\StructType\HeartbeatNotificationStructure $heartbeatNotification = null)
    {
        $this->HeartbeatNotification = $heartbeatNotification;
        return $this;
    }
    /**
     * Get CapabilitiesRequest value
     * @return \StructType\CapabilitiesRequestStructure|null
     */
    public function getCapabilitiesRequest()
    {
        return $this->CapabilitiesRequest;
    }
    /**
     * Set CapabilitiesRequest value
     * @param \StructType\CapabilitiesRequestStructure $capabilitiesRequest
     * @return \StructType\Siri
     */
    public function setCapabilitiesRequest(\StructType\CapabilitiesRequestStructure $capabilitiesRequest = null)
    {
        $this->CapabilitiesRequest = $capabilitiesRequest;
        return $this;
    }
    /**
     * Get StopPointsRequest value
     * @return \StructType\StopPointsRequest|null
     */
    public function getStopPointsRequest()
    {
        return $this->StopPointsRequest;
    }
    /**
     * Set StopPointsRequest value
     * @param \StructType\StopPointsRequest $stopPointsRequest
     * @return \StructType\Siri
     */
    public function setStopPointsRequest(\StructType\StopPointsRequest $stopPointsRequest = null)
    {
        $this->StopPointsRequest = $stopPointsRequest;
        return $this;
    }
    /**
     * Get LinesRequest value
     * @return \StructType\LinesDiscoveryRequestStructure|null
     */
    public function getLinesRequest()
    {
        return $this->LinesRequest;
    }
    /**
     * Set LinesRequest value
     * @param \StructType\LinesDiscoveryRequestStructure $linesRequest
     * @return \StructType\Siri
     */
    public function setLinesRequest(\StructType\LinesDiscoveryRequestStructure $linesRequest = null)
    {
        $this->LinesRequest = $linesRequest;
        return $this;
    }
    /**
     * Get ServiceFeaturesRequest value
     * @return \StructType\ServiceFeaturesRequest|null
     */
    public function getServiceFeaturesRequest()
    {
        return $this->ServiceFeaturesRequest;
    }
    /**
     * Set ServiceFeaturesRequest value
     * @param \StructType\ServiceFeaturesRequest $serviceFeaturesRequest
     * @return \StructType\Siri
     */
    public function setServiceFeaturesRequest(\StructType\ServiceFeaturesRequest $serviceFeaturesRequest = null)
    {
        $this->ServiceFeaturesRequest = $serviceFeaturesRequest;
        return $this;
    }
    /**
     * Get ProductCategoriesRequest value
     * @return \StructType\ProductCategoriesDiscoveryRequestStructure|null
     */
    public function getProductCategoriesRequest()
    {
        return $this->ProductCategoriesRequest;
    }
    /**
     * Set ProductCategoriesRequest value
     * @param \StructType\ProductCategoriesDiscoveryRequestStructure $productCategoriesRequest
     * @return \StructType\Siri
     */
    public function setProductCategoriesRequest(\StructType\ProductCategoriesDiscoveryRequestStructure $productCategoriesRequest = null)
    {
        $this->ProductCategoriesRequest = $productCategoriesRequest;
        return $this;
    }
    /**
     * Get VehicleFeaturesRequest value
     * @return \StructType\VehicleFeaturesRequestStructure|null
     */
    public function getVehicleFeaturesRequest()
    {
        return $this->VehicleFeaturesRequest;
    }
    /**
     * Set VehicleFeaturesRequest value
     * @param \StructType\VehicleFeaturesRequestStructure $vehicleFeaturesRequest
     * @return \StructType\Siri
     */
    public function setVehicleFeaturesRequest(\StructType\VehicleFeaturesRequestStructure $vehicleFeaturesRequest = null)
    {
        $this->VehicleFeaturesRequest = $vehicleFeaturesRequest;
        return $this;
    }
    /**
     * Get InfoChannelRequest value
     * @return \StructType\InfoChannelDiscoveryRequestStructure|null
     */
    public function getInfoChannelRequest()
    {
        return $this->InfoChannelRequest;
    }
    /**
     * Set InfoChannelRequest value
     * @param \StructType\InfoChannelDiscoveryRequestStructure $infoChannelRequest
     * @return \StructType\Siri
     */
    public function setInfoChannelRequest(\StructType\InfoChannelDiscoveryRequestStructure $infoChannelRequest = null)
    {
        $this->InfoChannelRequest = $infoChannelRequest;
        return $this;
    }
    /**
     * Get FacilityRequest value
     * @return \StructType\FacilityRequestStructure|null
     */
    public function getFacilityRequest()
    {
        return $this->FacilityRequest;
    }
    /**
     * Set FacilityRequest value
     * @param \StructType\FacilityRequestStructure $facilityRequest
     * @return \StructType\Siri
     */
    public function setFacilityRequest(\StructType\FacilityRequestStructure $facilityRequest = null)
    {
        $this->FacilityRequest = $facilityRequest;
        return $this;
    }
    /**
     * Get ConnectionLinksRequest value
     * @return \StructType\ConnectionLinksDiscoveryRequestStructure|null
     */
    public function getConnectionLinksRequest()
    {
        return $this->ConnectionLinksRequest;
    }
    /**
     * Set ConnectionLinksRequest value
     * @param \StructType\ConnectionLinksDiscoveryRequestStructure $connectionLinksRequest
     * @return \StructType\Siri
     */
    public function setConnectionLinksRequest(\StructType\ConnectionLinksDiscoveryRequestStructure $connectionLinksRequest = null)
    {
        $this->ConnectionLinksRequest = $connectionLinksRequest;
        return $this;
    }
    /**
     * Get SubscriptionResponse value
     * @return \StructType\SubscriptionResponseStructure|null
     */
    public function getSubscriptionResponse()
    {
        return $this->SubscriptionResponse;
    }
    /**
     * Set SubscriptionResponse value
     * @param \StructType\SubscriptionResponseStructure $subscriptionResponse
     * @return \StructType\Siri
     */
    public function setSubscriptionResponse(\StructType\SubscriptionResponseStructure $subscriptionResponse = null)
    {
        $this->SubscriptionResponse = $subscriptionResponse;
        return $this;
    }
    /**
     * Get TerminateSubscriptionResponse value
     * @return \StructType\TerminateSubscriptionResponseStructure|null
     */
    public function getTerminateSubscriptionResponse()
    {
        return $this->TerminateSubscriptionResponse;
    }
    /**
     * Set TerminateSubscriptionResponse value
     * @param \StructType\TerminateSubscriptionResponseStructure $terminateSubscriptionResponse
     * @return \StructType\Siri
     */
    public function setTerminateSubscriptionResponse(\StructType\TerminateSubscriptionResponseStructure $terminateSubscriptionResponse = null)
    {
        $this->TerminateSubscriptionResponse = $terminateSubscriptionResponse;
        return $this;
    }
    /**
     * Get SubscriptionTerminatedNotification value
     * @return \StructType\SubscriptionTerminatedNotificationStructure|null
     */
    public function getSubscriptionTerminatedNotification()
    {
        return $this->SubscriptionTerminatedNotification;
    }
    /**
     * Set SubscriptionTerminatedNotification value
     * @param \StructType\SubscriptionTerminatedNotificationStructure $subscriptionTerminatedNotification
     * @return \StructType\Siri
     */
    public function setSubscriptionTerminatedNotification(\StructType\SubscriptionTerminatedNotificationStructure $subscriptionTerminatedNotification = null)
    {
        $this->SubscriptionTerminatedNotification = $subscriptionTerminatedNotification;
        return $this;
    }
    /**
     * Get DataReadyAcknowledgement value
     * @return \StructType\DataReadyResponseStructure|null
     */
    public function getDataReadyAcknowledgement()
    {
        return $this->DataReadyAcknowledgement;
    }
    /**
     * Set DataReadyAcknowledgement value
     * @param \StructType\DataReadyResponseStructure $dataReadyAcknowledgement
     * @return \StructType\Siri
     */
    public function setDataReadyAcknowledgement(\StructType\DataReadyResponseStructure $dataReadyAcknowledgement = null)
    {
        $this->DataReadyAcknowledgement = $dataReadyAcknowledgement;
        return $this;
    }
    /**
     * Get ServiceDelivery value
     * @return \StructType\ServiceDelivery|null
     */
    public function getServiceDelivery()
    {
        return $this->ServiceDelivery;
    }
    /**
     * Set ServiceDelivery value
     * @param \StructType\ServiceDelivery $serviceDelivery
     * @return \StructType\Siri
     */
    public function setServiceDelivery(\StructType\ServiceDelivery $serviceDelivery = null)
    {
        $this->ServiceDelivery = $serviceDelivery;
        return $this;
    }
    /**
     * Get DataReceivedAcknowledgement value
     * @return \StructType\DataReceivedResponseStructure|null
     */
    public function getDataReceivedAcknowledgement()
    {
        return $this->DataReceivedAcknowledgement;
    }
    /**
     * Set DataReceivedAcknowledgement value
     * @param \StructType\DataReceivedResponseStructure $dataReceivedAcknowledgement
     * @return \StructType\Siri
     */
    public function setDataReceivedAcknowledgement(\StructType\DataReceivedResponseStructure $dataReceivedAcknowledgement = null)
    {
        $this->DataReceivedAcknowledgement = $dataReceivedAcknowledgement;
        return $this;
    }
    /**
     * Get CheckStatusResponse value
     * @return \StructType\CheckStatusResponseStructure|null
     */
    public function getCheckStatusResponse()
    {
        return $this->CheckStatusResponse;
    }
    /**
     * Set CheckStatusResponse value
     * @param \StructType\CheckStatusResponseStructure $checkStatusResponse
     * @return \StructType\Siri
     */
    public function setCheckStatusResponse(\StructType\CheckStatusResponseStructure $checkStatusResponse = null)
    {
        $this->CheckStatusResponse = $checkStatusResponse;
        return $this;
    }
    /**
     * Get CapabilitiesResponse value
     * @return \StructType\CapabilitiesResponseStructure|null
     */
    public function getCapabilitiesResponse()
    {
        return $this->CapabilitiesResponse;
    }
    /**
     * Set CapabilitiesResponse value
     * @param \StructType\CapabilitiesResponseStructure $capabilitiesResponse
     * @return \StructType\Siri
     */
    public function setCapabilitiesResponse(\StructType\CapabilitiesResponseStructure $capabilitiesResponse = null)
    {
        $this->CapabilitiesResponse = $capabilitiesResponse;
        return $this;
    }
    /**
     * Get StopPointsDelivery value
     * @return \StructType\StopPointsDeliveryStructure|null
     */
    public function getStopPointsDelivery()
    {
        return $this->StopPointsDelivery;
    }
    /**
     * Set StopPointsDelivery value
     * @param \StructType\StopPointsDeliveryStructure $stopPointsDelivery
     * @return \StructType\Siri
     */
    public function setStopPointsDelivery(\StructType\StopPointsDeliveryStructure $stopPointsDelivery = null)
    {
        $this->StopPointsDelivery = $stopPointsDelivery;
        return $this;
    }
    /**
     * Get LinesDelivery value
     * @return \StructType\LinesDeliveryStructure|null
     */
    public function getLinesDelivery()
    {
        return $this->LinesDelivery;
    }
    /**
     * Set LinesDelivery value
     * @param \StructType\LinesDeliveryStructure $linesDelivery
     * @return \StructType\Siri
     */
    public function setLinesDelivery(\StructType\LinesDeliveryStructure $linesDelivery = null)
    {
        $this->LinesDelivery = $linesDelivery;
        return $this;
    }
    /**
     * Get ProductCategoriesDelivery value
     * @return \StructType\ProductCategoriesDeliveryStructure|null
     */
    public function getProductCategoriesDelivery()
    {
        return $this->ProductCategoriesDelivery;
    }
    /**
     * Set ProductCategoriesDelivery value
     * @param \StructType\ProductCategoriesDeliveryStructure $productCategoriesDelivery
     * @return \StructType\Siri
     */
    public function setProductCategoriesDelivery(\StructType\ProductCategoriesDeliveryStructure $productCategoriesDelivery = null)
    {
        $this->ProductCategoriesDelivery = $productCategoriesDelivery;
        return $this;
    }
    /**
     * Get ServiceFeaturesDelivery value
     * @return \StructType\ServiceFeaturesDeliveryStructure|null
     */
    public function getServiceFeaturesDelivery()
    {
        return $this->ServiceFeaturesDelivery;
    }
    /**
     * Set ServiceFeaturesDelivery value
     * @param \StructType\ServiceFeaturesDeliveryStructure $serviceFeaturesDelivery
     * @return \StructType\Siri
     */
    public function setServiceFeaturesDelivery(\StructType\ServiceFeaturesDeliveryStructure $serviceFeaturesDelivery = null)
    {
        $this->ServiceFeaturesDelivery = $serviceFeaturesDelivery;
        return $this;
    }
    /**
     * Get VehicleFeaturesDelivery value
     * @return \StructType\VehicleFeaturesDeliveryStructure|null
     */
    public function getVehicleFeaturesDelivery()
    {
        return $this->VehicleFeaturesDelivery;
    }
    /**
     * Set VehicleFeaturesDelivery value
     * @param \StructType\VehicleFeaturesDeliveryStructure $vehicleFeaturesDelivery
     * @return \StructType\Siri
     */
    public function setVehicleFeaturesDelivery(\StructType\VehicleFeaturesDeliveryStructure $vehicleFeaturesDelivery = null)
    {
        $this->VehicleFeaturesDelivery = $vehicleFeaturesDelivery;
        return $this;
    }
    /**
     * Get InfoChannelDelivery value
     * @return \StructType\InfoChannelDeliveryStructure|null
     */
    public function getInfoChannelDelivery()
    {
        return $this->InfoChannelDelivery;
    }
    /**
     * Set InfoChannelDelivery value
     * @param \StructType\InfoChannelDeliveryStructure $infoChannelDelivery
     * @return \StructType\Siri
     */
    public function setInfoChannelDelivery(\StructType\InfoChannelDeliveryStructure $infoChannelDelivery = null)
    {
        $this->InfoChannelDelivery = $infoChannelDelivery;
        return $this;
    }
    /**
     * Get FacilityDelivery value
     * @return \StructType\FacilityDeliveryStructure|null
     */
    public function getFacilityDelivery()
    {
        return $this->FacilityDelivery;
    }
    /**
     * Set FacilityDelivery value
     * @param \StructType\FacilityDeliveryStructure $facilityDelivery
     * @return \StructType\Siri
     */
    public function setFacilityDelivery(\StructType\FacilityDeliveryStructure $facilityDelivery = null)
    {
        $this->FacilityDelivery = $facilityDelivery;
        return $this;
    }
    /**
     * Get ConnectionLinksDelivery value
     * @return \StructType\ConnectionLinksDeliveryStructure|null
     */
    public function getConnectionLinksDelivery()
    {
        return $this->ConnectionLinksDelivery;
    }
    /**
     * Set ConnectionLinksDelivery value
     * @param \StructType\ConnectionLinksDeliveryStructure $connectionLinksDelivery
     * @return \StructType\Siri
     */
    public function setConnectionLinksDelivery(\StructType\ConnectionLinksDeliveryStructure $connectionLinksDelivery = null)
    {
        $this->ConnectionLinksDelivery = $connectionLinksDelivery;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\Siri
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Siri
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Siri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
