<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleContactStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Simple Contact Details.
 * @subpackage Structs
 */
class SimpleContactStructure extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Phone number +SIRI v2.0 | International phonenumber +41675601 etc.
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - documentation: Url for contact +SIRI v2.0
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for SimpleContactStructure
     * @uses SimpleContactStructure::setPhoneNumber()
     * @uses SimpleContactStructure::setUrl()
     * @param string $phoneNumber
     * @param string $url
     */
    public function __construct($phoneNumber = null, $url = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setUrl($url);
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\SimpleContactStructure
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\SimpleContactStructure
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleContactStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
