<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignSetting StructType
 * @subpackage Structs
 */
abstract class SignSetting extends OperatorAction
{
    /**
     * The datexPictogram
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $datexPictogram;
    /**
     * The pictogramList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $pictogramList;
    /**
     * The pictogramListEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string[]
     */
    public $pictogramListEntry;
    /**
     * The reasonForSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $reasonForSetting;
    /**
     * The setBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $setBy;
    /**
     * The signAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $signAddress;
    /**
     * The timeLastSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeLastSet;
    /**
     * The signSettingExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $signSettingExtension;
    /**
     * Constructor method for SignSetting
     * @uses SignSetting::setDatexPictogram()
     * @uses SignSetting::setPictogramList()
     * @uses SignSetting::setPictogramListEntry()
     * @uses SignSetting::setReasonForSetting()
     * @uses SignSetting::setSetBy()
     * @uses SignSetting::setSignAddress()
     * @uses SignSetting::setTimeLastSet()
     * @uses SignSetting::setSignSettingExtension()
     * @param string[] $datexPictogram
     * @param string $pictogramList
     * @param string[] $pictogramListEntry
     * @param \StructType\MultilingualString $reasonForSetting
     * @param \StructType\MultilingualString $setBy
     * @param string $signAddress
     * @param string $timeLastSet
     * @param \StructType\ExtensionType $signSettingExtension
     */
    public function __construct(array $datexPictogram = array(), $pictogramList = null, array $pictogramListEntry = array(), \StructType\MultilingualString $reasonForSetting = null, \StructType\MultilingualString $setBy = null, $signAddress = null, $timeLastSet = null, \StructType\ExtensionType $signSettingExtension = null)
    {
        $this
            ->setDatexPictogram($datexPictogram)
            ->setPictogramList($pictogramList)
            ->setPictogramListEntry($pictogramListEntry)
            ->setReasonForSetting($reasonForSetting)
            ->setSetBy($setBy)
            ->setSignAddress($signAddress)
            ->setTimeLastSet($timeLastSet)
            ->setSignSettingExtension($signSettingExtension);
    }
    /**
     * Get datexPictogram value
     * @return string[]|null
     */
    public function getDatexPictogram()
    {
        return $this->datexPictogram;
    }
    /**
     * Set datexPictogram value
     * @uses \EnumType\DatexPictogramEnum::valueIsValid()
     * @uses \EnumType\DatexPictogramEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $datexPictogram
     * @return \StructType\SignSetting
     */
    public function setDatexPictogram(array $datexPictogram = array())
    {
        $invalidValues = array();
        foreach ($datexPictogram as $signSettingDatexPictogramItem) {
            if (!\EnumType\DatexPictogramEnum::valueIsValid($signSettingDatexPictogramItem)) {
                $invalidValues[] = var_export($signSettingDatexPictogramItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\DatexPictogramEnum::getValidValues())), __LINE__);
        }
        $this->datexPictogram = $datexPictogram;
        return $this;
    }
    /**
     * Add item to datexPictogram value
     * @uses \EnumType\DatexPictogramEnum::valueIsValid()
     * @uses \EnumType\DatexPictogramEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SignSetting
     */
    public function addToDatexPictogram($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatexPictogramEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\DatexPictogramEnum::getValidValues())), __LINE__);
        }
        $this->datexPictogram[] = $item;
        return $this;
    }
    /**
     * Get pictogramList value
     * @return string|null
     */
    public function getPictogramList()
    {
        return $this->pictogramList;
    }
    /**
     * Set pictogramList value
     * @param string $pictogramList
     * @return \StructType\SignSetting
     */
    public function setPictogramList($pictogramList = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pictogramList) && strlen($pictogramList) > 1024) || (is_array($pictogramList) && count($pictogramList) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($pictogramList) ? strlen($pictogramList) : count($pictogramList)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pictogramList) && !is_string($pictogramList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pictogramList)), __LINE__);
        }
        $this->pictogramList = $pictogramList;
        return $this;
    }
    /**
     * Get pictogramListEntry value
     * @return string[]|null
     */
    public function getPictogramListEntry()
    {
        return $this->pictogramListEntry;
    }
    /**
     * Set pictogramListEntry value
     * @throws \InvalidArgumentException
     * @param string[] $pictogramListEntry
     * @return \StructType\SignSetting
     */
    public function setPictogramListEntry(array $pictogramListEntry = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($pictogramListEntry) && strlen($pictogramListEntry) > 1024) || (is_array($pictogramListEntry) && count($pictogramListEntry) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($pictogramListEntry) ? strlen($pictogramListEntry) : count($pictogramListEntry)), __LINE__);
        }
        foreach ($pictogramListEntry as $signSettingPictogramListEntryItem) {
            // validation for constraint: itemType
            if (!is_string($signSettingPictogramListEntryItem)) {
                throw new \InvalidArgumentException(sprintf('The pictogramListEntry property can only contain items of string, "%s" given', is_object($signSettingPictogramListEntryItem) ? get_class($signSettingPictogramListEntryItem) : gettype($signSettingPictogramListEntryItem)), __LINE__);
            }
        }
        $this->pictogramListEntry = $pictogramListEntry;
        return $this;
    }
    /**
     * Add item to pictogramListEntry value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SignSetting
     */
    public function addToPictogramListEntry($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 1024) || (is_array($item) && count($item) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The pictogramListEntry property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pictogramListEntry[] = $item;
        return $this;
    }
    /**
     * Get reasonForSetting value
     * @return \StructType\MultilingualString|null
     */
    public function getReasonForSetting()
    {
        return $this->reasonForSetting;
    }
    /**
     * Set reasonForSetting value
     * @param \StructType\MultilingualString $reasonForSetting
     * @return \StructType\SignSetting
     */
    public function setReasonForSetting(\StructType\MultilingualString $reasonForSetting = null)
    {
        $this->reasonForSetting = $reasonForSetting;
        return $this;
    }
    /**
     * Get setBy value
     * @return \StructType\MultilingualString|null
     */
    public function getSetBy()
    {
        return $this->setBy;
    }
    /**
     * Set setBy value
     * @param \StructType\MultilingualString $setBy
     * @return \StructType\SignSetting
     */
    public function setSetBy(\StructType\MultilingualString $setBy = null)
    {
        $this->setBy = $setBy;
        return $this;
    }
    /**
     * Get signAddress value
     * @return string|null
     */
    public function getSignAddress()
    {
        return $this->signAddress;
    }
    /**
     * Set signAddress value
     * @param string $signAddress
     * @return \StructType\SignSetting
     */
    public function setSignAddress($signAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($signAddress) && strlen($signAddress) > 1024) || (is_array($signAddress) && count($signAddress) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($signAddress) ? strlen($signAddress) : count($signAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signAddress) && !is_string($signAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signAddress)), __LINE__);
        }
        $this->signAddress = $signAddress;
        return $this;
    }
    /**
     * Get timeLastSet value
     * @return string|null
     */
    public function getTimeLastSet()
    {
        return $this->timeLastSet;
    }
    /**
     * Set timeLastSet value
     * @param string $timeLastSet
     * @return \StructType\SignSetting
     */
    public function setTimeLastSet($timeLastSet = null)
    {
        // validation for constraint: string
        if (!is_null($timeLastSet) && !is_string($timeLastSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeLastSet)), __LINE__);
        }
        $this->timeLastSet = $timeLastSet;
        return $this;
    }
    /**
     * Get signSettingExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSignSettingExtension()
    {
        return $this->signSettingExtension;
    }
    /**
     * Set signSettingExtension value
     * @param \StructType\ExtensionType $signSettingExtension
     * @return \StructType\SignSetting
     */
    public function setSignSettingExtension(\StructType\ExtensionType $signSettingExtension = null)
    {
        $this->signSettingExtension = $signSettingExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
