<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestContextStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Configurable context for requests. Intended Primarily as a documentation mechanism.
 * @subpackage Structs
 */
class ServiceRequestContextStructure extends AbstractStructBase
{
    /**
     * The CheckStatusAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $CheckStatusAddress;
    /**
     * The SubscribeAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $SubscribeAddress;
    /**
     * The ManageSubscriptionAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $ManageSubscriptionAddress;
    /**
     * The GetDataAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $GetDataAddress;
    /**
     * The StatusResponseAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $StatusResponseAddress;
    /**
     * The SubscriberAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $SubscriberAddress;
    /**
     * The NotifyAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $NotifyAddress;
    /**
     * The ConsumerAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $ConsumerAddress;
    /**
     * The DataNameSpaces
     * @var \StructType\DataNameSpacesStructure
     */
    public $DataNameSpaces;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The WgsDecimalDegrees
     * @var string
     */
    public $WgsDecimalDegrees;
    /**
     * The GmlCoordinateFormat
     * Meta informations extracted from the WSDL
     * - documentation: Type for coordinate reference system.
     * @var string
     */
    public $GmlCoordinateFormat;
    /**
     * The DistanceUnits
     * @var string
     */
    public $DistanceUnits;
    /**
     * The VelocityUnits
     * @var string
     */
    public $VelocityUnits;
    /**
     * The DataHorizon
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $DataHorizon;
    /**
     * The RequestTimeout
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $RequestTimeout;
    /**
     * The DeliveryMethod
     * @var string
     */
    public $DeliveryMethod;
    /**
     * The MultipartDespatch
     * @var bool
     */
    public $MultipartDespatch;
    /**
     * The ConfirmDelivery
     * @var bool
     */
    public $ConfirmDelivery;
    /**
     * The MaximimumNumberOfSubscriptions
     * @var int
     */
    public $MaximimumNumberOfSubscriptions;
    /**
     * The AllowedPredictors
     * @var string
     */
    public $AllowedPredictors;
    /**
     * The PredictionFunction
     * @var string
     */
    public $PredictionFunction;
    /**
     * Constructor method for ServiceRequestContextStructure
     * @uses ServiceRequestContextStructure::setCheckStatusAddress()
     * @uses ServiceRequestContextStructure::setSubscribeAddress()
     * @uses ServiceRequestContextStructure::setManageSubscriptionAddress()
     * @uses ServiceRequestContextStructure::setGetDataAddress()
     * @uses ServiceRequestContextStructure::setStatusResponseAddress()
     * @uses ServiceRequestContextStructure::setSubscriberAddress()
     * @uses ServiceRequestContextStructure::setNotifyAddress()
     * @uses ServiceRequestContextStructure::setConsumerAddress()
     * @uses ServiceRequestContextStructure::setDataNameSpaces()
     * @uses ServiceRequestContextStructure::setLanguage()
     * @uses ServiceRequestContextStructure::setWgsDecimalDegrees()
     * @uses ServiceRequestContextStructure::setGmlCoordinateFormat()
     * @uses ServiceRequestContextStructure::setDistanceUnits()
     * @uses ServiceRequestContextStructure::setVelocityUnits()
     * @uses ServiceRequestContextStructure::setDataHorizon()
     * @uses ServiceRequestContextStructure::setRequestTimeout()
     * @uses ServiceRequestContextStructure::setDeliveryMethod()
     * @uses ServiceRequestContextStructure::setMultipartDespatch()
     * @uses ServiceRequestContextStructure::setConfirmDelivery()
     * @uses ServiceRequestContextStructure::setMaximimumNumberOfSubscriptions()
     * @uses ServiceRequestContextStructure::setAllowedPredictors()
     * @uses ServiceRequestContextStructure::setPredictionFunction()
     * @param string $checkStatusAddress
     * @param string $subscribeAddress
     * @param string $manageSubscriptionAddress
     * @param string $getDataAddress
     * @param string $statusResponseAddress
     * @param string $subscriberAddress
     * @param string $notifyAddress
     * @param string $consumerAddress
     * @param \StructType\DataNameSpacesStructure $dataNameSpaces
     * @param string $language
     * @param string $wgsDecimalDegrees
     * @param string $gmlCoordinateFormat
     * @param string $distanceUnits
     * @param string $velocityUnits
     * @param string $dataHorizon
     * @param string $requestTimeout
     * @param string $deliveryMethod
     * @param bool $multipartDespatch
     * @param bool $confirmDelivery
     * @param int $maximimumNumberOfSubscriptions
     * @param string $allowedPredictors
     * @param string $predictionFunction
     */
    public function __construct($checkStatusAddress = null, $subscribeAddress = null, $manageSubscriptionAddress = null, $getDataAddress = null, $statusResponseAddress = null, $subscriberAddress = null, $notifyAddress = null, $consumerAddress = null, \StructType\DataNameSpacesStructure $dataNameSpaces = null, $language = null, $wgsDecimalDegrees = null, $gmlCoordinateFormat = null, $distanceUnits = null, $velocityUnits = null, $dataHorizon = null, $requestTimeout = null, $deliveryMethod = null, $multipartDespatch = null, $confirmDelivery = null, $maximimumNumberOfSubscriptions = null, $allowedPredictors = null, $predictionFunction = null)
    {
        $this
            ->setCheckStatusAddress($checkStatusAddress)
            ->setSubscribeAddress($subscribeAddress)
            ->setManageSubscriptionAddress($manageSubscriptionAddress)
            ->setGetDataAddress($getDataAddress)
            ->setStatusResponseAddress($statusResponseAddress)
            ->setSubscriberAddress($subscriberAddress)
            ->setNotifyAddress($notifyAddress)
            ->setConsumerAddress($consumerAddress)
            ->setDataNameSpaces($dataNameSpaces)
            ->setLanguage($language)
            ->setWgsDecimalDegrees($wgsDecimalDegrees)
            ->setGmlCoordinateFormat($gmlCoordinateFormat)
            ->setDistanceUnits($distanceUnits)
            ->setVelocityUnits($velocityUnits)
            ->setDataHorizon($dataHorizon)
            ->setRequestTimeout($requestTimeout)
            ->setDeliveryMethod($deliveryMethod)
            ->setMultipartDespatch($multipartDespatch)
            ->setConfirmDelivery($confirmDelivery)
            ->setMaximimumNumberOfSubscriptions($maximimumNumberOfSubscriptions)
            ->setAllowedPredictors($allowedPredictors)
            ->setPredictionFunction($predictionFunction);
    }
    /**
     * Get CheckStatusAddress value
     * @return string|null
     */
    public function getCheckStatusAddress()
    {
        return $this->CheckStatusAddress;
    }
    /**
     * Set CheckStatusAddress value
     * @param string $checkStatusAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setCheckStatusAddress($checkStatusAddress = null)
    {
        // validation for constraint: string
        if (!is_null($checkStatusAddress) && !is_string($checkStatusAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkStatusAddress)), __LINE__);
        }
        $this->CheckStatusAddress = $checkStatusAddress;
        return $this;
    }
    /**
     * Get SubscribeAddress value
     * @return string|null
     */
    public function getSubscribeAddress()
    {
        return $this->SubscribeAddress;
    }
    /**
     * Set SubscribeAddress value
     * @param string $subscribeAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setSubscribeAddress($subscribeAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subscribeAddress) && !is_string($subscribeAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscribeAddress)), __LINE__);
        }
        $this->SubscribeAddress = $subscribeAddress;
        return $this;
    }
    /**
     * Get ManageSubscriptionAddress value
     * @return string|null
     */
    public function getManageSubscriptionAddress()
    {
        return $this->ManageSubscriptionAddress;
    }
    /**
     * Set ManageSubscriptionAddress value
     * @param string $manageSubscriptionAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setManageSubscriptionAddress($manageSubscriptionAddress = null)
    {
        // validation for constraint: string
        if (!is_null($manageSubscriptionAddress) && !is_string($manageSubscriptionAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manageSubscriptionAddress)), __LINE__);
        }
        $this->ManageSubscriptionAddress = $manageSubscriptionAddress;
        return $this;
    }
    /**
     * Get GetDataAddress value
     * @return string|null
     */
    public function getGetDataAddress()
    {
        return $this->GetDataAddress;
    }
    /**
     * Set GetDataAddress value
     * @param string $getDataAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setGetDataAddress($getDataAddress = null)
    {
        // validation for constraint: string
        if (!is_null($getDataAddress) && !is_string($getDataAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($getDataAddress)), __LINE__);
        }
        $this->GetDataAddress = $getDataAddress;
        return $this;
    }
    /**
     * Get StatusResponseAddress value
     * @return string|null
     */
    public function getStatusResponseAddress()
    {
        return $this->StatusResponseAddress;
    }
    /**
     * Set StatusResponseAddress value
     * @param string $statusResponseAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setStatusResponseAddress($statusResponseAddress = null)
    {
        // validation for constraint: string
        if (!is_null($statusResponseAddress) && !is_string($statusResponseAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusResponseAddress)), __LINE__);
        }
        $this->StatusResponseAddress = $statusResponseAddress;
        return $this;
    }
    /**
     * Get SubscriberAddress value
     * @return string|null
     */
    public function getSubscriberAddress()
    {
        return $this->SubscriberAddress;
    }
    /**
     * Set SubscriberAddress value
     * @param string $subscriberAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setSubscriberAddress($subscriberAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberAddress) && !is_string($subscriberAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberAddress)), __LINE__);
        }
        $this->SubscriberAddress = $subscriberAddress;
        return $this;
    }
    /**
     * Get NotifyAddress value
     * @return string|null
     */
    public function getNotifyAddress()
    {
        return $this->NotifyAddress;
    }
    /**
     * Set NotifyAddress value
     * @param string $notifyAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setNotifyAddress($notifyAddress = null)
    {
        // validation for constraint: string
        if (!is_null($notifyAddress) && !is_string($notifyAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notifyAddress)), __LINE__);
        }
        $this->NotifyAddress = $notifyAddress;
        return $this;
    }
    /**
     * Get ConsumerAddress value
     * @return string|null
     */
    public function getConsumerAddress()
    {
        return $this->ConsumerAddress;
    }
    /**
     * Set ConsumerAddress value
     * @param string $consumerAddress
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setConsumerAddress($consumerAddress = null)
    {
        // validation for constraint: string
        if (!is_null($consumerAddress) && !is_string($consumerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consumerAddress)), __LINE__);
        }
        $this->ConsumerAddress = $consumerAddress;
        return $this;
    }
    /**
     * Get DataNameSpaces value
     * @return \StructType\DataNameSpacesStructure|null
     */
    public function getDataNameSpaces()
    {
        return $this->DataNameSpaces;
    }
    /**
     * Set DataNameSpaces value
     * @param \StructType\DataNameSpacesStructure $dataNameSpaces
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setDataNameSpaces(\StructType\DataNameSpacesStructure $dataNameSpaces = null)
    {
        $this->DataNameSpaces = $dataNameSpaces;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get WgsDecimalDegrees value
     * @return string|null
     */
    public function getWgsDecimalDegrees()
    {
        return $this->WgsDecimalDegrees;
    }
    /**
     * Set WgsDecimalDegrees value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wgsDecimalDegrees
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setWgsDecimalDegrees($wgsDecimalDegrees = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($wgsDecimalDegrees)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $wgsDecimalDegrees, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->WgsDecimalDegrees = $wgsDecimalDegrees;
        return $this;
    }
    /**
     * Get GmlCoordinateFormat value
     * @return string|null
     */
    public function getGmlCoordinateFormat()
    {
        return $this->GmlCoordinateFormat;
    }
    /**
     * Set GmlCoordinateFormat value
     * @param string $gmlCoordinateFormat
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setGmlCoordinateFormat($gmlCoordinateFormat = null)
    {
        // validation for constraint: string
        if (!is_null($gmlCoordinateFormat) && !is_string($gmlCoordinateFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gmlCoordinateFormat)), __LINE__);
        }
        $this->GmlCoordinateFormat = $gmlCoordinateFormat;
        return $this;
    }
    /**
     * Get DistanceUnits value
     * @return string|null
     */
    public function getDistanceUnits()
    {
        return $this->DistanceUnits;
    }
    /**
     * Set DistanceUnits value
     * @param string $distanceUnits
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setDistanceUnits($distanceUnits = null)
    {
        // validation for constraint: string
        if (!is_null($distanceUnits) && !is_string($distanceUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceUnits)), __LINE__);
        }
        $this->DistanceUnits = $distanceUnits;
        return $this;
    }
    /**
     * Get VelocityUnits value
     * @return string|null
     */
    public function getVelocityUnits()
    {
        return $this->VelocityUnits;
    }
    /**
     * Set VelocityUnits value
     * @param string $velocityUnits
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setVelocityUnits($velocityUnits = null)
    {
        // validation for constraint: string
        if (!is_null($velocityUnits) && !is_string($velocityUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($velocityUnits)), __LINE__);
        }
        $this->VelocityUnits = $velocityUnits;
        return $this;
    }
    /**
     * Get DataHorizon value
     * @return string|null
     */
    public function getDataHorizon()
    {
        return $this->DataHorizon;
    }
    /**
     * Set DataHorizon value
     * @param string $dataHorizon
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setDataHorizon($dataHorizon = null)
    {
        // validation for constraint: string
        if (!is_null($dataHorizon) && !is_string($dataHorizon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataHorizon)), __LINE__);
        }
        $this->DataHorizon = $dataHorizon;
        return $this;
    }
    /**
     * Get RequestTimeout value
     * @return string|null
     */
    public function getRequestTimeout()
    {
        return $this->RequestTimeout;
    }
    /**
     * Set RequestTimeout value
     * @param string $requestTimeout
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setRequestTimeout($requestTimeout = null)
    {
        // validation for constraint: string
        if (!is_null($requestTimeout) && !is_string($requestTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTimeout)), __LINE__);
        }
        $this->RequestTimeout = $requestTimeout;
        return $this;
    }
    /**
     * Get DeliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->DeliveryMethod;
    }
    /**
     * Set DeliveryMethod value
     * @uses \EnumType\DeliveryMethodEnumeration::valueIsValid()
     * @uses \EnumType\DeliveryMethodEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethod
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodEnumeration::valueIsValid($deliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethod, implode(', ', \EnumType\DeliveryMethodEnumeration::getValidValues())), __LINE__);
        }
        $this->DeliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get MultipartDespatch value
     * @return bool|null
     */
    public function getMultipartDespatch()
    {
        return $this->MultipartDespatch;
    }
    /**
     * Set MultipartDespatch value
     * @param bool $multipartDespatch
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setMultipartDespatch($multipartDespatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($multipartDespatch) && !is_bool($multipartDespatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multipartDespatch)), __LINE__);
        }
        $this->MultipartDespatch = $multipartDespatch;
        return $this;
    }
    /**
     * Get ConfirmDelivery value
     * @return bool|null
     */
    public function getConfirmDelivery()
    {
        return $this->ConfirmDelivery;
    }
    /**
     * Set ConfirmDelivery value
     * @param bool $confirmDelivery
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setConfirmDelivery($confirmDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmDelivery) && !is_bool($confirmDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($confirmDelivery)), __LINE__);
        }
        $this->ConfirmDelivery = $confirmDelivery;
        return $this;
    }
    /**
     * Get MaximimumNumberOfSubscriptions value
     * @return int|null
     */
    public function getMaximimumNumberOfSubscriptions()
    {
        return $this->MaximimumNumberOfSubscriptions;
    }
    /**
     * Set MaximimumNumberOfSubscriptions value
     * @param int $maximimumNumberOfSubscriptions
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setMaximimumNumberOfSubscriptions($maximimumNumberOfSubscriptions = null)
    {
        // validation for constraint: int
        if (!is_null($maximimumNumberOfSubscriptions) && !is_numeric($maximimumNumberOfSubscriptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximimumNumberOfSubscriptions)), __LINE__);
        }
        $this->MaximimumNumberOfSubscriptions = $maximimumNumberOfSubscriptions;
        return $this;
    }
    /**
     * Get AllowedPredictors value
     * @return string|null
     */
    public function getAllowedPredictors()
    {
        return $this->AllowedPredictors;
    }
    /**
     * Set AllowedPredictors value
     * @uses \EnumType\PredictorsEnumeration::valueIsValid()
     * @uses \EnumType\PredictorsEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowedPredictors
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setAllowedPredictors($allowedPredictors = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PredictorsEnumeration::valueIsValid($allowedPredictors)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allowedPredictors, implode(', ', \EnumType\PredictorsEnumeration::getValidValues())), __LINE__);
        }
        $this->AllowedPredictors = $allowedPredictors;
        return $this;
    }
    /**
     * Get PredictionFunction value
     * @return string|null
     */
    public function getPredictionFunction()
    {
        return $this->PredictionFunction;
    }
    /**
     * Set PredictionFunction value
     * @param string $predictionFunction
     * @return \StructType\ServiceRequestContextStructure
     */
    public function setPredictionFunction($predictionFunction = null)
    {
        // validation for constraint: string
        if (!is_null($predictionFunction) && !is_string($predictionFunction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($predictionFunction)), __LINE__);
        }
        $this->PredictionFunction = $predictionFunction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRequestContextStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
