<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDeliveryBodyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for SIRI Service Delivery Body..
 * @subpackage Structs
 */
class ServiceDeliveryBodyStructure extends AbstractStructBase
{
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * @var \StructType\ErrorCondition
     */
    public $ErrorCondition;
    /**
     * The MoreData
     * @var bool
     */
    public $MoreData;
    /**
     * The IncludedSituationExchangeDelivery
     * @var \StructType\SituationExchangeDeliveryStructure
     */
    public $IncludedSituationExchangeDelivery;
    /**
     * The ProductionTimetableDelivery
     * @var \StructType\ProductionTimetableDeliveryStructure
     */
    public $ProductionTimetableDelivery;
    /**
     * The EstimatedTimetableDelivery
     * @var \StructType\EstimatedTimetableDeliveryStructure
     */
    public $EstimatedTimetableDelivery;
    /**
     * The StopTimetableDelivery
     * @var \StructType\StopTimetableDeliveryStructure
     */
    public $StopTimetableDelivery;
    /**
     * The StopMonitoringDelivery
     * @var \StructType\StopMonitoringDeliveryStructure
     */
    public $StopMonitoringDelivery;
    /**
     * The VehicleMonitoringDelivery
     * @var \StructType\VehicleMonitoringDeliveryStructure
     */
    public $VehicleMonitoringDelivery;
    /**
     * The ConnectionTimetableDelivery
     * @var \StructType\ConnectionTimetableDeliveryStructure
     */
    public $ConnectionTimetableDelivery;
    /**
     * The ConnectionMonitoringFeederDelivery
     * @var \StructType\ConnectionMonitoringFeederDeliveryStructure
     */
    public $ConnectionMonitoringFeederDelivery;
    /**
     * The ConnectionMonitoringDistributorDelivery
     * @var \StructType\ConnectionMonitoringDistributorDeliveryStructure
     */
    public $ConnectionMonitoringDistributorDelivery;
    /**
     * The GeneralMessageDelivery
     * @var \StructType\GeneralMessageDeliveryStructure
     */
    public $GeneralMessageDelivery;
    /**
     * The FacilityMonitoringDelivery
     * @var \StructType\FacilityMonitoringDeliveryStructure
     */
    public $FacilityMonitoringDelivery;
    /**
     * The SituationExchangeDelivery
     * @var \StructType\SituationExchangeDeliveryStructure
     */
    public $SituationExchangeDelivery;
    /**
     * The srsName
     * Meta informations extracted from the WSDL
     * - documentation: Default gml coordinate format for eny location elements in response; applies if Coordinates element is used to specify points. May be overridden on individual points. | Type for coordinate reference system.
     * @var string
     */
    public $srsName;
    /**
     * Constructor method for ServiceDeliveryBodyStructure
     * @uses ServiceDeliveryBodyStructure::setStatus()
     * @uses ServiceDeliveryBodyStructure::setErrorCondition()
     * @uses ServiceDeliveryBodyStructure::setMoreData()
     * @uses ServiceDeliveryBodyStructure::setIncludedSituationExchangeDelivery()
     * @uses ServiceDeliveryBodyStructure::setProductionTimetableDelivery()
     * @uses ServiceDeliveryBodyStructure::setEstimatedTimetableDelivery()
     * @uses ServiceDeliveryBodyStructure::setStopTimetableDelivery()
     * @uses ServiceDeliveryBodyStructure::setStopMonitoringDelivery()
     * @uses ServiceDeliveryBodyStructure::setVehicleMonitoringDelivery()
     * @uses ServiceDeliveryBodyStructure::setConnectionTimetableDelivery()
     * @uses ServiceDeliveryBodyStructure::setConnectionMonitoringFeederDelivery()
     * @uses ServiceDeliveryBodyStructure::setConnectionMonitoringDistributorDelivery()
     * @uses ServiceDeliveryBodyStructure::setGeneralMessageDelivery()
     * @uses ServiceDeliveryBodyStructure::setFacilityMonitoringDelivery()
     * @uses ServiceDeliveryBodyStructure::setSituationExchangeDelivery()
     * @uses ServiceDeliveryBodyStructure::setSrsName()
     * @param bool $status
     * @param \StructType\ErrorCondition $errorCondition
     * @param bool $moreData
     * @param \StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery
     * @param \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery
     * @param \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery
     * @param \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery
     * @param \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery
     * @param \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery
     * @param \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery
     * @param \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery
     * @param \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery
     * @param \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery
     * @param string $srsName
     */
    public function __construct($status = null, \StructType\ErrorCondition $errorCondition = null, $moreData = null, \StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery = null, \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery = null, \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery = null, \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery = null, \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery = null, \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery = null, \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery = null, \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery = null, \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery = null, \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery = null, \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery = null, \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery = null, $srsName = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCondition($errorCondition)
            ->setMoreData($moreData)
            ->setIncludedSituationExchangeDelivery($includedSituationExchangeDelivery)
            ->setProductionTimetableDelivery($productionTimetableDelivery)
            ->setEstimatedTimetableDelivery($estimatedTimetableDelivery)
            ->setStopTimetableDelivery($stopTimetableDelivery)
            ->setStopMonitoringDelivery($stopMonitoringDelivery)
            ->setVehicleMonitoringDelivery($vehicleMonitoringDelivery)
            ->setConnectionTimetableDelivery($connectionTimetableDelivery)
            ->setConnectionMonitoringFeederDelivery($connectionMonitoringFeederDelivery)
            ->setConnectionMonitoringDistributorDelivery($connectionMonitoringDistributorDelivery)
            ->setGeneralMessageDelivery($generalMessageDelivery)
            ->setFacilityMonitoringDelivery($facilityMonitoringDelivery)
            ->setSituationExchangeDelivery($situationExchangeDelivery)
            ->setSrsName($srsName);
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ErrorCondition|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ErrorCondition $errorCondition
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setErrorCondition(\StructType\ErrorCondition $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
    /**
     * Get IncludedSituationExchangeDelivery value
     * @return \StructType\SituationExchangeDeliveryStructure|null
     */
    public function getIncludedSituationExchangeDelivery()
    {
        return $this->IncludedSituationExchangeDelivery;
    }
    /**
     * Set IncludedSituationExchangeDelivery value
     * @param \StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setIncludedSituationExchangeDelivery(\StructType\SituationExchangeDeliveryStructure $includedSituationExchangeDelivery = null)
    {
        $this->IncludedSituationExchangeDelivery = $includedSituationExchangeDelivery;
        return $this;
    }
    /**
     * Get ProductionTimetableDelivery value
     * @return \StructType\ProductionTimetableDeliveryStructure|null
     */
    public function getProductionTimetableDelivery()
    {
        return $this->ProductionTimetableDelivery;
    }
    /**
     * Set ProductionTimetableDelivery value
     * @param \StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setProductionTimetableDelivery(\StructType\ProductionTimetableDeliveryStructure $productionTimetableDelivery = null)
    {
        $this->ProductionTimetableDelivery = $productionTimetableDelivery;
        return $this;
    }
    /**
     * Get EstimatedTimetableDelivery value
     * @return \StructType\EstimatedTimetableDeliveryStructure|null
     */
    public function getEstimatedTimetableDelivery()
    {
        return $this->EstimatedTimetableDelivery;
    }
    /**
     * Set EstimatedTimetableDelivery value
     * @param \StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setEstimatedTimetableDelivery(\StructType\EstimatedTimetableDeliveryStructure $estimatedTimetableDelivery = null)
    {
        $this->EstimatedTimetableDelivery = $estimatedTimetableDelivery;
        return $this;
    }
    /**
     * Get StopTimetableDelivery value
     * @return \StructType\StopTimetableDeliveryStructure|null
     */
    public function getStopTimetableDelivery()
    {
        return $this->StopTimetableDelivery;
    }
    /**
     * Set StopTimetableDelivery value
     * @param \StructType\StopTimetableDeliveryStructure $stopTimetableDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setStopTimetableDelivery(\StructType\StopTimetableDeliveryStructure $stopTimetableDelivery = null)
    {
        $this->StopTimetableDelivery = $stopTimetableDelivery;
        return $this;
    }
    /**
     * Get StopMonitoringDelivery value
     * @return \StructType\StopMonitoringDeliveryStructure|null
     */
    public function getStopMonitoringDelivery()
    {
        return $this->StopMonitoringDelivery;
    }
    /**
     * Set StopMonitoringDelivery value
     * @param \StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setStopMonitoringDelivery(\StructType\StopMonitoringDeliveryStructure $stopMonitoringDelivery = null)
    {
        $this->StopMonitoringDelivery = $stopMonitoringDelivery;
        return $this;
    }
    /**
     * Get VehicleMonitoringDelivery value
     * @return \StructType\VehicleMonitoringDeliveryStructure|null
     */
    public function getVehicleMonitoringDelivery()
    {
        return $this->VehicleMonitoringDelivery;
    }
    /**
     * Set VehicleMonitoringDelivery value
     * @param \StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setVehicleMonitoringDelivery(\StructType\VehicleMonitoringDeliveryStructure $vehicleMonitoringDelivery = null)
    {
        $this->VehicleMonitoringDelivery = $vehicleMonitoringDelivery;
        return $this;
    }
    /**
     * Get ConnectionTimetableDelivery value
     * @return \StructType\ConnectionTimetableDeliveryStructure|null
     */
    public function getConnectionTimetableDelivery()
    {
        return $this->ConnectionTimetableDelivery;
    }
    /**
     * Set ConnectionTimetableDelivery value
     * @param \StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setConnectionTimetableDelivery(\StructType\ConnectionTimetableDeliveryStructure $connectionTimetableDelivery = null)
    {
        $this->ConnectionTimetableDelivery = $connectionTimetableDelivery;
        return $this;
    }
    /**
     * Get ConnectionMonitoringFeederDelivery value
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure|null
     */
    public function getConnectionMonitoringFeederDelivery()
    {
        return $this->ConnectionMonitoringFeederDelivery;
    }
    /**
     * Set ConnectionMonitoringFeederDelivery value
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setConnectionMonitoringFeederDelivery(\StructType\ConnectionMonitoringFeederDeliveryStructure $connectionMonitoringFeederDelivery = null)
    {
        $this->ConnectionMonitoringFeederDelivery = $connectionMonitoringFeederDelivery;
        return $this;
    }
    /**
     * Get ConnectionMonitoringDistributorDelivery value
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure|null
     */
    public function getConnectionMonitoringDistributorDelivery()
    {
        return $this->ConnectionMonitoringDistributorDelivery;
    }
    /**
     * Set ConnectionMonitoringDistributorDelivery value
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setConnectionMonitoringDistributorDelivery(\StructType\ConnectionMonitoringDistributorDeliveryStructure $connectionMonitoringDistributorDelivery = null)
    {
        $this->ConnectionMonitoringDistributorDelivery = $connectionMonitoringDistributorDelivery;
        return $this;
    }
    /**
     * Get GeneralMessageDelivery value
     * @return \StructType\GeneralMessageDeliveryStructure|null
     */
    public function getGeneralMessageDelivery()
    {
        return $this->GeneralMessageDelivery;
    }
    /**
     * Set GeneralMessageDelivery value
     * @param \StructType\GeneralMessageDeliveryStructure $generalMessageDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setGeneralMessageDelivery(\StructType\GeneralMessageDeliveryStructure $generalMessageDelivery = null)
    {
        $this->GeneralMessageDelivery = $generalMessageDelivery;
        return $this;
    }
    /**
     * Get FacilityMonitoringDelivery value
     * @return \StructType\FacilityMonitoringDeliveryStructure|null
     */
    public function getFacilityMonitoringDelivery()
    {
        return $this->FacilityMonitoringDelivery;
    }
    /**
     * Set FacilityMonitoringDelivery value
     * @param \StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setFacilityMonitoringDelivery(\StructType\FacilityMonitoringDeliveryStructure $facilityMonitoringDelivery = null)
    {
        $this->FacilityMonitoringDelivery = $facilityMonitoringDelivery;
        return $this;
    }
    /**
     * Get SituationExchangeDelivery value
     * @return \StructType\SituationExchangeDeliveryStructure|null
     */
    public function getSituationExchangeDelivery()
    {
        return $this->SituationExchangeDelivery;
    }
    /**
     * Set SituationExchangeDelivery value
     * @param \StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setSituationExchangeDelivery(\StructType\SituationExchangeDeliveryStructure $situationExchangeDelivery = null)
    {
        $this->SituationExchangeDelivery = $situationExchangeDelivery;
        return $this;
    }
    /**
     * Get srsName value
     * @return string|null
     */
    public function getSrsName()
    {
        return $this->srsName;
    }
    /**
     * Set srsName value
     * @param string $srsName
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public function setSrsName($srsName = null)
    {
        // validation for constraint: string
        if (!is_null($srsName) && !is_string($srsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srsName)), __LINE__);
        }
        $this->srsName = $srsName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceDeliveryBodyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
