<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Roadworks StructType
 * @subpackage Structs
 */
abstract class Roadworks extends OperatorAction
{
    /**
     * The roadworksDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roadworksDuration;
    /**
     * The roadworksScale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roadworksScale;
    /**
     * The underTraffic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $underTraffic;
    /**
     * The urgentRoadworks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $urgentRoadworks;
    /**
     * The mobility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mobility
     */
    public $mobility;
    /**
     * The subjects
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subjects
     */
    public $subjects;
    /**
     * The maintenanceVehicles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaintenanceVehicles
     */
    public $maintenanceVehicles;
    /**
     * The roadworksExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadworksExtension;
    /**
     * Constructor method for Roadworks
     * @uses Roadworks::setRoadworksDuration()
     * @uses Roadworks::setRoadworksScale()
     * @uses Roadworks::setUnderTraffic()
     * @uses Roadworks::setUrgentRoadworks()
     * @uses Roadworks::setMobility()
     * @uses Roadworks::setSubjects()
     * @uses Roadworks::setMaintenanceVehicles()
     * @uses Roadworks::setRoadworksExtension()
     * @param string $roadworksDuration
     * @param string $roadworksScale
     * @param bool $underTraffic
     * @param bool $urgentRoadworks
     * @param \StructType\Mobility $mobility
     * @param \StructType\Subjects $subjects
     * @param \StructType\MaintenanceVehicles $maintenanceVehicles
     * @param \StructType\ExtensionType $roadworksExtension
     */
    public function __construct($roadworksDuration = null, $roadworksScale = null, $underTraffic = null, $urgentRoadworks = null, \StructType\Mobility $mobility = null, \StructType\Subjects $subjects = null, \StructType\MaintenanceVehicles $maintenanceVehicles = null, \StructType\ExtensionType $roadworksExtension = null)
    {
        $this
            ->setRoadworksDuration($roadworksDuration)
            ->setRoadworksScale($roadworksScale)
            ->setUnderTraffic($underTraffic)
            ->setUrgentRoadworks($urgentRoadworks)
            ->setMobility($mobility)
            ->setSubjects($subjects)
            ->setMaintenanceVehicles($maintenanceVehicles)
            ->setRoadworksExtension($roadworksExtension);
    }
    /**
     * Get roadworksDuration value
     * @return string|null
     */
    public function getRoadworksDuration()
    {
        return $this->roadworksDuration;
    }
    /**
     * Set roadworksDuration value
     * @uses \EnumType\RoadworksDurationEnum::valueIsValid()
     * @uses \EnumType\RoadworksDurationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadworksDuration
     * @return \StructType\Roadworks
     */
    public function setRoadworksDuration($roadworksDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadworksDurationEnum::valueIsValid($roadworksDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadworksDuration, implode(', ', \EnumType\RoadworksDurationEnum::getValidValues())), __LINE__);
        }
        $this->roadworksDuration = $roadworksDuration;
        return $this;
    }
    /**
     * Get roadworksScale value
     * @return string|null
     */
    public function getRoadworksScale()
    {
        return $this->roadworksScale;
    }
    /**
     * Set roadworksScale value
     * @uses \EnumType\RoadworksScaleEnum::valueIsValid()
     * @uses \EnumType\RoadworksScaleEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadworksScale
     * @return \StructType\Roadworks
     */
    public function setRoadworksScale($roadworksScale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadworksScaleEnum::valueIsValid($roadworksScale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadworksScale, implode(', ', \EnumType\RoadworksScaleEnum::getValidValues())), __LINE__);
        }
        $this->roadworksScale = $roadworksScale;
        return $this;
    }
    /**
     * Get underTraffic value
     * @return bool|null
     */
    public function getUnderTraffic()
    {
        return $this->underTraffic;
    }
    /**
     * Set underTraffic value
     * @param bool $underTraffic
     * @return \StructType\Roadworks
     */
    public function setUnderTraffic($underTraffic = null)
    {
        // validation for constraint: boolean
        if (!is_null($underTraffic) && !is_bool($underTraffic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($underTraffic)), __LINE__);
        }
        $this->underTraffic = $underTraffic;
        return $this;
    }
    /**
     * Get urgentRoadworks value
     * @return bool|null
     */
    public function getUrgentRoadworks()
    {
        return $this->urgentRoadworks;
    }
    /**
     * Set urgentRoadworks value
     * @param bool $urgentRoadworks
     * @return \StructType\Roadworks
     */
    public function setUrgentRoadworks($urgentRoadworks = null)
    {
        // validation for constraint: boolean
        if (!is_null($urgentRoadworks) && !is_bool($urgentRoadworks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($urgentRoadworks)), __LINE__);
        }
        $this->urgentRoadworks = $urgentRoadworks;
        return $this;
    }
    /**
     * Get mobility value
     * @return \StructType\Mobility|null
     */
    public function getMobility()
    {
        return $this->mobility;
    }
    /**
     * Set mobility value
     * @param \StructType\Mobility $mobility
     * @return \StructType\Roadworks
     */
    public function setMobility(\StructType\Mobility $mobility = null)
    {
        $this->mobility = $mobility;
        return $this;
    }
    /**
     * Get subjects value
     * @return \StructType\Subjects|null
     */
    public function getSubjects()
    {
        return $this->subjects;
    }
    /**
     * Set subjects value
     * @param \StructType\Subjects $subjects
     * @return \StructType\Roadworks
     */
    public function setSubjects(\StructType\Subjects $subjects = null)
    {
        $this->subjects = $subjects;
        return $this;
    }
    /**
     * Get maintenanceVehicles value
     * @return \StructType\MaintenanceVehicles|null
     */
    public function getMaintenanceVehicles()
    {
        return $this->maintenanceVehicles;
    }
    /**
     * Set maintenanceVehicles value
     * @param \StructType\MaintenanceVehicles $maintenanceVehicles
     * @return \StructType\Roadworks
     */
    public function setMaintenanceVehicles(\StructType\MaintenanceVehicles $maintenanceVehicles = null)
    {
        $this->maintenanceVehicles = $maintenanceVehicles;
        return $this;
    }
    /**
     * Get roadworksExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadworksExtension()
    {
        return $this->roadworksExtension;
    }
    /**
     * Set roadworksExtension value
     * @param \StructType\ExtensionType $roadworksExtension
     * @return \StructType\Roadworks
     */
    public function setRoadworksExtension(\StructType\ExtensionType $roadworksExtension = null)
    {
        $this->roadworksExtension = $roadworksExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Roadworks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
