<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseEndpointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unique reference to reponse. May be used to reference request in subsequent interactions. Used for WSDL . | If request has been proxied by an intermediate aggregating system , tracking information relating to the original
 * requestor. This allows the aggregation to be stateless. +SIRI 2.0
 * @subpackage Structs
 */
class ResponseEndpointStructure extends ResponseStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The ResponderRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ResponderRef;
    /**
     * The RequestMessageRef
     * @var \StructType\MessageQualifierStructure
     */
    public $RequestMessageRef;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ResponseEndpointStructure
     * @uses ResponseEndpointStructure::setAddress()
     * @uses ResponseEndpointStructure::setResponderRef()
     * @uses ResponseEndpointStructure::setRequestMessageRef()
     * @uses ResponseEndpointStructure::setDelegatorAddress()
     * @uses ResponseEndpointStructure::setDelegatorRef()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $responderRef
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $responderRef = null, \StructType\MessageQualifierStructure $requestMessageRef = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setAddress($address)
            ->setResponderRef($responderRef)
            ->setRequestMessageRef($requestMessageRef)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ResponseEndpointStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ResponderRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getResponderRef()
    {
        return $this->ResponderRef;
    }
    /**
     * Set ResponderRef value
     * @param \StructType\ParticipantRefStructure $responderRef
     * @return \StructType\ResponseEndpointStructure
     */
    public function setResponderRef(\StructType\ParticipantRefStructure $responderRef = null)
    {
        $this->ResponderRef = $responderRef;
        return $this;
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @return \StructType\ResponseEndpointStructure
     */
    public function setRequestMessageRef(\StructType\MessageQualifierStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ResponseEndpointStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ResponseEndpointStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseEndpointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
