<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemedyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Description of the remedy to the change of a facility status (mainly when it becomes partially or totally anavailable)
 * @subpackage Structs
 */
class RemedyStructure extends AbstractStructBase
{
    /**
     * The RemedyType
     * Meta informations extracted from the WSDL
     * - documentation: Type of the remedy (repair/replacement/remove)
     * - minOccurs: 0
     * @var string
     */
    public $RemedyType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Description of the set up remedy in natural language. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Description;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for RemedyStructure
     * @uses RemedyStructure::setRemedyType()
     * @uses RemedyStructure::setDescription()
     * @uses RemedyStructure::setExtensions()
     * @param string $remedyType
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($remedyType = null, array $description = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setRemedyType($remedyType)
            ->setDescription($description)
            ->setExtensions($extensions);
    }
    /**
     * Get RemedyType value
     * @return string|null
     */
    public function getRemedyType()
    {
        return $this->RemedyType;
    }
    /**
     * Set RemedyType value
     * @uses \EnumType\RemedyTypeEnumeration::valueIsValid()
     * @uses \EnumType\RemedyTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remedyType
     * @return \StructType\RemedyStructure
     */
    public function setRemedyType($remedyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RemedyTypeEnumeration::valueIsValid($remedyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remedyType, implode(', ', \EnumType\RemedyTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->RemedyType = $remedyType;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $description
     * @return \StructType\RemedyStructure
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $remedyStructureDescriptionItem) {
            // validation for constraint: itemType
            if (!$remedyStructureDescriptionItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($remedyStructureDescriptionItem) ? get_class($remedyStructureDescriptionItem) : gettype($remedyStructureDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\RemedyStructure
     */
    public function addToDescription(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\RemedyStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemedyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
