<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedSituationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a reference. | Elements identifying a SITUATION element or an update to a SITUATION. Participant reference is optional and may be supplied from context.
 * @subpackage Structs
 */
class RelatedSituationStructure extends AbstractStructBase
{
    /**
     * The CreationTime
     * Meta informations extracted from the WSDL
     * - documentation: Time of creation of 'related to' assocation.
     * @var string
     */
    public $CreationTime;
    /**
     * The CountryRef
     * @var \StructType\CountryRefStructure
     */
    public $CountryRef;
    /**
     * The ParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * The SituationNumber
     * @var \StructType\EntryQualifierStructure
     */
    public $SituationNumber;
    /**
     * The UpdateCountryRef
     * @var \StructType\CountryRefStructure
     */
    public $UpdateCountryRef;
    /**
     * The UpdateParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $UpdateParticipantRef;
    /**
     * The Version
     * @var \StructType\SituationVersion
     */
    public $Version;
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - documentation: A single string that identifiers the referenced SITUATION.
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The RelatedAs
     * Meta informations extracted from the WSDL
     * - documentation: Relationship of refercence to the referncing SITUATION e.
     * - minOccurs: 0
     * @var string
     */
    public $RelatedAs;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for RelatedSituationStructure
     * @uses RelatedSituationStructure::setCreationTime()
     * @uses RelatedSituationStructure::setCountryRef()
     * @uses RelatedSituationStructure::setParticipantRef()
     * @uses RelatedSituationStructure::setSituationNumber()
     * @uses RelatedSituationStructure::setUpdateCountryRef()
     * @uses RelatedSituationStructure::setUpdateParticipantRef()
     * @uses RelatedSituationStructure::setVersion()
     * @uses RelatedSituationStructure::setExternalReference()
     * @uses RelatedSituationStructure::setRelatedAs()
     * @uses RelatedSituationStructure::setExtensions()
     * @param string $creationTime
     * @param \StructType\CountryRefStructure $countryRef
     * @param \StructType\ParticipantRefStructure $participantRef
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @param \StructType\SituationVersion $version
     * @param string $externalReference
     * @param string $relatedAs
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($creationTime = null, \StructType\CountryRefStructure $countryRef = null, \StructType\ParticipantRefStructure $participantRef = null, \StructType\EntryQualifierStructure $situationNumber = null, \StructType\CountryRefStructure $updateCountryRef = null, \StructType\ParticipantRefStructure $updateParticipantRef = null, \StructType\SituationVersion $version = null, $externalReference = null, $relatedAs = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setCreationTime($creationTime)
            ->setCountryRef($countryRef)
            ->setParticipantRef($participantRef)
            ->setSituationNumber($situationNumber)
            ->setUpdateCountryRef($updateCountryRef)
            ->setUpdateParticipantRef($updateParticipantRef)
            ->setVersion($version)
            ->setExternalReference($externalReference)
            ->setRelatedAs($relatedAs)
            ->setExtensions($extensions);
    }
    /**
     * Get CreationTime value
     * @return string|null
     */
    public function getCreationTime()
    {
        return $this->CreationTime;
    }
    /**
     * Set CreationTime value
     * @param string $creationTime
     * @return \StructType\RelatedSituationStructure
     */
    public function setCreationTime($creationTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationTime) && !is_string($creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationTime)), __LINE__);
        }
        $this->CreationTime = $creationTime;
        return $this;
    }
    /**
     * Get CountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getCountryRef()
    {
        return $this->CountryRef;
    }
    /**
     * Set CountryRef value
     * @param \StructType\CountryRefStructure $countryRef
     * @return \StructType\RelatedSituationStructure
     */
    public function setCountryRef(\StructType\CountryRefStructure $countryRef = null)
    {
        $this->CountryRef = $countryRef;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\RelatedSituationStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Get SituationNumber value
     * @return \StructType\EntryQualifierStructure|null
     */
    public function getSituationNumber()
    {
        return $this->SituationNumber;
    }
    /**
     * Set SituationNumber value
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @return \StructType\RelatedSituationStructure
     */
    public function setSituationNumber(\StructType\EntryQualifierStructure $situationNumber = null)
    {
        $this->SituationNumber = $situationNumber;
        return $this;
    }
    /**
     * Get UpdateCountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getUpdateCountryRef()
    {
        return $this->UpdateCountryRef;
    }
    /**
     * Set UpdateCountryRef value
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @return \StructType\RelatedSituationStructure
     */
    public function setUpdateCountryRef(\StructType\CountryRefStructure $updateCountryRef = null)
    {
        $this->UpdateCountryRef = $updateCountryRef;
        return $this;
    }
    /**
     * Get UpdateParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getUpdateParticipantRef()
    {
        return $this->UpdateParticipantRef;
    }
    /**
     * Set UpdateParticipantRef value
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @return \StructType\RelatedSituationStructure
     */
    public function setUpdateParticipantRef(\StructType\ParticipantRefStructure $updateParticipantRef = null)
    {
        $this->UpdateParticipantRef = $updateParticipantRef;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\SituationVersion|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\SituationVersion $version
     * @return \StructType\RelatedSituationStructure
     */
    public function setVersion(\StructType\SituationVersion $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\RelatedSituationStructure
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get RelatedAs value
     * @return string|null
     */
    public function getRelatedAs()
    {
        return $this->RelatedAs;
    }
    /**
     * Set RelatedAs value
     * @uses \EnumType\RelatedToEnumeration::valueIsValid()
     * @uses \EnumType\RelatedToEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relatedAs
     * @return \StructType\RelatedSituationStructure
     */
    public function setRelatedAs($relatedAs = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RelatedToEnumeration::valueIsValid($relatedAs)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $relatedAs, implode(', ', \EnumType\RelatedToEnumeration::getValidValues())), __LINE__);
        }
        $this->RelatedAs = $relatedAs;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\RelatedSituationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatedSituationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
