<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishToWebActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Action Publish SITUATION To Web.
 * @subpackage Structs
 */
class PublishToWebActionStructure extends ParameterisedActionStructure
{
    /**
     * The Incidents
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Include in SITUATION lists on web site. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $Incidents;
    /**
     * The HomePage
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Include on home page on web site. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $HomePage;
    /**
     * The Ticker
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Include in moving ticker band. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $Ticker;
    /**
     * The SocialNetwork
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Include in social NETWORK indicated by this name. Possible value could be "twitter.com", "facebook.com", "vk.com" and so on. Parameters may be specifed as Action data. (SIRIv 2.10)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SocialNetwork;
    /**
     * Constructor method for PublishToWebActionStructure
     * @uses PublishToWebActionStructure::setIncidents()
     * @uses PublishToWebActionStructure::setHomePage()
     * @uses PublishToWebActionStructure::setTicker()
     * @uses PublishToWebActionStructure::setSocialNetwork()
     * @param bool $incidents
     * @param bool $homePage
     * @param bool $ticker
     * @param string[] $socialNetwork
     */
    public function __construct($incidents = true, $homePage = false, $ticker = false, array $socialNetwork = array())
    {
        $this
            ->setIncidents($incidents)
            ->setHomePage($homePage)
            ->setTicker($ticker)
            ->setSocialNetwork($socialNetwork);
    }
    /**
     * Get Incidents value
     * @return bool|null
     */
    public function getIncidents()
    {
        return $this->Incidents;
    }
    /**
     * Set Incidents value
     * @param bool $incidents
     * @return \StructType\PublishToWebActionStructure
     */
    public function setIncidents($incidents = true)
    {
        // validation for constraint: boolean
        if (!is_null($incidents) && !is_bool($incidents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incidents)), __LINE__);
        }
        $this->Incidents = $incidents;
        return $this;
    }
    /**
     * Get HomePage value
     * @return bool|null
     */
    public function getHomePage()
    {
        return $this->HomePage;
    }
    /**
     * Set HomePage value
     * @param bool $homePage
     * @return \StructType\PublishToWebActionStructure
     */
    public function setHomePage($homePage = false)
    {
        // validation for constraint: boolean
        if (!is_null($homePage) && !is_bool($homePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($homePage)), __LINE__);
        }
        $this->HomePage = $homePage;
        return $this;
    }
    /**
     * Get Ticker value
     * @return bool|null
     */
    public function getTicker()
    {
        return $this->Ticker;
    }
    /**
     * Set Ticker value
     * @param bool $ticker
     * @return \StructType\PublishToWebActionStructure
     */
    public function setTicker($ticker = false)
    {
        // validation for constraint: boolean
        if (!is_null($ticker) && !is_bool($ticker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ticker)), __LINE__);
        }
        $this->Ticker = $ticker;
        return $this;
    }
    /**
     * Get SocialNetwork value
     * @return string[]|null
     */
    public function getSocialNetwork()
    {
        return $this->SocialNetwork;
    }
    /**
     * Set SocialNetwork value
     * @throws \InvalidArgumentException
     * @param string[] $socialNetwork
     * @return \StructType\PublishToWebActionStructure
     */
    public function setSocialNetwork(array $socialNetwork = array())
    {
        foreach ($socialNetwork as $publishToWebActionStructureSocialNetworkItem) {
            // validation for constraint: itemType
            if (!is_string($publishToWebActionStructureSocialNetworkItem)) {
                throw new \InvalidArgumentException(sprintf('The SocialNetwork property can only contain items of normalizedString, "%s" given', is_object($publishToWebActionStructureSocialNetworkItem) ? get_class($publishToWebActionStructureSocialNetworkItem) : gettype($publishToWebActionStructureSocialNetworkItem)), __LINE__);
            }
        }
        $this->SocialNetwork = $socialNetwork;
        return $this;
    }
    /**
     * Add item to SocialNetwork value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PublishToWebActionStructure
     */
    public function addToSocialNetwork($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SocialNetwork property can only contain items of normalizedString, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SocialNetwork[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublishToWebActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
