<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicEvent StructType
 * @subpackage Structs
 */
class PublicEvent extends Activity
{
    /**
     * The publicEventType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $publicEventType;
    /**
     * The publicEventExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $publicEventExtension;
    /**
     * Constructor method for PublicEvent
     * @uses PublicEvent::setPublicEventType()
     * @uses PublicEvent::setPublicEventExtension()
     * @param string $publicEventType
     * @param \StructType\ExtensionType $publicEventExtension
     */
    public function __construct($publicEventType = null, \StructType\ExtensionType $publicEventExtension = null)
    {
        $this
            ->setPublicEventType($publicEventType)
            ->setPublicEventExtension($publicEventExtension);
    }
    /**
     * Get publicEventType value
     * @return string
     */
    public function getPublicEventType()
    {
        return $this->publicEventType;
    }
    /**
     * Set publicEventType value
     * @uses \EnumType\PublicEventTypeEnum::valueIsValid()
     * @uses \EnumType\PublicEventTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $publicEventType
     * @return \StructType\PublicEvent
     */
    public function setPublicEventType($publicEventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PublicEventTypeEnum::valueIsValid($publicEventType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $publicEventType, implode(', ', \EnumType\PublicEventTypeEnum::getValidValues())), __LINE__);
        }
        $this->publicEventType = $publicEventType;
        return $this;
    }
    /**
     * Get publicEventExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPublicEventExtension()
    {
        return $this->publicEventExtension;
    }
    /**
     * Set publicEventExtension value
     * @param \StructType\ExtensionType $publicEventExtension
     * @return \StructType\PublicEvent
     */
    public function setPublicEventExtension(\StructType\ExtensionType $publicEventExtension = null)
    {
        $this->publicEventExtension = $publicEventExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PublicEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
