<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PtConsequenceStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for disruption.
 * @subpackage Structs
 */
class PtConsequenceStructure extends AbstractStructBase
{
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - documentation: Period of effect of disruption, if different from that of SITUATION.
     * - minOccurs: 0
     * @var \StructType\HalfOpenTimestampOutputRangeStructure
     */
    public $Period;
    /**
     * The Condition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: Condition
     * @var string[]
     */
    public $Condition;
    /**
     * The Severity
     * Meta informations extracted from the WSDL
     * - documentation: Severity of disruption if different from that of SITUATION. TPEG pti26
     * @var string
     */
    public $Severity;
    /**
     * The Affects
     * Meta informations extracted from the WSDL
     * - documentation: Parts of transport network affected by disruption if different from that of SITUATION.
     * - minOccurs: 0
     * @var \StructType\AffectsScopeStructure
     */
    public $Affects;
    /**
     * The Suitabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Suitabilities
     */
    public $Suitabilities;
    /**
     * The Advice
     * Meta informations extracted from the WSDL
     * - documentation: Advice to passengers.
     * - minOccurs: 0
     * @var \StructType\PtAdviceStructure
     */
    public $Advice;
    /**
     * The Blocking
     * Meta informations extracted from the WSDL
     * - documentation: How Disruption should be handled in Info systems.
     * - minOccurs: 0
     * @var \StructType\BlockingStructure
     */
    public $Blocking;
    /**
     * The Boarding
     * Meta informations extracted from the WSDL
     * - documentation: Change to normal boarding activity allowed at stop.
     * - minOccurs: 0
     * @var \StructType\BoardingStructure
     */
    public $Boarding;
    /**
     * The Delays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DelaysStructure
     */
    public $Delays;
    /**
     * The Casualties
     * Meta informations extracted from the WSDL
     * - documentation: Information on casualties.
     * - minOccurs: 0
     * @var \StructType\CasualtiesStructure
     */
    public $Casualties;
    /**
     * The Easements
     * Meta informations extracted from the WSDL
     * - documentation: Description of fare exceptions allowed because of disruption.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EasementsStructure[]
     */
    public $Easements;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for PtConsequenceStructure
     * @uses PtConsequenceStructure::setPeriod()
     * @uses PtConsequenceStructure::setCondition()
     * @uses PtConsequenceStructure::setSeverity()
     * @uses PtConsequenceStructure::setAffects()
     * @uses PtConsequenceStructure::setSuitabilities()
     * @uses PtConsequenceStructure::setAdvice()
     * @uses PtConsequenceStructure::setBlocking()
     * @uses PtConsequenceStructure::setBoarding()
     * @uses PtConsequenceStructure::setDelays()
     * @uses PtConsequenceStructure::setCasualties()
     * @uses PtConsequenceStructure::setEasements()
     * @uses PtConsequenceStructure::setExtensions()
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $period
     * @param string[] $condition
     * @param string $severity
     * @param \StructType\AffectsScopeStructure $affects
     * @param \StructType\Suitabilities $suitabilities
     * @param \StructType\PtAdviceStructure $advice
     * @param \StructType\BlockingStructure $blocking
     * @param \StructType\BoardingStructure $boarding
     * @param \StructType\DelaysStructure $delays
     * @param \StructType\CasualtiesStructure $casualties
     * @param \StructType\EasementsStructure[] $easements
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\HalfOpenTimestampOutputRangeStructure $period = null, array $condition = array(), $severity = null, \StructType\AffectsScopeStructure $affects = null, \StructType\Suitabilities $suitabilities = null, \StructType\PtAdviceStructure $advice = null, \StructType\BlockingStructure $blocking = null, \StructType\BoardingStructure $boarding = null, \StructType\DelaysStructure $delays = null, \StructType\CasualtiesStructure $casualties = null, array $easements = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setPeriod($period)
            ->setCondition($condition)
            ->setSeverity($severity)
            ->setAffects($affects)
            ->setSuitabilities($suitabilities)
            ->setAdvice($advice)
            ->setBlocking($blocking)
            ->setBoarding($boarding)
            ->setDelays($delays)
            ->setCasualties($casualties)
            ->setEasements($easements)
            ->setExtensions($extensions);
    }
    /**
     * Get Period value
     * @return \StructType\HalfOpenTimestampOutputRangeStructure|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \StructType\HalfOpenTimestampOutputRangeStructure $period
     * @return \StructType\PtConsequenceStructure
     */
    public function setPeriod(\StructType\HalfOpenTimestampOutputRangeStructure $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Condition value
     * @return string[]|null
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \EnumType\ServiceConditionEnumeration::valueIsValid()
     * @uses \EnumType\ServiceConditionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $condition
     * @return \StructType\PtConsequenceStructure
     */
    public function setCondition(array $condition = array())
    {
        $invalidValues = array();
        foreach ($condition as $ptConsequenceStructureConditionItem) {
            if (!\EnumType\ServiceConditionEnumeration::valueIsValid($ptConsequenceStructureConditionItem)) {
                $invalidValues[] = var_export($ptConsequenceStructureConditionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ServiceConditionEnumeration::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Add item to Condition value
     * @uses \EnumType\ServiceConditionEnumeration::valueIsValid()
     * @uses \EnumType\ServiceConditionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PtConsequenceStructure
     */
    public function addToCondition($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceConditionEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ServiceConditionEnumeration::getValidValues())), __LINE__);
        }
        $this->Condition[] = $item;
        return $this;
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @uses \EnumType\SeverityEnumeration::valueIsValid()
     * @uses \EnumType\SeverityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\PtConsequenceStructure
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeverityEnumeration::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \EnumType\SeverityEnumeration::getValidValues())), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get Affects value
     * @return \StructType\AffectsScopeStructure|null
     */
    public function getAffects()
    {
        return $this->Affects;
    }
    /**
     * Set Affects value
     * @param \StructType\AffectsScopeStructure $affects
     * @return \StructType\PtConsequenceStructure
     */
    public function setAffects(\StructType\AffectsScopeStructure $affects = null)
    {
        $this->Affects = $affects;
        return $this;
    }
    /**
     * Get Suitabilities value
     * @return \StructType\Suitabilities|null
     */
    public function getSuitabilities()
    {
        return $this->Suitabilities;
    }
    /**
     * Set Suitabilities value
     * @param \StructType\Suitabilities $suitabilities
     * @return \StructType\PtConsequenceStructure
     */
    public function setSuitabilities(\StructType\Suitabilities $suitabilities = null)
    {
        $this->Suitabilities = $suitabilities;
        return $this;
    }
    /**
     * Get Advice value
     * @return \StructType\PtAdviceStructure|null
     */
    public function getAdvice()
    {
        return $this->Advice;
    }
    /**
     * Set Advice value
     * @param \StructType\PtAdviceStructure $advice
     * @return \StructType\PtConsequenceStructure
     */
    public function setAdvice(\StructType\PtAdviceStructure $advice = null)
    {
        $this->Advice = $advice;
        return $this;
    }
    /**
     * Get Blocking value
     * @return \StructType\BlockingStructure|null
     */
    public function getBlocking()
    {
        return $this->Blocking;
    }
    /**
     * Set Blocking value
     * @param \StructType\BlockingStructure $blocking
     * @return \StructType\PtConsequenceStructure
     */
    public function setBlocking(\StructType\BlockingStructure $blocking = null)
    {
        $this->Blocking = $blocking;
        return $this;
    }
    /**
     * Get Boarding value
     * @return \StructType\BoardingStructure|null
     */
    public function getBoarding()
    {
        return $this->Boarding;
    }
    /**
     * Set Boarding value
     * @param \StructType\BoardingStructure $boarding
     * @return \StructType\PtConsequenceStructure
     */
    public function setBoarding(\StructType\BoardingStructure $boarding = null)
    {
        $this->Boarding = $boarding;
        return $this;
    }
    /**
     * Get Delays value
     * @return \StructType\DelaysStructure|null
     */
    public function getDelays()
    {
        return $this->Delays;
    }
    /**
     * Set Delays value
     * @param \StructType\DelaysStructure $delays
     * @return \StructType\PtConsequenceStructure
     */
    public function setDelays(\StructType\DelaysStructure $delays = null)
    {
        $this->Delays = $delays;
        return $this;
    }
    /**
     * Get Casualties value
     * @return \StructType\CasualtiesStructure|null
     */
    public function getCasualties()
    {
        return $this->Casualties;
    }
    /**
     * Set Casualties value
     * @param \StructType\CasualtiesStructure $casualties
     * @return \StructType\PtConsequenceStructure
     */
    public function setCasualties(\StructType\CasualtiesStructure $casualties = null)
    {
        $this->Casualties = $casualties;
        return $this;
    }
    /**
     * Get Easements value
     * @return \StructType\EasementsStructure[]|null
     */
    public function getEasements()
    {
        return $this->Easements;
    }
    /**
     * Set Easements value
     * @throws \InvalidArgumentException
     * @param \StructType\EasementsStructure[] $easements
     * @return \StructType\PtConsequenceStructure
     */
    public function setEasements(array $easements = array())
    {
        foreach ($easements as $ptConsequenceStructureEasementsItem) {
            // validation for constraint: itemType
            if (!$ptConsequenceStructureEasementsItem instanceof \StructType\EasementsStructure) {
                throw new \InvalidArgumentException(sprintf('The Easements property can only contain items of \StructType\EasementsStructure, "%s" given', is_object($ptConsequenceStructureEasementsItem) ? get_class($ptConsequenceStructureEasementsItem) : gettype($ptConsequenceStructureEasementsItem)), __LINE__);
            }
        }
        $this->Easements = $easements;
        return $this;
    }
    /**
     * Add item to Easements value
     * @throws \InvalidArgumentException
     * @param \StructType\EasementsStructure $item
     * @return \StructType\PtConsequenceStructure
     */
    public function addToEasements(\StructType\EasementsStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EasementsStructure) {
            throw new \InvalidArgumentException(sprintf('The Easements property can only contain items of \StructType\EasementsStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Easements[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\PtConsequenceStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PtConsequenceStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
