<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PtAdviceStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for advice.
 * @subpackage Structs
 */
class PtAdviceStructure extends AbstractStructBase
{
    /**
     * The AdviceRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a standardis advisory NOTICE to be given to passengers if a particular condition arises .
     * - minOccurs: 0
     * @var \StructType\AdviceRefStructure
     */
    public $AdviceRef;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - documentation: Further Textual advice to passengers. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Details;
    /**
     * Constructor method for PtAdviceStructure
     * @uses PtAdviceStructure::setAdviceRef()
     * @uses PtAdviceStructure::setDetails()
     * @param \StructType\AdviceRefStructure $adviceRef
     * @param \StructType\NaturalLanguageStringStructure[] $details
     */
    public function __construct(\StructType\AdviceRefStructure $adviceRef = null, array $details = array())
    {
        $this
            ->setAdviceRef($adviceRef)
            ->setDetails($details);
    }
    /**
     * Get AdviceRef value
     * @return \StructType\AdviceRefStructure|null
     */
    public function getAdviceRef()
    {
        return $this->AdviceRef;
    }
    /**
     * Set AdviceRef value
     * @param \StructType\AdviceRefStructure $adviceRef
     * @return \StructType\PtAdviceStructure
     */
    public function setAdviceRef(\StructType\AdviceRefStructure $adviceRef = null)
    {
        $this->AdviceRef = $adviceRef;
        return $this;
    }
    /**
     * Get Details value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $details
     * @return \StructType\PtAdviceStructure
     */
    public function setDetails(array $details = array())
    {
        foreach ($details as $ptAdviceStructureDetailsItem) {
            // validation for constraint: itemType
            if (!$ptAdviceStructureDetailsItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($ptAdviceStructureDetailsItem) ? get_class($ptAdviceStructureDetailsItem) : gettype($ptAdviceStructureDetailsItem)), __LINE__);
            }
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\PtAdviceStructure
     */
    public function addToDetails(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PtAdviceStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
