<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCategoryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for TYPE OF PRODUCT CATEGORY description.
 * @subpackage Structs
 */
class ProductCategoryStructure extends AbstractStructBase
{
    /**
     * The ProductCategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of TYPE OF PRODUCT CATEGORY classification. SIRI provides a recommended set of values covering most usages, intended to be TPEG compatible. See the SIRI facilities packaged. | Type for identifier of a TYPE OF PRODUCT
     * CATEGORY.
     * @var string
     */
    public $ProductCategoryCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of classification (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Name;
    /**
     * The Icon
     * Meta informations extracted from the WSDL
     * - documentation: Icon used to represent TYPE OF PRODUCT CATEGORY.
     * - minOccurs: 0
     * @var string
     */
    public $Icon;
    /**
     * Constructor method for ProductCategoryStructure
     * @uses ProductCategoryStructure::setProductCategoryCode()
     * @uses ProductCategoryStructure::setName()
     * @uses ProductCategoryStructure::setIcon()
     * @param string $productCategoryCode
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @param string $icon
     */
    public function __construct($productCategoryCode = null, array $name = array(), $icon = null)
    {
        $this
            ->setProductCategoryCode($productCategoryCode)
            ->setName($name)
            ->setIcon($icon);
    }
    /**
     * Get ProductCategoryCode value
     * @return string|null
     */
    public function getProductCategoryCode()
    {
        return $this->ProductCategoryCode;
    }
    /**
     * Set ProductCategoryCode value
     * @param string $productCategoryCode
     * @return \StructType\ProductCategoryStructure
     */
    public function setProductCategoryCode($productCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCategoryCode) && !is_string($productCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCategoryCode)), __LINE__);
        }
        $this->ProductCategoryCode = $productCategoryCode;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @return \StructType\ProductCategoryStructure
     */
    public function setName(array $name = array())
    {
        foreach ($name as $productCategoryStructureNameItem) {
            // validation for constraint: itemType
            if (!$productCategoryStructureNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($productCategoryStructureNameItem) ? get_class($productCategoryStructureNameItem) : gettype($productCategoryStructureNameItem)), __LINE__);
            }
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\ProductCategoryStructure
     */
    public function addToName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Name[] = $item;
        return $this;
    }
    /**
     * Get Icon value
     * @return string|null
     */
    public function getIcon()
    {
        return $this->Icon;
    }
    /**
     * Set Icon value
     * @param string $icon
     * @return \StructType\ProductCategoryStructure
     */
    public function setIcon($icon = null)
    {
        // validation for constraint: string
        if (!is_null($icon) && !is_string($icon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icon)), __LINE__);
        }
        $this->Icon = $icon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductCategoryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
