<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCategoriesDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Response with Product Categories available to make requests.
 * @subpackage Structs
 */
class ProductCategoriesDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The ProductCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ProductCategory
     * @var \StructType\ProductCategoryStructure[]
     */
    public $ProductCategory;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ProductCategoriesDeliveryStructure
     * @uses ProductCategoriesDeliveryStructure::setProductCategory()
     * @uses ProductCategoriesDeliveryStructure::setExtensions()
     * @uses ProductCategoriesDeliveryStructure::setVersion()
     * @param \StructType\ProductCategoryStructure[] $productCategory
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $productCategory = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setProductCategory($productCategory)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get ProductCategory value
     * @return \StructType\ProductCategoryStructure[]|null
     */
    public function getProductCategory()
    {
        return $this->ProductCategory;
    }
    /**
     * Set ProductCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCategoryStructure[] $productCategory
     * @return \StructType\ProductCategoriesDeliveryStructure
     */
    public function setProductCategory(array $productCategory = array())
    {
        foreach ($productCategory as $productCategoriesDeliveryStructureProductCategoryItem) {
            // validation for constraint: itemType
            if (!$productCategoriesDeliveryStructureProductCategoryItem instanceof \StructType\ProductCategoryStructure) {
                throw new \InvalidArgumentException(sprintf('The ProductCategory property can only contain items of \StructType\ProductCategoryStructure, "%s" given', is_object($productCategoriesDeliveryStructureProductCategoryItem) ? get_class($productCategoriesDeliveryStructureProductCategoryItem) : gettype($productCategoriesDeliveryStructureProductCategoryItem)), __LINE__);
            }
        }
        $this->ProductCategory = $productCategory;
        return $this;
    }
    /**
     * Add item to ProductCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCategoryStructure $item
     * @return \StructType\ProductCategoriesDeliveryStructure
     */
    public function addToProductCategory(\StructType\ProductCategoryStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductCategoryStructure) {
            throw new \InvalidArgumentException(sprintf('The ProductCategory property can only contain items of \StructType\ProductCategoryStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductCategory[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ProductCategoriesDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ProductCategoriesDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductCategoriesDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
