<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProducerResponseEndpointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unique reference to reponse from producer. May be used to reference request in subsequent interactions. Used for WSDL.
 * @subpackage Structs
 */
class ProducerResponseEndpointStructure extends ResponseStructure
{
    /**
     * The ProducerRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ProducerRef;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The ResponseMessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $ResponseMessageIdentifier;
    /**
     * The RequestMessageRef
     * @var \StructType\MessageRefStructure
     */
    public $RequestMessageRef;
    /**
     * Constructor method for ProducerResponseEndpointStructure
     * @uses ProducerResponseEndpointStructure::setProducerRef()
     * @uses ProducerResponseEndpointStructure::setAddress()
     * @uses ProducerResponseEndpointStructure::setResponseMessageIdentifier()
     * @uses ProducerResponseEndpointStructure::setRequestMessageRef()
     * @param \StructType\ParticipantRefStructure $producerRef
     * @param string $address
     * @param \StructType\MessageQualifierStructure $responseMessageIdentifier
     * @param \StructType\MessageRefStructure $requestMessageRef
     */
    public function __construct(\StructType\ParticipantRefStructure $producerRef = null, $address = null, \StructType\MessageQualifierStructure $responseMessageIdentifier = null, \StructType\MessageRefStructure $requestMessageRef = null)
    {
        $this
            ->setProducerRef($producerRef)
            ->setAddress($address)
            ->setResponseMessageIdentifier($responseMessageIdentifier)
            ->setRequestMessageRef($requestMessageRef);
    }
    /**
     * Get ProducerRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getProducerRef()
    {
        return $this->ProducerRef;
    }
    /**
     * Set ProducerRef value
     * @param \StructType\ParticipantRefStructure $producerRef
     * @return \StructType\ProducerResponseEndpointStructure
     */
    public function setProducerRef(\StructType\ParticipantRefStructure $producerRef = null)
    {
        $this->ProducerRef = $producerRef;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ProducerResponseEndpointStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ResponseMessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getResponseMessageIdentifier()
    {
        return $this->ResponseMessageIdentifier;
    }
    /**
     * Set ResponseMessageIdentifier value
     * @param \StructType\MessageQualifierStructure $responseMessageIdentifier
     * @return \StructType\ProducerResponseEndpointStructure
     */
    public function setResponseMessageIdentifier(\StructType\MessageQualifierStructure $responseMessageIdentifier = null)
    {
        $this->ResponseMessageIdentifier = $responseMessageIdentifier;
        return $this;
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageRefStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageRefStructure $requestMessageRef
     * @return \StructType\ProducerResponseEndpointStructure
     */
    public function setRequestMessageRef(\StructType\MessageRefStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProducerResponseEndpointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
