<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PredefinedLocationSet StructType
 * @subpackage Structs
 */
class PredefinedLocationSet extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The predefinedLocationSetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $predefinedLocationSetName;
    /**
     * The predefinedLocationSetVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $predefinedLocationSetVersion;
    /**
     * The predefinedLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PredefinedLocation[]
     */
    public $predefinedLocation;
    /**
     * The predefinedLocationSetExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $predefinedLocationSetExtension;
    /**
     * Constructor method for PredefinedLocationSet
     * @uses PredefinedLocationSet::setId()
     * @uses PredefinedLocationSet::setPredefinedLocationSetName()
     * @uses PredefinedLocationSet::setPredefinedLocationSetVersion()
     * @uses PredefinedLocationSet::setPredefinedLocation()
     * @uses PredefinedLocationSet::setPredefinedLocationSetExtension()
     * @param string $id
     * @param \StructType\MultilingualString $predefinedLocationSetName
     * @param int $predefinedLocationSetVersion
     * @param \StructType\PredefinedLocation[] $predefinedLocation
     * @param \StructType\ExtensionType $predefinedLocationSetExtension
     */
    public function __construct($id = null, \StructType\MultilingualString $predefinedLocationSetName = null, $predefinedLocationSetVersion = null, array $predefinedLocation = array(), \StructType\ExtensionType $predefinedLocationSetExtension = null)
    {
        $this
            ->setId($id)
            ->setPredefinedLocationSetName($predefinedLocationSetName)
            ->setPredefinedLocationSetVersion($predefinedLocationSetVersion)
            ->setPredefinedLocation($predefinedLocation)
            ->setPredefinedLocationSetExtension($predefinedLocationSetExtension);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PredefinedLocationSet
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id_1) && !is_string($id_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id_1)), __LINE__);
        }
        $this->id = $id_1;
        return $this;
    }
    /**
     * Get predefinedLocationSetName value
     * @return \StructType\MultilingualString|null
     */
    public function getPredefinedLocationSetName()
    {
        return $this->predefinedLocationSetName;
    }
    /**
     * Set predefinedLocationSetName value
     * @param \StructType\MultilingualString $predefinedLocationSetName
     * @return \StructType\PredefinedLocationSet
     */
    public function setPredefinedLocationSetName(\StructType\MultilingualString $predefinedLocationSetName = null)
    {
        $this->predefinedLocationSetName = $predefinedLocationSetName;
        return $this;
    }
    /**
     * Get predefinedLocationSetVersion value
     * @return int|null
     */
    public function getPredefinedLocationSetVersion()
    {
        return $this->predefinedLocationSetVersion;
    }
    /**
     * Set predefinedLocationSetVersion value
     * @param int $predefinedLocationSetVersion
     * @return \StructType\PredefinedLocationSet
     */
    public function setPredefinedLocationSetVersion($predefinedLocationSetVersion = null)
    {
        // validation for constraint: int
        if (!is_null($predefinedLocationSetVersion) && !is_numeric($predefinedLocationSetVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($predefinedLocationSetVersion)), __LINE__);
        }
        $this->predefinedLocationSetVersion = $predefinedLocationSetVersion;
        return $this;
    }
    /**
     * Get predefinedLocation value
     * @return \StructType\PredefinedLocation[]|null
     */
    public function getPredefinedLocation()
    {
        return $this->predefinedLocation;
    }
    /**
     * Set predefinedLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\PredefinedLocation[] $predefinedLocation
     * @return \StructType\PredefinedLocationSet
     */
    public function setPredefinedLocation(array $predefinedLocation = array())
    {
        foreach ($predefinedLocation_1 as $predefinedLocationSetPredefinedLocationItem) {
            // validation for constraint: itemType
            if (!$predefinedLocationSetPredefinedLocationItem instanceof \StructType\PredefinedLocation) {
                throw new \InvalidArgumentException(sprintf('The predefinedLocation property can only contain items of \StructType\PredefinedLocation, "%s" given', is_object($predefinedLocationSetPredefinedLocationItem) ? get_class($predefinedLocationSetPredefinedLocationItem) : gettype($predefinedLocationSetPredefinedLocationItem)), __LINE__);
            }
        }
        $this->predefinedLocation = $predefinedLocation_1;
        return $this;
    }
    /**
     * Add item to predefinedLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\PredefinedLocation $item
     * @return \StructType\PredefinedLocationSet
     */
    public function addToPredefinedLocation(\StructType\PredefinedLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PredefinedLocation) {
            throw new \InvalidArgumentException(sprintf('The predefinedLocation property can only contain items of \StructType\PredefinedLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->predefinedLocation[] = $item;
        return $this;
    }
    /**
     * Get predefinedLocationSetExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPredefinedLocationSetExtension()
    {
        return $this->predefinedLocationSetExtension;
    }
    /**
     * Set predefinedLocationSetExtension value
     * @param \StructType\ExtensionType $predefinedLocationSetExtension
     * @return \StructType\PredefinedLocationSet
     */
    public function setPredefinedLocationSetExtension(\StructType\ExtensionType $predefinedLocationSetExtension = null)
    {
        $this->predefinedLocationSetExtension = $predefinedLocationSetExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PredefinedLocationSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
