<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrecipitationDetail StructType
 * @subpackage Structs
 */
class PrecipitationDetail extends AbstractStructBase
{
    /**
     * The depositionDepth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $depositionDepth;
    /**
     * The precipitationIntensity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $precipitationIntensity;
    /**
     * The precipitationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $precipitationType;
    /**
     * The precipitationDetailExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $precipitationDetailExtension;
    /**
     * Constructor method for PrecipitationDetail
     * @uses PrecipitationDetail::setDepositionDepth()
     * @uses PrecipitationDetail::setPrecipitationIntensity()
     * @uses PrecipitationDetail::setPrecipitationType()
     * @uses PrecipitationDetail::setPrecipitationDetailExtension()
     * @param float $depositionDepth
     * @param float $precipitationIntensity
     * @param string $precipitationType
     * @param \StructType\ExtensionType $precipitationDetailExtension
     */
    public function __construct($depositionDepth = null, $precipitationIntensity = null, $precipitationType = null, \StructType\ExtensionType $precipitationDetailExtension = null)
    {
        $this
            ->setDepositionDepth($depositionDepth)
            ->setPrecipitationIntensity($precipitationIntensity)
            ->setPrecipitationType($precipitationType)
            ->setPrecipitationDetailExtension($precipitationDetailExtension);
    }
    /**
     * Get depositionDepth value
     * @return float|null
     */
    public function getDepositionDepth()
    {
        return $this->depositionDepth;
    }
    /**
     * Set depositionDepth value
     * @param float $depositionDepth
     * @return \StructType\PrecipitationDetail
     */
    public function setDepositionDepth($depositionDepth = null)
    {
        $this->depositionDepth = $depositionDepth;
        return $this;
    }
    /**
     * Get precipitationIntensity value
     * @return float|null
     */
    public function getPrecipitationIntensity()
    {
        return $this->precipitationIntensity;
    }
    /**
     * Set precipitationIntensity value
     * @param float $precipitationIntensity
     * @return \StructType\PrecipitationDetail
     */
    public function setPrecipitationIntensity($precipitationIntensity = null)
    {
        $this->precipitationIntensity = $precipitationIntensity;
        return $this;
    }
    /**
     * Get precipitationType value
     * @return string|null
     */
    public function getPrecipitationType()
    {
        return $this->precipitationType;
    }
    /**
     * Set precipitationType value
     * @uses \EnumType\PrecipitationTypeEnum::valueIsValid()
     * @uses \EnumType\PrecipitationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $precipitationType
     * @return \StructType\PrecipitationDetail
     */
    public function setPrecipitationType($precipitationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrecipitationTypeEnum::valueIsValid($precipitationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $precipitationType, implode(', ', \EnumType\PrecipitationTypeEnum::getValidValues())), __LINE__);
        }
        $this->precipitationType = $precipitationType;
        return $this;
    }
    /**
     * Get precipitationDetailExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPrecipitationDetailExtension()
    {
        return $this->precipitationDetailExtension;
    }
    /**
     * Set precipitationDetailExtension value
     * @param \StructType\ExtensionType $precipitationDetailExtension
     * @return \StructType\PrecipitationDetail
     */
    public function setPrecipitationDetailExtension(\StructType\ExtensionType $precipitationDetailExtension = null)
    {
        $this->precipitationDetailExtension = $precipitationDetailExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrecipitationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
