<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoorEnvironmentConditions StructType
 * @subpackage Structs
 */
class PoorEnvironmentConditions extends Conditions
{
    /**
     * The poorEnvironmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $poorEnvironmentType;
    /**
     * The precipitationDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrecipitationDetail
     */
    public $precipitationDetail;
    /**
     * The visibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Visibility
     */
    public $visibility;
    /**
     * The pollutionMeasurement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PollutionMeasurement[]
     */
    public $pollutionMeasurement;
    /**
     * The temperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Temperature
     */
    public $temperature;
    /**
     * The wind
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Wind
     */
    public $wind;
    /**
     * The humidity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Humidity
     */
    public $humidity;
    /**
     * The poorEnvironmentConditionsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $poorEnvironmentConditionsExtension;
    /**
     * Constructor method for PoorEnvironmentConditions
     * @uses PoorEnvironmentConditions::setPoorEnvironmentType()
     * @uses PoorEnvironmentConditions::setPrecipitationDetail()
     * @uses PoorEnvironmentConditions::setVisibility()
     * @uses PoorEnvironmentConditions::setPollutionMeasurement()
     * @uses PoorEnvironmentConditions::setTemperature()
     * @uses PoorEnvironmentConditions::setWind()
     * @uses PoorEnvironmentConditions::setHumidity()
     * @uses PoorEnvironmentConditions::setPoorEnvironmentConditionsExtension()
     * @param string[] $poorEnvironmentType
     * @param \StructType\PrecipitationDetail $precipitationDetail
     * @param \StructType\Visibility $visibility
     * @param \StructType\PollutionMeasurement[] $pollutionMeasurement
     * @param \StructType\Temperature $temperature
     * @param \StructType\Wind $wind
     * @param \StructType\Humidity $humidity
     * @param \StructType\ExtensionType $poorEnvironmentConditionsExtension
     */
    public function __construct(array $poorEnvironmentType = array(), \StructType\PrecipitationDetail $precipitationDetail = null, \StructType\Visibility $visibility = null, array $pollutionMeasurement = array(), \StructType\Temperature $temperature = null, \StructType\Wind $wind = null, \StructType\Humidity $humidity = null, \StructType\ExtensionType $poorEnvironmentConditionsExtension = null)
    {
        $this
            ->setPoorEnvironmentType($poorEnvironmentType)
            ->setPrecipitationDetail($precipitationDetail)
            ->setVisibility($visibility)
            ->setPollutionMeasurement($pollutionMeasurement)
            ->setTemperature($temperature)
            ->setWind($wind)
            ->setHumidity($humidity)
            ->setPoorEnvironmentConditionsExtension($poorEnvironmentConditionsExtension);
    }
    /**
     * Get poorEnvironmentType value
     * @return string[]
     */
    public function getPoorEnvironmentType()
    {
        return $this->poorEnvironmentType;
    }
    /**
     * Set poorEnvironmentType value
     * @uses \EnumType\PoorEnvironmentTypeEnum::valueIsValid()
     * @uses \EnumType\PoorEnvironmentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $poorEnvironmentType
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setPoorEnvironmentType(array $poorEnvironmentType = array())
    {
        $invalidValues = array();
        foreach ($poorEnvironmentType as $poorEnvironmentConditionsPoorEnvironmentTypeItem) {
            if (!\EnumType\PoorEnvironmentTypeEnum::valueIsValid($poorEnvironmentConditionsPoorEnvironmentTypeItem)) {
                $invalidValues[] = var_export($poorEnvironmentConditionsPoorEnvironmentTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PoorEnvironmentTypeEnum::getValidValues())), __LINE__);
        }
        $this->poorEnvironmentType = $poorEnvironmentType;
        return $this;
    }
    /**
     * Add item to poorEnvironmentType value
     * @uses \EnumType\PoorEnvironmentTypeEnum::valueIsValid()
     * @uses \EnumType\PoorEnvironmentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PoorEnvironmentConditions
     */
    public function addToPoorEnvironmentType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PoorEnvironmentTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PoorEnvironmentTypeEnum::getValidValues())), __LINE__);
        }
        $this->poorEnvironmentType[] = $item;
        return $this;
    }
    /**
     * Get precipitationDetail value
     * @return \StructType\PrecipitationDetail|null
     */
    public function getPrecipitationDetail()
    {
        return $this->precipitationDetail;
    }
    /**
     * Set precipitationDetail value
     * @param \StructType\PrecipitationDetail $precipitationDetail
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setPrecipitationDetail(\StructType\PrecipitationDetail $precipitationDetail = null)
    {
        $this->precipitationDetail = $precipitationDetail;
        return $this;
    }
    /**
     * Get visibility value
     * @return \StructType\Visibility|null
     */
    public function getVisibility()
    {
        return $this->visibility;
    }
    /**
     * Set visibility value
     * @param \StructType\Visibility $visibility
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setVisibility(\StructType\Visibility $visibility = null)
    {
        $this->visibility = $visibility;
        return $this;
    }
    /**
     * Get pollutionMeasurement value
     * @return \StructType\PollutionMeasurement[]|null
     */
    public function getPollutionMeasurement()
    {
        return $this->pollutionMeasurement;
    }
    /**
     * Set pollutionMeasurement value
     * @throws \InvalidArgumentException
     * @param \StructType\PollutionMeasurement[] $pollutionMeasurement
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setPollutionMeasurement(array $pollutionMeasurement = array())
    {
        foreach ($pollutionMeasurement as $poorEnvironmentConditionsPollutionMeasurementItem) {
            // validation for constraint: itemType
            if (!$poorEnvironmentConditionsPollutionMeasurementItem instanceof \StructType\PollutionMeasurement) {
                throw new \InvalidArgumentException(sprintf('The pollutionMeasurement property can only contain items of \StructType\PollutionMeasurement, "%s" given', is_object($poorEnvironmentConditionsPollutionMeasurementItem) ? get_class($poorEnvironmentConditionsPollutionMeasurementItem) : gettype($poorEnvironmentConditionsPollutionMeasurementItem)), __LINE__);
            }
        }
        $this->pollutionMeasurement = $pollutionMeasurement;
        return $this;
    }
    /**
     * Add item to pollutionMeasurement value
     * @throws \InvalidArgumentException
     * @param \StructType\PollutionMeasurement $item
     * @return \StructType\PoorEnvironmentConditions
     */
    public function addToPollutionMeasurement(\StructType\PollutionMeasurement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PollutionMeasurement) {
            throw new \InvalidArgumentException(sprintf('The pollutionMeasurement property can only contain items of \StructType\PollutionMeasurement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pollutionMeasurement[] = $item;
        return $this;
    }
    /**
     * Get temperature value
     * @return \StructType\Temperature|null
     */
    public function getTemperature()
    {
        return $this->temperature;
    }
    /**
     * Set temperature value
     * @param \StructType\Temperature $temperature
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setTemperature(\StructType\Temperature $temperature = null)
    {
        $this->temperature = $temperature;
        return $this;
    }
    /**
     * Get wind value
     * @return \StructType\Wind|null
     */
    public function getWind()
    {
        return $this->wind;
    }
    /**
     * Set wind value
     * @param \StructType\Wind $wind
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setWind(\StructType\Wind $wind = null)
    {
        $this->wind = $wind;
        return $this;
    }
    /**
     * Get humidity value
     * @return \StructType\Humidity|null
     */
    public function getHumidity()
    {
        return $this->humidity;
    }
    /**
     * Set humidity value
     * @param \StructType\Humidity $humidity
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setHumidity(\StructType\Humidity $humidity = null)
    {
        $this->humidity = $humidity;
        return $this;
    }
    /**
     * Get poorEnvironmentConditionsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPoorEnvironmentConditionsExtension()
    {
        return $this->poorEnvironmentConditionsExtension;
    }
    /**
     * Set poorEnvironmentConditionsExtension value
     * @param \StructType\ExtensionType $poorEnvironmentConditionsExtension
     * @return \StructType\PoorEnvironmentConditions
     */
    public function setPoorEnvironmentConditionsExtension(\StructType\ExtensionType $poorEnvironmentConditionsExtension = null)
    {
        $this->poorEnvironmentConditionsExtension = $poorEnvironmentConditionsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PoorEnvironmentConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
