<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollutionMeasurement StructType
 * @subpackage Structs
 */
class PollutionMeasurement extends AbstractStructBase
{
    /**
     * The pollutantConcentration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $pollutantConcentration;
    /**
     * The pollutantType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pollutantType;
    /**
     * The pollutionMeasurementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $pollutionMeasurementExtension;
    /**
     * Constructor method for PollutionMeasurement
     * @uses PollutionMeasurement::setPollutantConcentration()
     * @uses PollutionMeasurement::setPollutantType()
     * @uses PollutionMeasurement::setPollutionMeasurementExtension()
     * @param float $pollutantConcentration
     * @param string $pollutantType
     * @param \StructType\ExtensionType $pollutionMeasurementExtension
     */
    public function __construct($pollutantConcentration = null, $pollutantType = null, \StructType\ExtensionType $pollutionMeasurementExtension = null)
    {
        $this
            ->setPollutantConcentration($pollutantConcentration)
            ->setPollutantType($pollutantType)
            ->setPollutionMeasurementExtension($pollutionMeasurementExtension);
    }
    /**
     * Get pollutantConcentration value
     * @return float
     */
    public function getPollutantConcentration()
    {
        return $this->pollutantConcentration;
    }
    /**
     * Set pollutantConcentration value
     * @param float $pollutantConcentration
     * @return \StructType\PollutionMeasurement
     */
    public function setPollutantConcentration($pollutantConcentration = null)
    {
        $this->pollutantConcentration = $pollutantConcentration;
        return $this;
    }
    /**
     * Get pollutantType value
     * @return string
     */
    public function getPollutantType()
    {
        return $this->pollutantType;
    }
    /**
     * Set pollutantType value
     * @uses \EnumType\PollutantTypeEnum::valueIsValid()
     * @uses \EnumType\PollutantTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pollutantType
     * @return \StructType\PollutionMeasurement
     */
    public function setPollutantType($pollutantType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PollutantTypeEnum::valueIsValid($pollutantType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pollutantType, implode(', ', \EnumType\PollutantTypeEnum::getValidValues())), __LINE__);
        }
        $this->pollutantType = $pollutantType;
        return $this;
    }
    /**
     * Get pollutionMeasurementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPollutionMeasurementExtension()
    {
        return $this->pollutionMeasurementExtension;
    }
    /**
     * Set pollutionMeasurementExtension value
     * @param \StructType\ExtensionType $pollutionMeasurementExtension
     * @return \StructType\PollutionMeasurement
     */
    public function setPollutionMeasurementExtension(\StructType\ExtensionType $pollutionMeasurementExtension = null)
    {
        $this->pollutionMeasurementExtension = $pollutionMeasurementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollutionMeasurement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
