<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceNameStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Names of VIA points, used to help identify the LINE, for example, Luton to Luton via Sutton. Currently 3 in VDV. Should only be included if the detail level was requested.
 * @subpackage Structs
 */
class PlaceNameStructure extends AbstractStructBase
{
    /**
     * The PlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a TOPOGRAPHIC PLACE.
     * - minOccurs: 0
     * @var \StructType\JourneyPlaceRefStructure
     */
    public $PlaceRef;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Names of place used to help identify the LINE.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguagePlaceNameStructure[]
     */
    public $PlaceName;
    /**
     * The PlaceShortName
     * Meta informations extracted from the WSDL
     * - documentation: Short name of TOPOGRAPHIC PLACE. Should only be included if the detail level was requested.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguagePlaceNameStructure[]
     */
    public $PlaceShortName;
    /**
     * Constructor method for PlaceNameStructure
     * @uses PlaceNameStructure::setPlaceRef()
     * @uses PlaceNameStructure::setPlaceName()
     * @uses PlaceNameStructure::setPlaceShortName()
     * @param \StructType\JourneyPlaceRefStructure $placeRef
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $placeName
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $placeShortName
     */
    public function __construct(\StructType\JourneyPlaceRefStructure $placeRef = null, array $placeName = array(), array $placeShortName = array())
    {
        $this
            ->setPlaceRef($placeRef)
            ->setPlaceName($placeName)
            ->setPlaceShortName($placeShortName);
    }
    /**
     * Get PlaceRef value
     * @return \StructType\JourneyPlaceRefStructure|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param \StructType\JourneyPlaceRefStructure $placeRef
     * @return \StructType\PlaceNameStructure
     */
    public function setPlaceRef(\StructType\JourneyPlaceRefStructure $placeRef = null)
    {
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get PlaceName value
     * @return \StructType\NaturalLanguagePlaceNameStructure[]|null
     */
    public function getPlaceName()
    {
        return $this->PlaceName;
    }
    /**
     * Set PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $placeName
     * @return \StructType\PlaceNameStructure
     */
    public function setPlaceName(array $placeName = array())
    {
        foreach ($placeName as $placeNameStructurePlaceNameItem) {
            // validation for constraint: itemType
            if (!$placeNameStructurePlaceNameItem instanceof \StructType\NaturalLanguagePlaceNameStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($placeNameStructurePlaceNameItem) ? get_class($placeNameStructurePlaceNameItem) : gettype($placeNameStructurePlaceNameItem)), __LINE__);
            }
        }
        $this->PlaceName = $placeName;
        return $this;
    }
    /**
     * Add item to PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure $item
     * @return \StructType\PlaceNameStructure
     */
    public function addToPlaceName(\StructType\NaturalLanguagePlaceNameStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguagePlaceNameStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceName[] = $item;
        return $this;
    }
    /**
     * Get PlaceShortName value
     * @return \StructType\NaturalLanguagePlaceNameStructure[]|null
     */
    public function getPlaceShortName()
    {
        return $this->PlaceShortName;
    }
    /**
     * Set PlaceShortName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $placeShortName
     * @return \StructType\PlaceNameStructure
     */
    public function setPlaceShortName(array $placeShortName = array())
    {
        foreach ($placeShortName as $placeNameStructurePlaceShortNameItem) {
            // validation for constraint: itemType
            if (!$placeNameStructurePlaceShortNameItem instanceof \StructType\NaturalLanguagePlaceNameStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceShortName property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($placeNameStructurePlaceShortNameItem) ? get_class($placeNameStructurePlaceShortNameItem) : gettype($placeNameStructurePlaceShortNameItem)), __LINE__);
            }
        }
        $this->PlaceShortName = $placeShortName;
        return $this;
    }
    /**
     * Add item to PlaceShortName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure $item
     * @return \StructType\PlaceNameStructure
     */
    public function addToPlaceShortName(\StructType\NaturalLanguagePlaceNameStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguagePlaceNameStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceShortName property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceShortName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceNameStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
