<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Period StructType
 * @subpackage Structs
 */
class Period extends AbstractStructBase
{
    /**
     * The startOfPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startOfPeriod;
    /**
     * The endOfPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endOfPeriod;
    /**
     * The periodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $periodName;
    /**
     * The recurringTimePeriodOfDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TimePeriodOfDay[]
     */
    public $recurringTimePeriodOfDay;
    /**
     * The recurringDayWeekMonthPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DayWeekMonth[]
     */
    public $recurringDayWeekMonthPeriod;
    /**
     * The periodExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $periodExtension;
    /**
     * Constructor method for Period
     * @uses Period::setStartOfPeriod()
     * @uses Period::setEndOfPeriod()
     * @uses Period::setPeriodName()
     * @uses Period::setRecurringTimePeriodOfDay()
     * @uses Period::setRecurringDayWeekMonthPeriod()
     * @uses Period::setPeriodExtension()
     * @param string $startOfPeriod
     * @param string $endOfPeriod
     * @param \StructType\MultilingualString $periodName
     * @param \StructType\TimePeriodOfDay[] $recurringTimePeriodOfDay
     * @param \StructType\DayWeekMonth[] $recurringDayWeekMonthPeriod
     * @param \StructType\ExtensionType $periodExtension
     */
    public function __construct($startOfPeriod = null, $endOfPeriod = null, \StructType\MultilingualString $periodName = null, array $recurringTimePeriodOfDay = array(), array $recurringDayWeekMonthPeriod = array(), \StructType\ExtensionType $periodExtension = null)
    {
        $this
            ->setStartOfPeriod($startOfPeriod)
            ->setEndOfPeriod($endOfPeriod)
            ->setPeriodName($periodName)
            ->setRecurringTimePeriodOfDay($recurringTimePeriodOfDay)
            ->setRecurringDayWeekMonthPeriod($recurringDayWeekMonthPeriod)
            ->setPeriodExtension($periodExtension);
    }
    /**
     * Get startOfPeriod value
     * @return string|null
     */
    public function getStartOfPeriod()
    {
        return $this->startOfPeriod;
    }
    /**
     * Set startOfPeriod value
     * @param string $startOfPeriod
     * @return \StructType\Period
     */
    public function setStartOfPeriod($startOfPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($startOfPeriod) && !is_string($startOfPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startOfPeriod)), __LINE__);
        }
        $this->startOfPeriod = $startOfPeriod;
        return $this;
    }
    /**
     * Get endOfPeriod value
     * @return string|null
     */
    public function getEndOfPeriod()
    {
        return $this->endOfPeriod;
    }
    /**
     * Set endOfPeriod value
     * @param string $endOfPeriod
     * @return \StructType\Period
     */
    public function setEndOfPeriod($endOfPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($endOfPeriod) && !is_string($endOfPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endOfPeriod)), __LINE__);
        }
        $this->endOfPeriod = $endOfPeriod;
        return $this;
    }
    /**
     * Get periodName value
     * @return \StructType\MultilingualString|null
     */
    public function getPeriodName()
    {
        return $this->periodName;
    }
    /**
     * Set periodName value
     * @param \StructType\MultilingualString $periodName
     * @return \StructType\Period
     */
    public function setPeriodName(\StructType\MultilingualString $periodName = null)
    {
        $this->periodName = $periodName;
        return $this;
    }
    /**
     * Get recurringTimePeriodOfDay value
     * @return \StructType\TimePeriodOfDay[]|null
     */
    public function getRecurringTimePeriodOfDay()
    {
        return $this->recurringTimePeriodOfDay;
    }
    /**
     * Set recurringTimePeriodOfDay value
     * @throws \InvalidArgumentException
     * @param \StructType\TimePeriodOfDay[] $recurringTimePeriodOfDay
     * @return \StructType\Period
     */
    public function setRecurringTimePeriodOfDay(array $recurringTimePeriodOfDay = array())
    {
        foreach ($recurringTimePeriodOfDay as $periodRecurringTimePeriodOfDayItem) {
            // validation for constraint: itemType
            if (!$periodRecurringTimePeriodOfDayItem instanceof \StructType\TimePeriodOfDay) {
                throw new \InvalidArgumentException(sprintf('The recurringTimePeriodOfDay property can only contain items of \StructType\TimePeriodOfDay, "%s" given', is_object($periodRecurringTimePeriodOfDayItem) ? get_class($periodRecurringTimePeriodOfDayItem) : gettype($periodRecurringTimePeriodOfDayItem)), __LINE__);
            }
        }
        $this->recurringTimePeriodOfDay = $recurringTimePeriodOfDay;
        return $this;
    }
    /**
     * Add item to recurringTimePeriodOfDay value
     * @throws \InvalidArgumentException
     * @param \StructType\TimePeriodOfDay $item
     * @return \StructType\Period
     */
    public function addToRecurringTimePeriodOfDay(\StructType\TimePeriodOfDay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimePeriodOfDay) {
            throw new \InvalidArgumentException(sprintf('The recurringTimePeriodOfDay property can only contain items of \StructType\TimePeriodOfDay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->recurringTimePeriodOfDay[] = $item;
        return $this;
    }
    /**
     * Get recurringDayWeekMonthPeriod value
     * @return \StructType\DayWeekMonth[]|null
     */
    public function getRecurringDayWeekMonthPeriod()
    {
        return $this->recurringDayWeekMonthPeriod;
    }
    /**
     * Set recurringDayWeekMonthPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\DayWeekMonth[] $recurringDayWeekMonthPeriod
     * @return \StructType\Period
     */
    public function setRecurringDayWeekMonthPeriod(array $recurringDayWeekMonthPeriod = array())
    {
        foreach ($recurringDayWeekMonthPeriod as $periodRecurringDayWeekMonthPeriodItem) {
            // validation for constraint: itemType
            if (!$periodRecurringDayWeekMonthPeriodItem instanceof \StructType\DayWeekMonth) {
                throw new \InvalidArgumentException(sprintf('The recurringDayWeekMonthPeriod property can only contain items of \StructType\DayWeekMonth, "%s" given', is_object($periodRecurringDayWeekMonthPeriodItem) ? get_class($periodRecurringDayWeekMonthPeriodItem) : gettype($periodRecurringDayWeekMonthPeriodItem)), __LINE__);
            }
        }
        $this->recurringDayWeekMonthPeriod = $recurringDayWeekMonthPeriod;
        return $this;
    }
    /**
     * Add item to recurringDayWeekMonthPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\DayWeekMonth $item
     * @return \StructType\Period
     */
    public function addToRecurringDayWeekMonthPeriod(\StructType\DayWeekMonth $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DayWeekMonth) {
            throw new \InvalidArgumentException(sprintf('The recurringDayWeekMonthPeriod property can only contain items of \StructType\DayWeekMonth, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->recurringDayWeekMonthPeriod[] = $item;
        return $this;
    }
    /**
     * Get periodExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getPeriodExtension()
    {
        return $this->periodExtension;
    }
    /**
     * Set periodExtension value
     * @param \StructType\ExtensionType $periodExtension
     * @return \StructType\Period
     */
    public function setPeriodExtension(\StructType\ExtensionType $periodExtension = null)
    {
        $this->periodExtension = $periodExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Period
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
