<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerAccessibilityNeedsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for accessibility needs. Records the requirementrs of a passenger that may affect choice of facilities.
 * @subpackage Structs
 */
class PassengerAccessibilityNeedsStructure extends AbstractStructBase
{
    /**
     * The UserNeed
     * Meta informations extracted from the WSDL
     * - documentation: Specific pyschosensory need that may constrain choice of services and facilities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserNeedStructure[]
     */
    public $UserNeed;
    /**
     * The AccompaniedByCarer
     * Meta informations extracted from the WSDL
     * - documentation: Whether the passenger is accompanied by a carer or assistant.
     * - minOccurs: 0
     * @var bool
     */
    public $AccompaniedByCarer;
    /**
     * Constructor method for PassengerAccessibilityNeedsStructure
     * @uses PassengerAccessibilityNeedsStructure::setUserNeed()
     * @uses PassengerAccessibilityNeedsStructure::setAccompaniedByCarer()
     * @param \StructType\UserNeedStructure[] $userNeed
     * @param bool $accompaniedByCarer
     */
    public function __construct(array $userNeed = array(), $accompaniedByCarer = null)
    {
        $this
            ->setUserNeed($userNeed)
            ->setAccompaniedByCarer($accompaniedByCarer);
    }
    /**
     * Get UserNeed value
     * @return \StructType\UserNeedStructure[]|null
     */
    public function getUserNeed()
    {
        return $this->UserNeed;
    }
    /**
     * Set UserNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\UserNeedStructure[] $userNeed
     * @return \StructType\PassengerAccessibilityNeedsStructure
     */
    public function setUserNeed(array $userNeed = array())
    {
        foreach ($userNeed as $passengerAccessibilityNeedsStructureUserNeedItem) {
            // validation for constraint: itemType
            if (!$passengerAccessibilityNeedsStructureUserNeedItem instanceof \StructType\UserNeedStructure) {
                throw new \InvalidArgumentException(sprintf('The UserNeed property can only contain items of \StructType\UserNeedStructure, "%s" given', is_object($passengerAccessibilityNeedsStructureUserNeedItem) ? get_class($passengerAccessibilityNeedsStructureUserNeedItem) : gettype($passengerAccessibilityNeedsStructureUserNeedItem)), __LINE__);
            }
        }
        $this->UserNeed = $userNeed;
        return $this;
    }
    /**
     * Add item to UserNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\UserNeedStructure $item
     * @return \StructType\PassengerAccessibilityNeedsStructure
     */
    public function addToUserNeed(\StructType\UserNeedStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserNeedStructure) {
            throw new \InvalidArgumentException(sprintf('The UserNeed property can only contain items of \StructType\UserNeedStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserNeed[] = $item;
        return $this;
    }
    /**
     * Get AccompaniedByCarer value
     * @return bool|null
     */
    public function getAccompaniedByCarer()
    {
        return $this->AccompaniedByCarer;
    }
    /**
     * Set AccompaniedByCarer value
     * @param bool $accompaniedByCarer
     * @return \StructType\PassengerAccessibilityNeedsStructure
     */
    public function setAccompaniedByCarer($accompaniedByCarer = null)
    {
        // validation for constraint: boolean
        if (!is_null($accompaniedByCarer) && !is_bool($accompaniedByCarer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accompaniedByCarer)), __LINE__);
        }
        $this->AccompaniedByCarer = $accompaniedByCarer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerAccessibilityNeedsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
