<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyBySmsActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notify user by SMS.
 * @subpackage Structs
 */
class NotifyBySmsActionStructure extends PushedActionStructure
{
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: MSISDN of user to which to send messages. | International phonenumber +41675601 etc.
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Premium
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether content is flagged as subject to premium charge.
     * - minOccurs: 0
     * @var bool
     */
    public $Premium;
    /**
     * Constructor method for NotifyBySmsActionStructure
     * @uses NotifyBySmsActionStructure::setPhone()
     * @uses NotifyBySmsActionStructure::setPremium()
     * @param string $phone
     * @param bool $premium
     */
    public function __construct($phone = 'true', $premium = false)
    {
        $this
            ->setPhone($phone)
            ->setPremium($premium);
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\NotifyBySmsActionStructure
     */
    public function setPhone($phone = 'true')
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Premium value
     * @return bool|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param bool $premium
     * @return \StructType\NotifyBySmsActionStructure
     */
    public function setPremium($premium = false)
    {
        // validation for constraint: boolean
        if (!is_null($premium) && !is_bool($premium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifyBySmsActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
