<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyByEmailActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Notify user by Email.
 * @subpackage Structs
 */
class NotifyByEmailActionStructure extends PushedActionStructure
{
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Email address to which notice should be sent. | Email address type.
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for NotifyByEmailActionStructure
     * @uses NotifyByEmailActionStructure::setEmail()
     * @param string $email
     */
    public function __construct($email = null)
    {
        $this
            ->setEmail($email);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\NotifyByEmailActionStructure
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NotifyByEmailActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
