<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonWeatherRelatedRoadConditions StructType
 * @subpackage Structs
 */
class NonWeatherRelatedRoadConditions extends RoadConditions
{
    /**
     * The nonWeatherRelatedRoadConditionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $nonWeatherRelatedRoadConditionType;
    /**
     * The nonWeatherRelatedRoadConditionsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $nonWeatherRelatedRoadConditionsExtension;
    /**
     * Constructor method for NonWeatherRelatedRoadConditions
     * @uses NonWeatherRelatedRoadConditions::setNonWeatherRelatedRoadConditionType()
     * @uses NonWeatherRelatedRoadConditions::setNonWeatherRelatedRoadConditionsExtension()
     * @param string[] $nonWeatherRelatedRoadConditionType
     * @param \StructType\ExtensionType $nonWeatherRelatedRoadConditionsExtension
     */
    public function __construct(array $nonWeatherRelatedRoadConditionType = array(), \StructType\ExtensionType $nonWeatherRelatedRoadConditionsExtension = null)
    {
        $this
            ->setNonWeatherRelatedRoadConditionType($nonWeatherRelatedRoadConditionType)
            ->setNonWeatherRelatedRoadConditionsExtension($nonWeatherRelatedRoadConditionsExtension);
    }
    /**
     * Get nonWeatherRelatedRoadConditionType value
     * @return string[]
     */
    public function getNonWeatherRelatedRoadConditionType()
    {
        return $this->nonWeatherRelatedRoadConditionType;
    }
    /**
     * Set nonWeatherRelatedRoadConditionType value
     * @uses \EnumType\NonWeatherRelatedRoadConditionTypeEnum::valueIsValid()
     * @uses \EnumType\NonWeatherRelatedRoadConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $nonWeatherRelatedRoadConditionType
     * @return \StructType\NonWeatherRelatedRoadConditions
     */
    public function setNonWeatherRelatedRoadConditionType(array $nonWeatherRelatedRoadConditionType = array())
    {
        $invalidValues = array();
        foreach ($nonWeatherRelatedRoadConditionType as $nonWeatherRelatedRoadConditionsNonWeatherRelatedRoadConditionTypeItem) {
            if (!\EnumType\NonWeatherRelatedRoadConditionTypeEnum::valueIsValid($nonWeatherRelatedRoadConditionsNonWeatherRelatedRoadConditionTypeItem)) {
                $invalidValues[] = var_export($nonWeatherRelatedRoadConditionsNonWeatherRelatedRoadConditionTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\NonWeatherRelatedRoadConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->nonWeatherRelatedRoadConditionType = $nonWeatherRelatedRoadConditionType;
        return $this;
    }
    /**
     * Add item to nonWeatherRelatedRoadConditionType value
     * @uses \EnumType\NonWeatherRelatedRoadConditionTypeEnum::valueIsValid()
     * @uses \EnumType\NonWeatherRelatedRoadConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NonWeatherRelatedRoadConditions
     */
    public function addToNonWeatherRelatedRoadConditionType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NonWeatherRelatedRoadConditionTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\NonWeatherRelatedRoadConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->nonWeatherRelatedRoadConditionType[] = $item;
        return $this;
    }
    /**
     * Get nonWeatherRelatedRoadConditionsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getNonWeatherRelatedRoadConditionsExtension()
    {
        return $this->nonWeatherRelatedRoadConditionsExtension;
    }
    /**
     * Set nonWeatherRelatedRoadConditionsExtension value
     * @param \StructType\ExtensionType $nonWeatherRelatedRoadConditionsExtension
     * @return \StructType\NonWeatherRelatedRoadConditions
     */
    public function setNonWeatherRelatedRoadConditionsExtension(\StructType\ExtensionType $nonWeatherRelatedRoadConditionsExtension = null)
    {
        $this->nonWeatherRelatedRoadConditionsExtension = $nonWeatherRelatedRoadConditionsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonWeatherRelatedRoadConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
