<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkManagement StructType
 * @subpackage Structs
 */
abstract class NetworkManagement extends OperatorAction
{
    /**
     * The complianceOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $complianceOption;
    /**
     * The applicableForTrafficDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $applicableForTrafficDirection;
    /**
     * The applicableForTrafficType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $applicableForTrafficType;
    /**
     * The placesAtWhichApplicable
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $placesAtWhichApplicable;
    /**
     * The automaticallyInitiated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $automaticallyInitiated;
    /**
     * The forVehiclesWithCharacteristicsOf
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehicleCharacteristics[]
     */
    public $forVehiclesWithCharacteristicsOf;
    /**
     * The networkManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $networkManagementExtension;
    /**
     * Constructor method for NetworkManagement
     * @uses NetworkManagement::setComplianceOption()
     * @uses NetworkManagement::setApplicableForTrafficDirection()
     * @uses NetworkManagement::setApplicableForTrafficType()
     * @uses NetworkManagement::setPlacesAtWhichApplicable()
     * @uses NetworkManagement::setAutomaticallyInitiated()
     * @uses NetworkManagement::setForVehiclesWithCharacteristicsOf()
     * @uses NetworkManagement::setNetworkManagementExtension()
     * @param string $complianceOption
     * @param string[] $applicableForTrafficDirection
     * @param string[] $applicableForTrafficType
     * @param string[] $placesAtWhichApplicable
     * @param bool $automaticallyInitiated
     * @param \StructType\VehicleCharacteristics[] $forVehiclesWithCharacteristicsOf
     * @param \StructType\ExtensionType $networkManagementExtension
     */
    public function __construct($complianceOption = null, array $applicableForTrafficDirection = array(), array $applicableForTrafficType = array(), array $placesAtWhichApplicable = array(), $automaticallyInitiated = null, array $forVehiclesWithCharacteristicsOf = array(), \StructType\ExtensionType $networkManagementExtension = null)
    {
        $this
            ->setComplianceOption($complianceOption)
            ->setApplicableForTrafficDirection($applicableForTrafficDirection)
            ->setApplicableForTrafficType($applicableForTrafficType)
            ->setPlacesAtWhichApplicable($placesAtWhichApplicable)
            ->setAutomaticallyInitiated($automaticallyInitiated)
            ->setForVehiclesWithCharacteristicsOf($forVehiclesWithCharacteristicsOf)
            ->setNetworkManagementExtension($networkManagementExtension);
    }
    /**
     * Get complianceOption value
     * @return string
     */
    public function getComplianceOption()
    {
        return $this->complianceOption;
    }
    /**
     * Set complianceOption value
     * @uses \EnumType\ComplianceOptionEnum::valueIsValid()
     * @uses \EnumType\ComplianceOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $complianceOption
     * @return \StructType\NetworkManagement
     */
    public function setComplianceOption($complianceOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComplianceOptionEnum::valueIsValid($complianceOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $complianceOption, implode(', ', \EnumType\ComplianceOptionEnum::getValidValues())), __LINE__);
        }
        $this->complianceOption = $complianceOption;
        return $this;
    }
    /**
     * Get applicableForTrafficDirection value
     * @return string[]|null
     */
    public function getApplicableForTrafficDirection()
    {
        return $this->applicableForTrafficDirection;
    }
    /**
     * Set applicableForTrafficDirection value
     * @uses \EnumType\DirectionEnum::valueIsValid()
     * @uses \EnumType\DirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $applicableForTrafficDirection
     * @return \StructType\NetworkManagement
     */
    public function setApplicableForTrafficDirection(array $applicableForTrafficDirection = array())
    {
        $invalidValues = array();
        foreach ($applicableForTrafficDirection as $networkManagementApplicableForTrafficDirectionItem) {
            if (!\EnumType\DirectionEnum::valueIsValid($networkManagementApplicableForTrafficDirectionItem)) {
                $invalidValues[] = var_export($networkManagementApplicableForTrafficDirectionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\DirectionEnum::getValidValues())), __LINE__);
        }
        $this->applicableForTrafficDirection = $applicableForTrafficDirection;
        return $this;
    }
    /**
     * Add item to applicableForTrafficDirection value
     * @uses \EnumType\DirectionEnum::valueIsValid()
     * @uses \EnumType\DirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NetworkManagement
     */
    public function addToApplicableForTrafficDirection($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirectionEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\DirectionEnum::getValidValues())), __LINE__);
        }
        $this->applicableForTrafficDirection[] = $item;
        return $this;
    }
    /**
     * Get applicableForTrafficType value
     * @return string[]|null
     */
    public function getApplicableForTrafficType()
    {
        return $this->applicableForTrafficType;
    }
    /**
     * Set applicableForTrafficType value
     * @uses \EnumType\TrafficTypeEnum::valueIsValid()
     * @uses \EnumType\TrafficTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $applicableForTrafficType
     * @return \StructType\NetworkManagement
     */
    public function setApplicableForTrafficType(array $applicableForTrafficType = array())
    {
        $invalidValues = array();
        foreach ($applicableForTrafficType as $networkManagementApplicableForTrafficTypeItem) {
            if (!\EnumType\TrafficTypeEnum::valueIsValid($networkManagementApplicableForTrafficTypeItem)) {
                $invalidValues[] = var_export($networkManagementApplicableForTrafficTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\TrafficTypeEnum::getValidValues())), __LINE__);
        }
        $this->applicableForTrafficType = $applicableForTrafficType;
        return $this;
    }
    /**
     * Add item to applicableForTrafficType value
     * @uses \EnumType\TrafficTypeEnum::valueIsValid()
     * @uses \EnumType\TrafficTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NetworkManagement
     */
    public function addToApplicableForTrafficType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\TrafficTypeEnum::getValidValues())), __LINE__);
        }
        $this->applicableForTrafficType[] = $item;
        return $this;
    }
    /**
     * Get placesAtWhichApplicable value
     * @return string[]|null
     */
    public function getPlacesAtWhichApplicable()
    {
        return $this->placesAtWhichApplicable;
    }
    /**
     * Set placesAtWhichApplicable value
     * @uses \EnumType\PlacesEnum::valueIsValid()
     * @uses \EnumType\PlacesEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $placesAtWhichApplicable
     * @return \StructType\NetworkManagement
     */
    public function setPlacesAtWhichApplicable(array $placesAtWhichApplicable = array())
    {
        $invalidValues = array();
        foreach ($placesAtWhichApplicable as $networkManagementPlacesAtWhichApplicableItem) {
            if (!\EnumType\PlacesEnum::valueIsValid($networkManagementPlacesAtWhichApplicableItem)) {
                $invalidValues[] = var_export($networkManagementPlacesAtWhichApplicableItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PlacesEnum::getValidValues())), __LINE__);
        }
        $this->placesAtWhichApplicable = $placesAtWhichApplicable;
        return $this;
    }
    /**
     * Add item to placesAtWhichApplicable value
     * @uses \EnumType\PlacesEnum::valueIsValid()
     * @uses \EnumType\PlacesEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NetworkManagement
     */
    public function addToPlacesAtWhichApplicable($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PlacesEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PlacesEnum::getValidValues())), __LINE__);
        }
        $this->placesAtWhichApplicable[] = $item;
        return $this;
    }
    /**
     * Get automaticallyInitiated value
     * @return bool|null
     */
    public function getAutomaticallyInitiated()
    {
        return $this->automaticallyInitiated;
    }
    /**
     * Set automaticallyInitiated value
     * @param bool $automaticallyInitiated
     * @return \StructType\NetworkManagement
     */
    public function setAutomaticallyInitiated($automaticallyInitiated = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticallyInitiated) && !is_bool($automaticallyInitiated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($automaticallyInitiated)), __LINE__);
        }
        $this->automaticallyInitiated = $automaticallyInitiated;
        return $this;
    }
    /**
     * Get forVehiclesWithCharacteristicsOf value
     * @return \StructType\VehicleCharacteristics[]|null
     */
    public function getForVehiclesWithCharacteristicsOf()
    {
        return $this->forVehiclesWithCharacteristicsOf;
    }
    /**
     * Set forVehiclesWithCharacteristicsOf value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleCharacteristics[] $forVehiclesWithCharacteristicsOf
     * @return \StructType\NetworkManagement
     */
    public function setForVehiclesWithCharacteristicsOf(array $forVehiclesWithCharacteristicsOf = array())
    {
        foreach ($forVehiclesWithCharacteristicsOf as $networkManagementForVehiclesWithCharacteristicsOfItem) {
            // validation for constraint: itemType
            if (!$networkManagementForVehiclesWithCharacteristicsOfItem instanceof \StructType\VehicleCharacteristics) {
                throw new \InvalidArgumentException(sprintf('The forVehiclesWithCharacteristicsOf property can only contain items of \StructType\VehicleCharacteristics, "%s" given', is_object($networkManagementForVehiclesWithCharacteristicsOfItem) ? get_class($networkManagementForVehiclesWithCharacteristicsOfItem) : gettype($networkManagementForVehiclesWithCharacteristicsOfItem)), __LINE__);
            }
        }
        $this->forVehiclesWithCharacteristicsOf = $forVehiclesWithCharacteristicsOf;
        return $this;
    }
    /**
     * Add item to forVehiclesWithCharacteristicsOf value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleCharacteristics $item
     * @return \StructType\NetworkManagement
     */
    public function addToForVehiclesWithCharacteristicsOf(\StructType\VehicleCharacteristics $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleCharacteristics) {
            throw new \InvalidArgumentException(sprintf('The forVehiclesWithCharacteristicsOf property can only contain items of \StructType\VehicleCharacteristics, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->forVehiclesWithCharacteristicsOf[] = $item;
        return $this;
    }
    /**
     * Get networkManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getNetworkManagementExtension()
    {
        return $this->networkManagementExtension;
    }
    /**
     * Set networkManagementExtension value
     * @param \StructType\ExtensionType $networkManagementExtension
     * @return \StructType\NetworkManagement
     */
    public function setNetworkManagementExtension(\StructType\ExtensionType $networkManagementExtension = null)
    {
        $this->networkManagementExtension = $networkManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
