<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkContextStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for shared context.
 * @subpackage Structs
 */
class NetworkContextStructure extends AbstractStructBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - documentation: Default OPERATOR for SITUATIONs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedOperatorStructure[]
     */
    public $Operator;
    /**
     * The Network
     * Meta informations extracted from the WSDL
     * - documentation: Default Network of affected LINEs. These values apply to all SITUATIONs unless overridden on individual instances.
     * - minOccurs: 0
     * @var \StructType\NetworkStructure
     */
    public $Network;
    /**
     * Constructor method for NetworkContextStructure
     * @uses NetworkContextStructure::setOperator()
     * @uses NetworkContextStructure::setNetwork()
     * @param \StructType\AffectedOperatorStructure[] $operator
     * @param \StructType\NetworkStructure $network
     */
    public function __construct(array $operator = array(), \StructType\NetworkStructure $network = null)
    {
        $this
            ->setOperator($operator)
            ->setNetwork($network);
    }
    /**
     * Get Operator value
     * @return \StructType\AffectedOperatorStructure[]|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure[] $operator
     * @return \StructType\NetworkContextStructure
     */
    public function setOperator(array $operator = array())
    {
        foreach ($operator as $networkContextStructureOperatorItem) {
            // validation for constraint: itemType
            if (!$networkContextStructureOperatorItem instanceof \StructType\AffectedOperatorStructure) {
                throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($networkContextStructureOperatorItem) ? get_class($networkContextStructureOperatorItem) : gettype($networkContextStructureOperatorItem)), __LINE__);
            }
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Add item to Operator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure $item
     * @return \StructType\NetworkContextStructure
     */
    public function addToOperator(\StructType\AffectedOperatorStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOperatorStructure) {
            throw new \InvalidArgumentException(sprintf('The Operator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Operator[] = $item;
        return $this;
    }
    /**
     * Get Network value
     * @return \StructType\NetworkStructure|null
     */
    public function getNetwork()
    {
        return $this->Network;
    }
    /**
     * Set Network value
     * @param \StructType\NetworkStructure $network
     * @return \StructType\NetworkContextStructure
     */
    public function setNetwork(\StructType\NetworkStructure $network = null)
    {
        $this->Network = $network;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkContextStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
