<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoringInformationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for the monitoring conditions (frequency of mesurement, etc): an automatic monitoring of the satus of a lift with pushed alert in case of incident is very different from a daily manual/visual check.
 * @subpackage Structs
 */
class MonitoringInformationStructure extends AbstractStructBase
{
    /**
     * The MonitoringInterval
     * Meta informations extracted from the WSDL
     * - documentation: Mean time interval between two measurements.
     * - minOccurs: 0
     * @var string
     */
    public $MonitoringInterval;
    /**
     * The MonitoringType
     * Meta informations extracted from the WSDL
     * - documentation: How monitoring is automatic, manual, etc..
     * - minOccurs: 0
     * @var string
     */
    public $MonitoringType;
    /**
     * The MonitoringPeriod
     * Meta informations extracted from the WSDL
     * - documentation: When the monitoring is in effect. If absent always.
     * - minOccurs: 0
     * @var \StructType\MonitoringValidityConditionStructure
     */
    public $MonitoringPeriod;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for MonitoringInformationStructure
     * @uses MonitoringInformationStructure::setMonitoringInterval()
     * @uses MonitoringInformationStructure::setMonitoringType()
     * @uses MonitoringInformationStructure::setMonitoringPeriod()
     * @uses MonitoringInformationStructure::setExtensions()
     * @param string $monitoringInterval
     * @param string $monitoringType
     * @param \StructType\MonitoringValidityConditionStructure $monitoringPeriod
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($monitoringInterval = null, $monitoringType = null, \StructType\MonitoringValidityConditionStructure $monitoringPeriod = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringInterval($monitoringInterval)
            ->setMonitoringType($monitoringType)
            ->setMonitoringPeriod($monitoringPeriod)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringInterval value
     * @return string|null
     */
    public function getMonitoringInterval()
    {
        return $this->MonitoringInterval;
    }
    /**
     * Set MonitoringInterval value
     * @param string $monitoringInterval
     * @return \StructType\MonitoringInformationStructure
     */
    public function setMonitoringInterval($monitoringInterval = null)
    {
        // validation for constraint: string
        if (!is_null($monitoringInterval) && !is_string($monitoringInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monitoringInterval)), __LINE__);
        }
        $this->MonitoringInterval = $monitoringInterval;
        return $this;
    }
    /**
     * Get MonitoringType value
     * @return string|null
     */
    public function getMonitoringType()
    {
        return $this->MonitoringType;
    }
    /**
     * Set MonitoringType value
     * @uses \EnumType\MonitoringTypeEnumeration::valueIsValid()
     * @uses \EnumType\MonitoringTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monitoringType
     * @return \StructType\MonitoringInformationStructure
     */
    public function setMonitoringType($monitoringType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MonitoringTypeEnumeration::valueIsValid($monitoringType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monitoringType, implode(', ', \EnumType\MonitoringTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->MonitoringType = $monitoringType;
        return $this;
    }
    /**
     * Get MonitoringPeriod value
     * @return \StructType\MonitoringValidityConditionStructure|null
     */
    public function getMonitoringPeriod()
    {
        return $this->MonitoringPeriod;
    }
    /**
     * Set MonitoringPeriod value
     * @param \StructType\MonitoringValidityConditionStructure $monitoringPeriod
     * @return \StructType\MonitoringInformationStructure
     */
    public function setMonitoringPeriod(\StructType\MonitoringValidityConditionStructure $monitoringPeriod = null)
    {
        $this->MonitoringPeriod = $monitoringPeriod;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\MonitoringInformationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoringInformationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
