<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoredVehicleJourneyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Monitored VEHICLE JOURNEY.
 * @subpackage Structs
 */
class MonitoredVehicleJourneyStructure extends AbstractStructBase
{
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The FramedVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The JourneyPatternName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyPatternName;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The RouteRef
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The GroupOfLinesRef
     * @var \StructType\GroupOfLinesRefStructure
     */
    public $GroupOfLinesRef;
    /**
     * The DirectionName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DirectionName;
    /**
     * The ExternalLineRef
     * @var \StructType\LineRefStructure
     */
    public $ExternalLineRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The OriginRef
     * @var \StructType\JourneyPlaceRefStructure
     */
    public $OriginRef;
    /**
     * The OriginName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginName;
    /**
     * The OriginShortName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginShortName;
    /**
     * The DestinationDisplayAtOrigin
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $DestinationDisplayAtOrigin;
    /**
     * The Via
     * @var \StructType\ViaNameStructure
     */
    public $Via;
    /**
     * The DestinationRef
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The DestinationName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationName;
    /**
     * The DestinationShortName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $DestinationShortName;
    /**
     * The OriginDisplayAtDestination
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginDisplayAtDestination;
    /**
     * The VehicleJourneyName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $VehicleJourneyName;
    /**
     * The JourneyNote
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyNote;
    /**
     * The PublicContact
     * @var \StructType\SimpleContactStructure
     */
    public $PublicContact;
    /**
     * The OperationsContact
     * @var \StructType\SimpleContactStructure
     */
    public $OperationsContact;
    /**
     * The HeadwayService
     * @var bool
     */
    public $HeadwayService;
    /**
     * The OriginAimedDepartureTime
     * @var string
     */
    public $OriginAimedDepartureTime;
    /**
     * The DestinationAimedArrivalTime
     * @var string
     */
    public $DestinationAimedArrivalTime;
    /**
     * The FirstOrLastJourney
     * @var string
     */
    public $FirstOrLastJourney;
    /**
     * The FacilityConditionElement
     * @var \StructType\FacilityConditionStructure
     */
    public $FacilityConditionElement;
    /**
     * The FacilityChangeElement
     * @var \StructType\FacilityChangeStructure
     */
    public $FacilityChangeElement;
    /**
     * The SituationRef
     * @var \StructType\SituationRefStructure
     */
    public $SituationRef;
    /**
     * The Monitored
     * @var bool
     */
    public $Monitored;
    /**
     * The MonitoringError
     * @var string
     */
    public $MonitoringError;
    /**
     * The InCongestion
     * @var bool
     */
    public $InCongestion;
    /**
     * The InPanic
     * @var bool
     */
    public $InPanic;
    /**
     * The PredictionInaccurate
     * @var bool
     */
    public $PredictionInaccurate;
    /**
     * The DataSource
     * @var string
     */
    public $DataSource;
    /**
     * The ConfidenceLevel
     * @var string
     */
    public $ConfidenceLevel;
    /**
     * The VehicleLocation
     * @var \StructType\LocationStructure
     */
    public $VehicleLocation;
    /**
     * The LocationRecordedAtTime
     * @var string
     */
    public $LocationRecordedAtTime;
    /**
     * The Bearing
     * Meta informations extracted from the WSDL
     * - documentation: Type for absolute bearing.
     * @var float
     */
    public $Bearing;
    /**
     * The ProgressRate
     * @var string
     */
    public $ProgressRate;
    /**
     * The Velocity
     * Meta informations extracted from the WSDL
     * - documentation: Distance (metres per second) ALternative unist may be specifed by context.
     * @var int
     */
    public $Velocity;
    /**
     * The EngineOn
     * @var bool
     */
    public $EngineOn;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * The Delay
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $Delay;
    /**
     * The ProgressStatus
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ProgressStatus;
    /**
     * The VehicleStatus
     * @var string
     */
    public $VehicleStatus;
    /**
     * The TrainBlockPart
     * @var \StructType\TrainBlockPartStructure
     */
    public $TrainBlockPart;
    /**
     * The BlockRef
     * @var \StructType\BlockRefStructure
     */
    public $BlockRef;
    /**
     * The CourseOfJourneyRef
     * @var \StructType\CourseOfJourneyRefStructure
     */
    public $CourseOfJourneyRef;
    /**
     * The VehicleJourneyRef
     * @var \StructType\VehicleJourneyRefStructure
     */
    public $VehicleJourneyRef;
    /**
     * The VehicleRef
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The AdditionalVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $AdditionalVehicleJourneyRef;
    /**
     * The DriverRef
     * @var string
     */
    public $DriverRef;
    /**
     * The DriverName
     * @var string
     */
    public $DriverName;
    /**
     * The TrainNumbers
     * @var \StructType\TrainNumbers
     */
    public $TrainNumbers;
    /**
     * The JourneyParts
     * @var \StructType\JourneyParts
     */
    public $JourneyParts;
    /**
     * The PreviousCalls
     * @var \StructType\PreviousCallsStructure
     */
    public $PreviousCalls;
    /**
     * The MonitoredCall
     * @var \StructType\MonitoredCallStructure
     */
    public $MonitoredCall;
    /**
     * The OnwardCalls
     * @var \StructType\OnwardCallsStructure
     */
    public $OnwardCalls;
    /**
     * The IsCompleteStopSequence
     * @var bool
     */
    public $IsCompleteStopSequence;
    /**
     * Constructor method for MonitoredVehicleJourneyStructure
     * @uses MonitoredVehicleJourneyStructure::setLineRef()
     * @uses MonitoredVehicleJourneyStructure::setDirectionRef()
     * @uses MonitoredVehicleJourneyStructure::setFramedVehicleJourneyRef()
     * @uses MonitoredVehicleJourneyStructure::setJourneyPatternRef()
     * @uses MonitoredVehicleJourneyStructure::setJourneyPatternName()
     * @uses MonitoredVehicleJourneyStructure::setVehicleMode()
     * @uses MonitoredVehicleJourneyStructure::setRouteRef()
     * @uses MonitoredVehicleJourneyStructure::setPublishedLineName()
     * @uses MonitoredVehicleJourneyStructure::setGroupOfLinesRef()
     * @uses MonitoredVehicleJourneyStructure::setDirectionName()
     * @uses MonitoredVehicleJourneyStructure::setExternalLineRef()
     * @uses MonitoredVehicleJourneyStructure::setOperatorRef()
     * @uses MonitoredVehicleJourneyStructure::setProductCategoryRef()
     * @uses MonitoredVehicleJourneyStructure::setServiceFeatureRef()
     * @uses MonitoredVehicleJourneyStructure::setVehicleFeatureRef()
     * @uses MonitoredVehicleJourneyStructure::setOriginRef()
     * @uses MonitoredVehicleJourneyStructure::setOriginName()
     * @uses MonitoredVehicleJourneyStructure::setOriginShortName()
     * @uses MonitoredVehicleJourneyStructure::setDestinationDisplayAtOrigin()
     * @uses MonitoredVehicleJourneyStructure::setVia()
     * @uses MonitoredVehicleJourneyStructure::setDestinationRef()
     * @uses MonitoredVehicleJourneyStructure::setDestinationName()
     * @uses MonitoredVehicleJourneyStructure::setDestinationShortName()
     * @uses MonitoredVehicleJourneyStructure::setOriginDisplayAtDestination()
     * @uses MonitoredVehicleJourneyStructure::setVehicleJourneyName()
     * @uses MonitoredVehicleJourneyStructure::setJourneyNote()
     * @uses MonitoredVehicleJourneyStructure::setPublicContact()
     * @uses MonitoredVehicleJourneyStructure::setOperationsContact()
     * @uses MonitoredVehicleJourneyStructure::setHeadwayService()
     * @uses MonitoredVehicleJourneyStructure::setOriginAimedDepartureTime()
     * @uses MonitoredVehicleJourneyStructure::setDestinationAimedArrivalTime()
     * @uses MonitoredVehicleJourneyStructure::setFirstOrLastJourney()
     * @uses MonitoredVehicleJourneyStructure::setFacilityConditionElement()
     * @uses MonitoredVehicleJourneyStructure::setFacilityChangeElement()
     * @uses MonitoredVehicleJourneyStructure::setSituationRef()
     * @uses MonitoredVehicleJourneyStructure::setMonitored()
     * @uses MonitoredVehicleJourneyStructure::setMonitoringError()
     * @uses MonitoredVehicleJourneyStructure::setInCongestion()
     * @uses MonitoredVehicleJourneyStructure::setInPanic()
     * @uses MonitoredVehicleJourneyStructure::setPredictionInaccurate()
     * @uses MonitoredVehicleJourneyStructure::setDataSource()
     * @uses MonitoredVehicleJourneyStructure::setConfidenceLevel()
     * @uses MonitoredVehicleJourneyStructure::setVehicleLocation()
     * @uses MonitoredVehicleJourneyStructure::setLocationRecordedAtTime()
     * @uses MonitoredVehicleJourneyStructure::setBearing()
     * @uses MonitoredVehicleJourneyStructure::setProgressRate()
     * @uses MonitoredVehicleJourneyStructure::setVelocity()
     * @uses MonitoredVehicleJourneyStructure::setEngineOn()
     * @uses MonitoredVehicleJourneyStructure::setOccupancy()
     * @uses MonitoredVehicleJourneyStructure::setDelay()
     * @uses MonitoredVehicleJourneyStructure::setProgressStatus()
     * @uses MonitoredVehicleJourneyStructure::setVehicleStatus()
     * @uses MonitoredVehicleJourneyStructure::setTrainBlockPart()
     * @uses MonitoredVehicleJourneyStructure::setBlockRef()
     * @uses MonitoredVehicleJourneyStructure::setCourseOfJourneyRef()
     * @uses MonitoredVehicleJourneyStructure::setVehicleJourneyRef()
     * @uses MonitoredVehicleJourneyStructure::setVehicleRef()
     * @uses MonitoredVehicleJourneyStructure::setAdditionalVehicleJourneyRef()
     * @uses MonitoredVehicleJourneyStructure::setDriverRef()
     * @uses MonitoredVehicleJourneyStructure::setDriverName()
     * @uses MonitoredVehicleJourneyStructure::setTrainNumbers()
     * @uses MonitoredVehicleJourneyStructure::setJourneyParts()
     * @uses MonitoredVehicleJourneyStructure::setPreviousCalls()
     * @uses MonitoredVehicleJourneyStructure::setMonitoredCall()
     * @uses MonitoredVehicleJourneyStructure::setOnwardCalls()
     * @uses MonitoredVehicleJourneyStructure::setIsCompleteStopSequence()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @param string $vehicleMode
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @param \StructType\LineRefStructure $externalLineRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param \StructType\JourneyPlaceRefStructure $originRef
     * @param \StructType\NaturalLanguagePlaceNameStructure $originName
     * @param \StructType\NaturalLanguagePlaceNameStructure $originShortName
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin
     * @param \StructType\ViaNameStructure $via
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param \StructType\NaturalLanguageStringStructure $destinationName
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationShortName
     * @param \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @param \StructType\SimpleContactStructure $publicContact
     * @param \StructType\SimpleContactStructure $operationsContact
     * @param bool $headwayService
     * @param string $originAimedDepartureTime
     * @param string $destinationAimedArrivalTime
     * @param string $firstOrLastJourney
     * @param \StructType\FacilityConditionStructure $facilityConditionElement
     * @param \StructType\FacilityChangeStructure $facilityChangeElement
     * @param \StructType\SituationRefStructure $situationRef
     * @param bool $monitored
     * @param string $monitoringError
     * @param bool $inCongestion
     * @param bool $inPanic
     * @param bool $predictionInaccurate
     * @param string $dataSource
     * @param string $confidenceLevel
     * @param \StructType\LocationStructure $vehicleLocation
     * @param string $locationRecordedAtTime
     * @param float $bearing
     * @param string $progressRate
     * @param int $velocity
     * @param bool $engineOn
     * @param string $occupancy
     * @param string $delay
     * @param \StructType\NaturalLanguageStringStructure $progressStatus
     * @param string $vehicleStatus
     * @param \StructType\TrainBlockPartStructure $trainBlockPart
     * @param \StructType\BlockRefStructure $blockRef
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param \StructType\FramedVehicleJourneyRefStructure $additionalVehicleJourneyRef
     * @param string $driverRef
     * @param string $driverName
     * @param \StructType\TrainNumbers $trainNumbers
     * @param \StructType\JourneyParts $journeyParts
     * @param \StructType\PreviousCallsStructure $previousCalls
     * @param \StructType\MonitoredCallStructure $monitoredCall
     * @param \StructType\OnwardCallsStructure $onwardCalls
     * @param bool $isCompleteStopSequence
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\JourneyPatternRefStructure $journeyPatternRef = null, \StructType\NaturalLanguageStringStructure $journeyPatternName = null, $vehicleMode = null, \StructType\RouteRefStructure $routeRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\GroupOfLinesRefStructure $groupOfLinesRef = null, \StructType\NaturalLanguageStringStructure $directionName = null, \StructType\LineRefStructure $externalLineRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, \StructType\JourneyPlaceRefStructure $originRef = null, \StructType\NaturalLanguagePlaceNameStructure $originName = null, \StructType\NaturalLanguagePlaceNameStructure $originShortName = null, \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin = null, \StructType\ViaNameStructure $via = null, \StructType\DestinationRefStructure $destinationRef = null, \StructType\NaturalLanguageStringStructure $destinationName = null, \StructType\NaturalLanguagePlaceNameStructure $destinationShortName = null, \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination = null, \StructType\NaturalLanguageStringStructure $vehicleJourneyName = null, \StructType\NaturalLanguageStringStructure $journeyNote = null, \StructType\SimpleContactStructure $publicContact = null, \StructType\SimpleContactStructure $operationsContact = null, $headwayService = null, $originAimedDepartureTime = null, $destinationAimedArrivalTime = null, $firstOrLastJourney = null, \StructType\FacilityConditionStructure $facilityConditionElement = null, \StructType\FacilityChangeStructure $facilityChangeElement = null, \StructType\SituationRefStructure $situationRef = null, $monitored = null, $monitoringError = null, $inCongestion = null, $inPanic = null, $predictionInaccurate = null, $dataSource = null, $confidenceLevel = null, \StructType\LocationStructure $vehicleLocation = null, $locationRecordedAtTime = null, $bearing = null, $progressRate = null, $velocity = null, $engineOn = null, $occupancy = null, $delay = null, \StructType\NaturalLanguageStringStructure $progressStatus = null, $vehicleStatus = null, \StructType\TrainBlockPartStructure $trainBlockPart = null, \StructType\BlockRefStructure $blockRef = null, \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null, \StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null, \StructType\VehicleRefStructure $vehicleRef = null, \StructType\FramedVehicleJourneyRefStructure $additionalVehicleJourneyRef = null, $driverRef = null, $driverName = null, \StructType\TrainNumbers $trainNumbers = null, \StructType\JourneyParts $journeyParts = null, \StructType\PreviousCallsStructure $previousCalls = null, \StructType\MonitoredCallStructure $monitoredCall = null, \StructType\OnwardCallsStructure $onwardCalls = null, $isCompleteStopSequence = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setJourneyPatternRef($journeyPatternRef)
            ->setJourneyPatternName($journeyPatternName)
            ->setVehicleMode($vehicleMode)
            ->setRouteRef($routeRef)
            ->setPublishedLineName($publishedLineName)
            ->setGroupOfLinesRef($groupOfLinesRef)
            ->setDirectionName($directionName)
            ->setExternalLineRef($externalLineRef)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setOriginRef($originRef)
            ->setOriginName($originName)
            ->setOriginShortName($originShortName)
            ->setDestinationDisplayAtOrigin($destinationDisplayAtOrigin)
            ->setVia($via)
            ->setDestinationRef($destinationRef)
            ->setDestinationName($destinationName)
            ->setDestinationShortName($destinationShortName)
            ->setOriginDisplayAtDestination($originDisplayAtDestination)
            ->setVehicleJourneyName($vehicleJourneyName)
            ->setJourneyNote($journeyNote)
            ->setPublicContact($publicContact)
            ->setOperationsContact($operationsContact)
            ->setHeadwayService($headwayService)
            ->setOriginAimedDepartureTime($originAimedDepartureTime)
            ->setDestinationAimedArrivalTime($destinationAimedArrivalTime)
            ->setFirstOrLastJourney($firstOrLastJourney)
            ->setFacilityConditionElement($facilityConditionElement)
            ->setFacilityChangeElement($facilityChangeElement)
            ->setSituationRef($situationRef)
            ->setMonitored($monitored)
            ->setMonitoringError($monitoringError)
            ->setInCongestion($inCongestion)
            ->setInPanic($inPanic)
            ->setPredictionInaccurate($predictionInaccurate)
            ->setDataSource($dataSource)
            ->setConfidenceLevel($confidenceLevel)
            ->setVehicleLocation($vehicleLocation)
            ->setLocationRecordedAtTime($locationRecordedAtTime)
            ->setBearing($bearing)
            ->setProgressRate($progressRate)
            ->setVelocity($velocity)
            ->setEngineOn($engineOn)
            ->setOccupancy($occupancy)
            ->setDelay($delay)
            ->setProgressStatus($progressStatus)
            ->setVehicleStatus($vehicleStatus)
            ->setTrainBlockPart($trainBlockPart)
            ->setBlockRef($blockRef)
            ->setCourseOfJourneyRef($courseOfJourneyRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setVehicleRef($vehicleRef)
            ->setAdditionalVehicleJourneyRef($additionalVehicleJourneyRef)
            ->setDriverRef($driverRef)
            ->setDriverName($driverName)
            ->setTrainNumbers($trainNumbers)
            ->setJourneyParts($journeyParts)
            ->setPreviousCalls($previousCalls)
            ->setMonitoredCall($monitoredCall)
            ->setOnwardCalls($onwardCalls)
            ->setIsCompleteStopSequence($isCompleteStopSequence);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get JourneyPatternName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyPatternName()
    {
        return $this->JourneyPatternName;
    }
    /**
     * Set JourneyPatternName value
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setJourneyPatternName(\StructType\NaturalLanguageStringStructure $journeyPatternName = null)
    {
        $this->JourneyPatternName = $journeyPatternName;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get GroupOfLinesRef value
     * @return \StructType\GroupOfLinesRefStructure|null
     */
    public function getGroupOfLinesRef()
    {
        return $this->GroupOfLinesRef;
    }
    /**
     * Set GroupOfLinesRef value
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setGroupOfLinesRef(\StructType\GroupOfLinesRefStructure $groupOfLinesRef = null)
    {
        $this->GroupOfLinesRef = $groupOfLinesRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDirectionName(\StructType\NaturalLanguageStringStructure $directionName = null)
    {
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Get ExternalLineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getExternalLineRef()
    {
        return $this->ExternalLineRef;
    }
    /**
     * Set ExternalLineRef value
     * @param \StructType\LineRefStructure $externalLineRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setExternalLineRef(\StructType\LineRefStructure $externalLineRef = null)
    {
        $this->ExternalLineRef = $externalLineRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get OriginRef value
     * @return \StructType\JourneyPlaceRefStructure|null
     */
    public function getOriginRef()
    {
        return $this->OriginRef;
    }
    /**
     * Set OriginRef value
     * @param \StructType\JourneyPlaceRefStructure $originRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOriginRef(\StructType\JourneyPlaceRefStructure $originRef = null)
    {
        $this->OriginRef = $originRef;
        return $this;
    }
    /**
     * Get OriginName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOriginName(\StructType\NaturalLanguagePlaceNameStructure $originName = null)
    {
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get OriginShortName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginShortName()
    {
        return $this->OriginShortName;
    }
    /**
     * Set OriginShortName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originShortName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOriginShortName(\StructType\NaturalLanguagePlaceNameStructure $originShortName = null)
    {
        $this->OriginShortName = $originShortName;
        return $this;
    }
    /**
     * Get DestinationDisplayAtOrigin value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getDestinationDisplayAtOrigin()
    {
        return $this->DestinationDisplayAtOrigin;
    }
    /**
     * Set DestinationDisplayAtOrigin value
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDestinationDisplayAtOrigin(\StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin = null)
    {
        $this->DestinationDisplayAtOrigin = $destinationDisplayAtOrigin;
        return $this;
    }
    /**
     * Get Via value
     * @return \StructType\ViaNameStructure|null
     */
    public function getVia()
    {
        return $this->Via;
    }
    /**
     * Set Via value
     * @param \StructType\ViaNameStructure $via
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVia(\StructType\ViaNameStructure $via = null)
    {
        $this->Via = $via;
        return $this;
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param \StructType\NaturalLanguageStringStructure $destinationName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDestinationName(\StructType\NaturalLanguageStringStructure $destinationName = null)
    {
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get DestinationShortName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getDestinationShortName()
    {
        return $this->DestinationShortName;
    }
    /**
     * Set DestinationShortName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationShortName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDestinationShortName(\StructType\NaturalLanguagePlaceNameStructure $destinationShortName = null)
    {
        $this->DestinationShortName = $destinationShortName;
        return $this;
    }
    /**
     * Get OriginDisplayAtDestination value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginDisplayAtDestination()
    {
        return $this->OriginDisplayAtDestination;
    }
    /**
     * Set OriginDisplayAtDestination value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOriginDisplayAtDestination(\StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination = null)
    {
        $this->OriginDisplayAtDestination = $originDisplayAtDestination;
        return $this;
    }
    /**
     * Get VehicleJourneyName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getVehicleJourneyName()
    {
        return $this->VehicleJourneyName;
    }
    /**
     * Set VehicleJourneyName value
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleJourneyName(\StructType\NaturalLanguageStringStructure $vehicleJourneyName = null)
    {
        $this->VehicleJourneyName = $vehicleJourneyName;
        return $this;
    }
    /**
     * Get JourneyNote value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyNote()
    {
        return $this->JourneyNote;
    }
    /**
     * Set JourneyNote value
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setJourneyNote(\StructType\NaturalLanguageStringStructure $journeyNote = null)
    {
        $this->JourneyNote = $journeyNote;
        return $this;
    }
    /**
     * Get PublicContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getPublicContact()
    {
        return $this->PublicContact;
    }
    /**
     * Set PublicContact value
     * @param \StructType\SimpleContactStructure $publicContact
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setPublicContact(\StructType\SimpleContactStructure $publicContact = null)
    {
        $this->PublicContact = $publicContact;
        return $this;
    }
    /**
     * Get OperationsContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getOperationsContact()
    {
        return $this->OperationsContact;
    }
    /**
     * Set OperationsContact value
     * @param \StructType\SimpleContactStructure $operationsContact
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOperationsContact(\StructType\SimpleContactStructure $operationsContact = null)
    {
        $this->OperationsContact = $operationsContact;
        return $this;
    }
    /**
     * Get HeadwayService value
     * @return bool|null
     */
    public function getHeadwayService()
    {
        return $this->HeadwayService;
    }
    /**
     * Set HeadwayService value
     * @param bool $headwayService
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setHeadwayService($headwayService = null)
    {
        // validation for constraint: boolean
        if (!is_null($headwayService) && !is_bool($headwayService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($headwayService)), __LINE__);
        }
        $this->HeadwayService = $headwayService;
        return $this;
    }
    /**
     * Get OriginAimedDepartureTime value
     * @return string|null
     */
    public function getOriginAimedDepartureTime()
    {
        return $this->OriginAimedDepartureTime;
    }
    /**
     * Set OriginAimedDepartureTime value
     * @param string $originAimedDepartureTime
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOriginAimedDepartureTime($originAimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($originAimedDepartureTime) && !is_string($originAimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originAimedDepartureTime)), __LINE__);
        }
        $this->OriginAimedDepartureTime = $originAimedDepartureTime;
        return $this;
    }
    /**
     * Get DestinationAimedArrivalTime value
     * @return string|null
     */
    public function getDestinationAimedArrivalTime()
    {
        return $this->DestinationAimedArrivalTime;
    }
    /**
     * Set DestinationAimedArrivalTime value
     * @param string $destinationAimedArrivalTime
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDestinationAimedArrivalTime($destinationAimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAimedArrivalTime) && !is_string($destinationAimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAimedArrivalTime)), __LINE__);
        }
        $this->DestinationAimedArrivalTime = $destinationAimedArrivalTime;
        return $this;
    }
    /**
     * Get FirstOrLastJourney value
     * @return string|null
     */
    public function getFirstOrLastJourney()
    {
        return $this->FirstOrLastJourney;
    }
    /**
     * Set FirstOrLastJourney value
     * @uses \EnumType\FirstOrLastJourneyEnumeration::valueIsValid()
     * @uses \EnumType\FirstOrLastJourneyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstOrLastJourney
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setFirstOrLastJourney($firstOrLastJourney = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FirstOrLastJourneyEnumeration::valueIsValid($firstOrLastJourney)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstOrLastJourney, implode(', ', \EnumType\FirstOrLastJourneyEnumeration::getValidValues())), __LINE__);
        }
        $this->FirstOrLastJourney = $firstOrLastJourney;
        return $this;
    }
    /**
     * Get FacilityConditionElement value
     * @return \StructType\FacilityConditionStructure|null
     */
    public function getFacilityConditionElement()
    {
        return $this->FacilityConditionElement;
    }
    /**
     * Set FacilityConditionElement value
     * @param \StructType\FacilityConditionStructure $facilityConditionElement
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setFacilityConditionElement(\StructType\FacilityConditionStructure $facilityConditionElement = null)
    {
        $this->FacilityConditionElement = $facilityConditionElement;
        return $this;
    }
    /**
     * Get FacilityChangeElement value
     * @return \StructType\FacilityChangeStructure|null
     */
    public function getFacilityChangeElement()
    {
        return $this->FacilityChangeElement;
    }
    /**
     * Set FacilityChangeElement value
     * @param \StructType\FacilityChangeStructure $facilityChangeElement
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setFacilityChangeElement(\StructType\FacilityChangeStructure $facilityChangeElement = null)
    {
        $this->FacilityChangeElement = $facilityChangeElement;
        return $this;
    }
    /**
     * Get SituationRef value
     * @return \StructType\SituationRefStructure|null
     */
    public function getSituationRef()
    {
        return $this->SituationRef;
    }
    /**
     * Set SituationRef value
     * @param \StructType\SituationRefStructure $situationRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setSituationRef(\StructType\SituationRefStructure $situationRef = null)
    {
        $this->SituationRef = $situationRef;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setMonitored($monitored = null)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get MonitoringError value
     * @return string|null
     */
    public function getMonitoringError()
    {
        return $this->MonitoringError;
    }
    /**
     * Set MonitoringError value
     * @param string $monitoringError
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setMonitoringError($monitoringError = null)
    {
        // validation for constraint: string
        if (!is_null($monitoringError) && !is_string($monitoringError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monitoringError)), __LINE__);
        }
        $this->MonitoringError = $monitoringError;
        return $this;
    }
    /**
     * Get InCongestion value
     * @return bool|null
     */
    public function getInCongestion()
    {
        return $this->InCongestion;
    }
    /**
     * Set InCongestion value
     * @param bool $inCongestion
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setInCongestion($inCongestion = null)
    {
        // validation for constraint: boolean
        if (!is_null($inCongestion) && !is_bool($inCongestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inCongestion)), __LINE__);
        }
        $this->InCongestion = $inCongestion;
        return $this;
    }
    /**
     * Get InPanic value
     * @return bool|null
     */
    public function getInPanic()
    {
        return $this->InPanic;
    }
    /**
     * Set InPanic value
     * @param bool $inPanic
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setInPanic($inPanic = null)
    {
        // validation for constraint: boolean
        if (!is_null($inPanic) && !is_bool($inPanic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inPanic)), __LINE__);
        }
        $this->InPanic = $inPanic;
        return $this;
    }
    /**
     * Get PredictionInaccurate value
     * @return bool|null
     */
    public function getPredictionInaccurate()
    {
        return $this->PredictionInaccurate;
    }
    /**
     * Set PredictionInaccurate value
     * @param bool $predictionInaccurate
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setPredictionInaccurate($predictionInaccurate = null)
    {
        // validation for constraint: boolean
        if (!is_null($predictionInaccurate) && !is_bool($predictionInaccurate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($predictionInaccurate)), __LINE__);
        }
        $this->PredictionInaccurate = $predictionInaccurate;
        return $this;
    }
    /**
     * Get DataSource value
     * @return string|null
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @param string $dataSource
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: string
        if (!is_null($dataSource) && !is_string($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataSource)), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get ConfidenceLevel value
     * @return string|null
     */
    public function getConfidenceLevel()
    {
        return $this->ConfidenceLevel;
    }
    /**
     * Set ConfidenceLevel value
     * @uses \EnumType\QualityIndexEnumeration::valueIsValid()
     * @uses \EnumType\QualityIndexEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidenceLevel
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setConfidenceLevel($confidenceLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QualityIndexEnumeration::valueIsValid($confidenceLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidenceLevel, implode(', ', \EnumType\QualityIndexEnumeration::getValidValues())), __LINE__);
        }
        $this->ConfidenceLevel = $confidenceLevel;
        return $this;
    }
    /**
     * Get VehicleLocation value
     * @return \StructType\LocationStructure|null
     */
    public function getVehicleLocation()
    {
        return $this->VehicleLocation;
    }
    /**
     * Set VehicleLocation value
     * @param \StructType\LocationStructure $vehicleLocation
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleLocation(\StructType\LocationStructure $vehicleLocation = null)
    {
        $this->VehicleLocation = $vehicleLocation;
        return $this;
    }
    /**
     * Get LocationRecordedAtTime value
     * @return string|null
     */
    public function getLocationRecordedAtTime()
    {
        return $this->LocationRecordedAtTime;
    }
    /**
     * Set LocationRecordedAtTime value
     * @param string $locationRecordedAtTime
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setLocationRecordedAtTime($locationRecordedAtTime = null)
    {
        // validation for constraint: string
        if (!is_null($locationRecordedAtTime) && !is_string($locationRecordedAtTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationRecordedAtTime)), __LINE__);
        }
        $this->LocationRecordedAtTime = $locationRecordedAtTime;
        return $this;
    }
    /**
     * Get Bearing value
     * @return float|null
     */
    public function getBearing()
    {
        return $this->Bearing;
    }
    /**
     * Set Bearing value
     * @param float $bearing
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setBearing($bearing = null)
    {
        $this->Bearing = $bearing;
        return $this;
    }
    /**
     * Get ProgressRate value
     * @return string|null
     */
    public function getProgressRate()
    {
        return $this->ProgressRate;
    }
    /**
     * Set ProgressRate value
     * @uses \EnumType\ProgressRateEnumeration::valueIsValid()
     * @uses \EnumType\ProgressRateEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $progressRate
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setProgressRate($progressRate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProgressRateEnumeration::valueIsValid($progressRate)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $progressRate, implode(', ', \EnumType\ProgressRateEnumeration::getValidValues())), __LINE__);
        }
        $this->ProgressRate = $progressRate;
        return $this;
    }
    /**
     * Get Velocity value
     * @return int|null
     */
    public function getVelocity()
    {
        return $this->Velocity;
    }
    /**
     * Set Velocity value
     * @param int $velocity
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVelocity($velocity = null)
    {
        // validation for constraint: int
        if (!is_null($velocity) && !is_numeric($velocity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($velocity)), __LINE__);
        }
        $this->Velocity = $velocity;
        return $this;
    }
    /**
     * Get EngineOn value
     * @return bool|null
     */
    public function getEngineOn()
    {
        return $this->EngineOn;
    }
    /**
     * Set EngineOn value
     * @param bool $engineOn
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setEngineOn($engineOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($engineOn) && !is_bool($engineOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($engineOn)), __LINE__);
        }
        $this->EngineOn = $engineOn;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @uses \EnumType\OccupancyEnumeration::valueIsValid()
     * @uses \EnumType\OccupancyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancy
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OccupancyEnumeration::valueIsValid($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $occupancy, implode(', ', \EnumType\OccupancyEnumeration::getValidValues())), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get Delay value
     * @return string|null
     */
    public function getDelay()
    {
        return $this->Delay;
    }
    /**
     * Set Delay value
     * @param string $delay
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDelay($delay = null)
    {
        // validation for constraint: string
        if (!is_null($delay) && !is_string($delay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delay)), __LINE__);
        }
        $this->Delay = $delay;
        return $this;
    }
    /**
     * Get ProgressStatus value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getProgressStatus()
    {
        return $this->ProgressStatus;
    }
    /**
     * Set ProgressStatus value
     * @param \StructType\NaturalLanguageStringStructure $progressStatus
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setProgressStatus(\StructType\NaturalLanguageStringStructure $progressStatus = null)
    {
        $this->ProgressStatus = $progressStatus;
        return $this;
    }
    /**
     * Get VehicleStatus value
     * @return string|null
     */
    public function getVehicleStatus()
    {
        return $this->VehicleStatus;
    }
    /**
     * Set VehicleStatus value
     * @uses \EnumType\VehicleStatusEnumeration::valueIsValid()
     * @uses \EnumType\VehicleStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleStatus
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleStatus($vehicleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleStatusEnumeration::valueIsValid($vehicleStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleStatus, implode(', ', \EnumType\VehicleStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleStatus = $vehicleStatus;
        return $this;
    }
    /**
     * Get TrainBlockPart value
     * @return \StructType\TrainBlockPartStructure|null
     */
    public function getTrainBlockPart()
    {
        return $this->TrainBlockPart;
    }
    /**
     * Set TrainBlockPart value
     * @param \StructType\TrainBlockPartStructure $trainBlockPart
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setTrainBlockPart(\StructType\TrainBlockPartStructure $trainBlockPart = null)
    {
        $this->TrainBlockPart = $trainBlockPart;
        return $this;
    }
    /**
     * Get BlockRef value
     * @return \StructType\BlockRefStructure|null
     */
    public function getBlockRef()
    {
        return $this->BlockRef;
    }
    /**
     * Set BlockRef value
     * @param \StructType\BlockRefStructure $blockRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setBlockRef(\StructType\BlockRefStructure $blockRef = null)
    {
        $this->BlockRef = $blockRef;
        return $this;
    }
    /**
     * Get CourseOfJourneyRef value
     * @return \StructType\CourseOfJourneyRefStructure|null
     */
    public function getCourseOfJourneyRef()
    {
        return $this->CourseOfJourneyRef;
    }
    /**
     * Set CourseOfJourneyRef value
     * @param \StructType\CourseOfJourneyRefStructure $courseOfJourneyRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setCourseOfJourneyRef(\StructType\CourseOfJourneyRefStructure $courseOfJourneyRef = null)
    {
        $this->CourseOfJourneyRef = $courseOfJourneyRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\VehicleJourneyRefStructure|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleJourneyRef(\StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null)
    {
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get AdditionalVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getAdditionalVehicleJourneyRef()
    {
        return $this->AdditionalVehicleJourneyRef;
    }
    /**
     * Set AdditionalVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $additionalVehicleJourneyRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setAdditionalVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $additionalVehicleJourneyRef = null)
    {
        $this->AdditionalVehicleJourneyRef = $additionalVehicleJourneyRef;
        return $this;
    }
    /**
     * Get DriverRef value
     * @return string|null
     */
    public function getDriverRef()
    {
        return $this->DriverRef;
    }
    /**
     * Set DriverRef value
     * @param string $driverRef
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDriverRef($driverRef = null)
    {
        // validation for constraint: string
        if (!is_null($driverRef) && !is_string($driverRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverRef)), __LINE__);
        }
        $this->DriverRef = $driverRef;
        return $this;
    }
    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }
    /**
     * Set DriverName value
     * @param string $driverName
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }
    /**
     * Get TrainNumbers value
     * @return \StructType\TrainNumbers|null
     */
    public function getTrainNumbers()
    {
        return $this->TrainNumbers;
    }
    /**
     * Set TrainNumbers value
     * @param \StructType\TrainNumbers $trainNumbers
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setTrainNumbers(\StructType\TrainNumbers $trainNumbers = null)
    {
        $this->TrainNumbers = $trainNumbers;
        return $this;
    }
    /**
     * Get JourneyParts value
     * @return \StructType\JourneyParts|null
     */
    public function getJourneyParts()
    {
        return $this->JourneyParts;
    }
    /**
     * Set JourneyParts value
     * @param \StructType\JourneyParts $journeyParts
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setJourneyParts(\StructType\JourneyParts $journeyParts = null)
    {
        $this->JourneyParts = $journeyParts;
        return $this;
    }
    /**
     * Get PreviousCalls value
     * @return \StructType\PreviousCallsStructure|null
     */
    public function getPreviousCalls()
    {
        return $this->PreviousCalls;
    }
    /**
     * Set PreviousCalls value
     * @param \StructType\PreviousCallsStructure $previousCalls
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setPreviousCalls(\StructType\PreviousCallsStructure $previousCalls = null)
    {
        $this->PreviousCalls = $previousCalls;
        return $this;
    }
    /**
     * Get MonitoredCall value
     * @return \StructType\MonitoredCallStructure|null
     */
    public function getMonitoredCall()
    {
        return $this->MonitoredCall;
    }
    /**
     * Set MonitoredCall value
     * @param \StructType\MonitoredCallStructure $monitoredCall
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setMonitoredCall(\StructType\MonitoredCallStructure $monitoredCall = null)
    {
        $this->MonitoredCall = $monitoredCall;
        return $this;
    }
    /**
     * Get OnwardCalls value
     * @return \StructType\OnwardCallsStructure|null
     */
    public function getOnwardCalls()
    {
        return $this->OnwardCalls;
    }
    /**
     * Set OnwardCalls value
     * @param \StructType\OnwardCallsStructure $onwardCalls
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setOnwardCalls(\StructType\OnwardCallsStructure $onwardCalls = null)
    {
        $this->OnwardCalls = $onwardCalls;
        return $this;
    }
    /**
     * Get IsCompleteStopSequence value
     * @return bool|null
     */
    public function getIsCompleteStopSequence()
    {
        return $this->IsCompleteStopSequence;
    }
    /**
     * Set IsCompleteStopSequence value
     * @param bool $isCompleteStopSequence
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public function setIsCompleteStopSequence($isCompleteStopSequence = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompleteStopSequence) && !is_bool($isCompleteStopSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCompleteStopSequence)), __LINE__);
        }
        $this->IsCompleteStopSequence = $isCompleteStopSequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoredVehicleJourneyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
