<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonitoredStopVisitStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Visit of a VEHICLE to a stop monitoring point. May provide information about the arrival, the departure or both.
 * @subpackage Structs
 */
class MonitoredStopVisitStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The ValidUntilTime
     * Meta informations extracted from the WSDL
     * - documentation: Time until when data is valid. +SIRI 2.0
     * - minOccurs: 0
     * @var string
     */
    public $ValidUntilTime;
    /**
     * The MonitoringRef
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The ClearDownRef
     * @var \StructType\ClearDownRefStructure
     */
    public $ClearDownRef;
    /**
     * The MonitoredVehicleJourney
     * Meta informations extracted from the WSDL
     * - documentation: Provides real-time information about the VEHICLE JOURNEY along which a VEHICLE is running.
     * @var \StructType\MonitoredVehicleJourneyStructure
     */
    public $MonitoredVehicleJourney;
    /**
     * The StopVisitNote
     * Meta informations extracted from the WSDL
     * - documentation: Text associated with Stop Visit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $StopVisitNote;
    /**
     * The StopFacility
     * Meta informations extracted from the WSDL
     * - documentation: Facility associated with stop visit
     * - minOccurs: 0
     * @var \StructType\FacilityRefStructure
     */
    public $StopFacility;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for MonitoredStopVisitStructure
     * @uses MonitoredStopVisitStructure::setValidUntilTime()
     * @uses MonitoredStopVisitStructure::setMonitoringRef()
     * @uses MonitoredStopVisitStructure::setClearDownRef()
     * @uses MonitoredStopVisitStructure::setMonitoredVehicleJourney()
     * @uses MonitoredStopVisitStructure::setStopVisitNote()
     * @uses MonitoredStopVisitStructure::setStopFacility()
     * @uses MonitoredStopVisitStructure::setExtensions()
     * @param string $validUntilTime
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\ClearDownRefStructure $clearDownRef
     * @param \StructType\MonitoredVehicleJourneyStructure $monitoredVehicleJourney
     * @param \StructType\NaturalLanguageStringStructure[] $stopVisitNote
     * @param \StructType\FacilityRefStructure $stopFacility
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($validUntilTime = null, \StructType\MonitoringRefStructure $monitoringRef = null, \StructType\ClearDownRefStructure $clearDownRef = null, \StructType\MonitoredVehicleJourneyStructure $monitoredVehicleJourney = null, array $stopVisitNote = array(), \StructType\FacilityRefStructure $stopFacility = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setValidUntilTime($validUntilTime)
            ->setMonitoringRef($monitoringRef)
            ->setClearDownRef($clearDownRef)
            ->setMonitoredVehicleJourney($monitoredVehicleJourney)
            ->setStopVisitNote($stopVisitNote)
            ->setStopFacility($stopFacility)
            ->setExtensions($extensions);
    }
    /**
     * Get ValidUntilTime value
     * @return string|null
     */
    public function getValidUntilTime()
    {
        return $this->ValidUntilTime;
    }
    /**
     * Set ValidUntilTime value
     * @param string $validUntilTime
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setValidUntilTime($validUntilTime = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilTime) && !is_string($validUntilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntilTime)), __LINE__);
        }
        $this->ValidUntilTime = $validUntilTime;
        return $this;
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get ClearDownRef value
     * @return \StructType\ClearDownRefStructure|null
     */
    public function getClearDownRef()
    {
        return $this->ClearDownRef;
    }
    /**
     * Set ClearDownRef value
     * @param \StructType\ClearDownRefStructure $clearDownRef
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setClearDownRef(\StructType\ClearDownRefStructure $clearDownRef = null)
    {
        $this->ClearDownRef = $clearDownRef;
        return $this;
    }
    /**
     * Get MonitoredVehicleJourney value
     * @return \StructType\MonitoredVehicleJourneyStructure|null
     */
    public function getMonitoredVehicleJourney()
    {
        return $this->MonitoredVehicleJourney;
    }
    /**
     * Set MonitoredVehicleJourney value
     * @param \StructType\MonitoredVehicleJourneyStructure $monitoredVehicleJourney
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setMonitoredVehicleJourney(\StructType\MonitoredVehicleJourneyStructure $monitoredVehicleJourney = null)
    {
        $this->MonitoredVehicleJourney = $monitoredVehicleJourney;
        return $this;
    }
    /**
     * Get StopVisitNote value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getStopVisitNote()
    {
        return $this->StopVisitNote;
    }
    /**
     * Set StopVisitNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $stopVisitNote
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setStopVisitNote(array $stopVisitNote = array())
    {
        foreach ($stopVisitNote as $monitoredStopVisitStructureStopVisitNoteItem) {
            // validation for constraint: itemType
            if (!$monitoredStopVisitStructureStopVisitNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The StopVisitNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($monitoredStopVisitStructureStopVisitNoteItem) ? get_class($monitoredStopVisitStructureStopVisitNoteItem) : gettype($monitoredStopVisitStructureStopVisitNoteItem)), __LINE__);
            }
        }
        $this->StopVisitNote = $stopVisitNote;
        return $this;
    }
    /**
     * Add item to StopVisitNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function addToStopVisitNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The StopVisitNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopVisitNote[] = $item;
        return $this;
    }
    /**
     * Get StopFacility value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getStopFacility()
    {
        return $this->StopFacility;
    }
    /**
     * Set StopFacility value
     * @param \StructType\FacilityRefStructure $stopFacility
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setStopFacility(\StructType\FacilityRefStructure $stopFacility = null)
    {
        $this->StopFacility = $stopFacility;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\MonitoredStopVisitStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MonitoredStopVisitStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
