<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Transport MODEs.
 * @subpackage Structs
 */
class ModesStructure extends AbstractStructBase
{
    /**
     * The Mode
     * Meta informations extracted from the WSDL
     * - documentation: A method of transportation such as bus, rail, etc.
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Mode;
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: if true, listed modes to be excluded from list.
     * - use: optional
     * @var bool
     */
    public $Exclude;
    /**
     * Constructor method for ModesStructure
     * @uses ModesStructure::setMode()
     * @uses ModesStructure::setExclude()
     * @param string[] $mode
     * @param bool $exclude
     */
    public function __construct(array $mode = array(), $exclude = false)
    {
        $this
            ->setMode($mode)
            ->setExclude($exclude);
    }
    /**
     * Get Mode value
     * @return string[]|null
     */
    public function getMode()
    {
        return $this->Mode;
    }
    /**
     * Set Mode value
     * @uses \EnumType\AllModesEnumeration::valueIsValid()
     * @uses \EnumType\AllModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $mode
     * @return \StructType\ModesStructure
     */
    public function setMode(array $mode = array())
    {
        $invalidValues = array();
        foreach ($mode as $modesStructureModeItem) {
            if (!\EnumType\AllModesEnumeration::valueIsValid($modesStructureModeItem)) {
                $invalidValues[] = var_export($modesStructureModeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AllModesEnumeration::getValidValues())), __LINE__);
        }
        $this->Mode = $mode;
        return $this;
    }
    /**
     * Add item to Mode value
     * @uses \EnumType\AllModesEnumeration::valueIsValid()
     * @uses \EnumType\AllModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ModesStructure
     */
    public function addToMode($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AllModesEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AllModesEnumeration::getValidValues())), __LINE__);
        }
        $this->Mode[] = $item;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \StructType\ModesStructure
     */
    public function setExclude($exclude = false)
    {
        // validation for constraint: boolean
        if (!is_null($exclude) && !is_bool($exclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exclude)), __LINE__);
        }
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
