<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mobility StructType
 * @subpackage Structs
 */
class Mobility extends AbstractStructBase
{
    /**
     * The mobilityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mobilityType;
    /**
     * The mobilityExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $mobilityExtension;
    /**
     * Constructor method for Mobility
     * @uses Mobility::setMobilityType()
     * @uses Mobility::setMobilityExtension()
     * @param string $mobilityType
     * @param \StructType\ExtensionType $mobilityExtension
     */
    public function __construct($mobilityType = null, \StructType\ExtensionType $mobilityExtension = null)
    {
        $this
            ->setMobilityType($mobilityType)
            ->setMobilityExtension($mobilityExtension);
    }
    /**
     * Get mobilityType value
     * @return string
     */
    public function getMobilityType()
    {
        return $this->mobilityType;
    }
    /**
     * Set mobilityType value
     * @uses \EnumType\MobilityEnum::valueIsValid()
     * @uses \EnumType\MobilityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobilityType
     * @return \StructType\Mobility
     */
    public function setMobilityType($mobilityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MobilityEnum::valueIsValid($mobilityType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobilityType, implode(', ', \EnumType\MobilityEnum::getValidValues())), __LINE__);
        }
        $this->mobilityType = $mobilityType;
        return $this;
    }
    /**
     * Get mobilityExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMobilityExtension()
    {
        return $this->mobilityExtension;
    }
    /**
     * Set mobilityExtension value
     * @param \StructType\ExtensionType $mobilityExtension
     * @return \StructType\Mobility
     */
    public function setMobilityExtension(\StructType\ExtensionType $mobilityExtension = null)
    {
        $this->mobilityExtension = $mobilityExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mobility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
