<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeasurementSiteTablePublication StructType
 * @subpackage Structs
 */
class MeasurementSiteTablePublication extends PayloadPublication
{
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The measurementSiteTable
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MeasurementSiteTable[]
     */
    public $measurementSiteTable;
    /**
     * The measurementSiteTablePublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $measurementSiteTablePublicationExtension;
    /**
     * Constructor method for MeasurementSiteTablePublication
     * @uses MeasurementSiteTablePublication::setHeaderInformation()
     * @uses MeasurementSiteTablePublication::setMeasurementSiteTable()
     * @uses MeasurementSiteTablePublication::setMeasurementSiteTablePublicationExtension()
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\MeasurementSiteTable[] $measurementSiteTable
     * @param \StructType\ExtensionType $measurementSiteTablePublicationExtension
     */
    public function __construct(\StructType\HeaderInformation $headerInformation = null, array $measurementSiteTable = array(), \StructType\ExtensionType $measurementSiteTablePublicationExtension = null)
    {
        $this
            ->setHeaderInformation($headerInformation)
            ->setMeasurementSiteTable($measurementSiteTable)
            ->setMeasurementSiteTablePublicationExtension($measurementSiteTablePublicationExtension);
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\MeasurementSiteTablePublication
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get measurementSiteTable value
     * @return \StructType\MeasurementSiteTable[]|null
     */
    public function getMeasurementSiteTable()
    {
        return $this->measurementSiteTable;
    }
    /**
     * Set measurementSiteTable value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSiteTable[] $measurementSiteTable
     * @return \StructType\MeasurementSiteTablePublication
     */
    public function setMeasurementSiteTable(array $measurementSiteTable = array())
    {
        foreach ($measurementSiteTable as $measurementSiteTablePublicationMeasurementSiteTableItem) {
            // validation for constraint: itemType
            if (!$measurementSiteTablePublicationMeasurementSiteTableItem instanceof \StructType\MeasurementSiteTable) {
                throw new \InvalidArgumentException(sprintf('The measurementSiteTable property can only contain items of \StructType\MeasurementSiteTable, "%s" given', is_object($measurementSiteTablePublicationMeasurementSiteTableItem) ? get_class($measurementSiteTablePublicationMeasurementSiteTableItem) : gettype($measurementSiteTablePublicationMeasurementSiteTableItem)), __LINE__);
            }
        }
        $this->measurementSiteTable = $measurementSiteTable;
        return $this;
    }
    /**
     * Add item to measurementSiteTable value
     * @throws \InvalidArgumentException
     * @param \StructType\MeasurementSiteTable $item
     * @return \StructType\MeasurementSiteTablePublication
     */
    public function addToMeasurementSiteTable(\StructType\MeasurementSiteTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeasurementSiteTable) {
            throw new \InvalidArgumentException(sprintf('The measurementSiteTable property can only contain items of \StructType\MeasurementSiteTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->measurementSiteTable[] = $item;
        return $this;
    }
    /**
     * Get measurementSiteTablePublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMeasurementSiteTablePublicationExtension()
    {
        return $this->measurementSiteTablePublicationExtension;
    }
    /**
     * Set measurementSiteTablePublicationExtension value
     * @param \StructType\ExtensionType $measurementSiteTablePublicationExtension
     * @return \StructType\MeasurementSiteTablePublication
     */
    public function setMeasurementSiteTablePublicationExtension(\StructType\ExtensionType $measurementSiteTablePublicationExtension = null)
    {
        $this->measurementSiteTablePublicationExtension = $measurementSiteTablePublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeasurementSiteTablePublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
