<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagedCause StructType
 * @subpackage Structs
 */
class ManagedCause extends Cause
{
    /**
     * The managedCause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $managedCause;
    /**
     * The managedCauseExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $managedCauseExtension;
    /**
     * Constructor method for ManagedCause
     * @uses ManagedCause::setManagedCause()
     * @uses ManagedCause::setManagedCauseExtension()
     * @param string $managedCause
     * @param \StructType\ExtensionType $managedCauseExtension
     */
    public function __construct($managedCause = null, \StructType\ExtensionType $managedCauseExtension = null)
    {
        $this
            ->setManagedCause($managedCause)
            ->setManagedCauseExtension($managedCauseExtension);
    }
    /**
     * Get managedCause value
     * @return string|null
     */
    public function getManagedCause()
    {
        return $this->managedCause;
    }
    /**
     * Set managedCause value
     * @param string $managedCause
     * @return \StructType\ManagedCause
     */
    public function setManagedCause($managedCause = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($managedCause) && strlen($managedCause) > 1024) || (is_array($managedCause) && count($managedCause) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($managedCause) ? strlen($managedCause) : count($managedCause)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($managedCause) && !is_string($managedCause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managedCause)), __LINE__);
        }
        $this->managedCause = $managedCause;
        return $this;
    }
    /**
     * Get managedCauseExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getManagedCauseExtension()
    {
        return $this->managedCauseExtension;
    }
    /**
     * Set managedCauseExtension value
     * @param \StructType\ExtensionType $managedCauseExtension
     * @return \StructType\ManagedCause
     */
    public function setManagedCauseExtension(\StructType\ExtensionType $managedCauseExtension = null)
    {
        $this->managedCauseExtension = $managedCauseExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManagedCause
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
