<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaintenanceVehicles StructType
 * @subpackage Structs
 */
class MaintenanceVehicles extends AbstractStructBase
{
    /**
     * The numberOfMaintenanceVehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfMaintenanceVehicles;
    /**
     * The maintenanceVehicleActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $maintenanceVehicleActions;
    /**
     * The maintenanceVehiclesExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $maintenanceVehiclesExtension;
    /**
     * Constructor method for MaintenanceVehicles
     * @uses MaintenanceVehicles::setNumberOfMaintenanceVehicles()
     * @uses MaintenanceVehicles::setMaintenanceVehicleActions()
     * @uses MaintenanceVehicles::setMaintenanceVehiclesExtension()
     * @param int $numberOfMaintenanceVehicles
     * @param string[] $maintenanceVehicleActions
     * @param \StructType\ExtensionType $maintenanceVehiclesExtension
     */
    public function __construct($numberOfMaintenanceVehicles = null, array $maintenanceVehicleActions = array(), \StructType\ExtensionType $maintenanceVehiclesExtension = null)
    {
        $this
            ->setNumberOfMaintenanceVehicles($numberOfMaintenanceVehicles)
            ->setMaintenanceVehicleActions($maintenanceVehicleActions)
            ->setMaintenanceVehiclesExtension($maintenanceVehiclesExtension);
    }
    /**
     * Get numberOfMaintenanceVehicles value
     * @return int|null
     */
    public function getNumberOfMaintenanceVehicles()
    {
        return $this->numberOfMaintenanceVehicles;
    }
    /**
     * Set numberOfMaintenanceVehicles value
     * @param int $numberOfMaintenanceVehicles
     * @return \StructType\MaintenanceVehicles
     */
    public function setNumberOfMaintenanceVehicles($numberOfMaintenanceVehicles = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfMaintenanceVehicles) && !is_numeric($numberOfMaintenanceVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfMaintenanceVehicles)), __LINE__);
        }
        $this->numberOfMaintenanceVehicles = $numberOfMaintenanceVehicles;
        return $this;
    }
    /**
     * Get maintenanceVehicleActions value
     * @return string[]|null
     */
    public function getMaintenanceVehicleActions()
    {
        return $this->maintenanceVehicleActions;
    }
    /**
     * Set maintenanceVehicleActions value
     * @uses \EnumType\MaintenanceVehicleActionsEnum::valueIsValid()
     * @uses \EnumType\MaintenanceVehicleActionsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $maintenanceVehicleActions
     * @return \StructType\MaintenanceVehicles
     */
    public function setMaintenanceVehicleActions(array $maintenanceVehicleActions = array())
    {
        $invalidValues = array();
        foreach ($maintenanceVehicleActions as $maintenanceVehiclesMaintenanceVehicleActionsItem) {
            if (!\EnumType\MaintenanceVehicleActionsEnum::valueIsValid($maintenanceVehiclesMaintenanceVehicleActionsItem)) {
                $invalidValues[] = var_export($maintenanceVehiclesMaintenanceVehicleActionsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\MaintenanceVehicleActionsEnum::getValidValues())), __LINE__);
        }
        $this->maintenanceVehicleActions = $maintenanceVehicleActions;
        return $this;
    }
    /**
     * Add item to maintenanceVehicleActions value
     * @uses \EnumType\MaintenanceVehicleActionsEnum::valueIsValid()
     * @uses \EnumType\MaintenanceVehicleActionsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MaintenanceVehicles
     */
    public function addToMaintenanceVehicleActions($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MaintenanceVehicleActionsEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\MaintenanceVehicleActionsEnum::getValidValues())), __LINE__);
        }
        $this->maintenanceVehicleActions[] = $item;
        return $this;
    }
    /**
     * Get maintenanceVehiclesExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getMaintenanceVehiclesExtension()
    {
        return $this->maintenanceVehiclesExtension;
    }
    /**
     * Set maintenanceVehiclesExtension value
     * @param \StructType\ExtensionType $maintenanceVehiclesExtension
     * @return \StructType\MaintenanceVehicles
     */
    public function setMaintenanceVehiclesExtension(\StructType\ExtensionType $maintenanceVehiclesExtension = null)
    {
        $this->maintenanceVehiclesExtension = $maintenanceVehiclesExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaintenanceVehicles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
